/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.idb;

import co.aikar.idb.ApacheCommonsExceptionUtil;
import co.aikar.idb.Database;
import co.aikar.idb.DbRow;
import co.aikar.idb.TransactionCallback;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;

public final class DB {
    private static final Pattern NEWLINE = Pattern.compile("\n");
    private static Database globalDatabase;

    private DB() {
    }

    public static synchronized Database getGlobalDatabase() {
        return globalDatabase;
    }

    public static synchronized void setGlobalDatabase(Database database) {
        globalDatabase = database;
    }

    public static synchronized void close() {
        DB.close(120L, TimeUnit.SECONDS);
    }

    public static synchronized void close(long timeout, TimeUnit unit) {
        if (globalDatabase != null) {
            globalDatabase.close(timeout, unit);
            globalDatabase = null;
        }
    }

    public static DbRow getFirstRow(@Language(value="SQL") String query, Object ... params) throws SQLException {
        return globalDatabase.getFirstRow(query, params);
    }

    public static CompletableFuture<DbRow> getFirstRowAsync(@Language(value="SQL") String query, Object ... params) {
        return globalDatabase.getFirstRowAsync(query, params);
    }

    public static <T> T getFirstColumn(@Language(value="SQL") String query, Object ... params) throws SQLException {
        return globalDatabase.getFirstColumn(query, params);
    }

    public static <T> CompletableFuture<T> getFirstColumnAsync(@Language(value="SQL") String query, Object ... params) {
        return globalDatabase.getFirstColumnAsync(query, params);
    }

    public static <T> List<T> getFirstColumnResults(@Language(value="SQL") String query, Object ... params) throws SQLException {
        return globalDatabase.getFirstColumnResults(query, params);
    }

    public static <T> CompletableFuture<List<T>> getFirstColumnResultsAsync(@Language(value="SQL") String query, Object ... params) {
        return globalDatabase.getFirstColumnResultsAsync(query, params);
    }

    public static List<DbRow> getResults(@Language(value="SQL") String query, Object ... params) throws SQLException {
        return globalDatabase.getResults(query, params);
    }

    public static CompletableFuture<List<DbRow>> getResultsAsync(@Language(value="SQL") String query, Object ... params) {
        return globalDatabase.getResultsAsync(query, params);
    }

    public static Long executeInsert(@Language(value="SQL") String query, Object ... params) throws SQLException {
        return globalDatabase.executeInsert(query, params);
    }

    public static int executeUpdate(@Language(value="SQL") String query, Object ... params) throws SQLException {
        return globalDatabase.executeUpdate(query, params);
    }

    public static CompletableFuture<Integer> executeUpdateAsync(@Language(value="SQL") String query, Object ... params) {
        return globalDatabase.executeUpdateAsync(query, params);
    }

    private static synchronized <T> CompletableFuture<T> dispatchAsync(Callable<T> task) {
        return globalDatabase.dispatchAsync(task);
    }

    public static void createTransactionAsync(TransactionCallback run) {
        globalDatabase.createTransactionAsync(run, null, null);
    }

    public static void createTransactionAsync(TransactionCallback run, Runnable onSuccess, Runnable onFail) {
        globalDatabase.createTransactionAsync(run, onSuccess, onFail);
    }

    public static boolean createTransaction(TransactionCallback run) {
        return globalDatabase.createTransaction(run);
    }

    public static void logException(Exception e) {
        globalDatabase.logException(e.getMessage(), e);
    }

    public static void logException(String message, Exception e) {
        globalDatabase.logException(message, e);
    }

    public static void fatalError(Exception e) {
        globalDatabase.fatalError(e);
    }

    public static void logException(Logger logger, Level logLevel, String message, Exception e) {
        logger.log(logLevel, message);
        if (e != null) {
            for (String line : NEWLINE.split(ApacheCommonsExceptionUtil.getFullStackTrace(e))) {
                logger.log(logLevel, line);
            }
        }
    }
}

