/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.idb;

import co.aikar.idb.DB;
import co.aikar.idb.DatabaseOptions;
import co.aikar.idb.DatabaseTiming;
import co.aikar.idb.DbRow;
import co.aikar.idb.DbStatement;
import co.aikar.idb.TransactionCallback;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.intellij.lang.annotations.Language;

public interface Database {
    default public void close() {
        this.close(120L, TimeUnit.SECONDS);
    }

    public void close(long var1, TimeUnit var3);

    public <T> CompletableFuture<T> dispatchAsync(Callable<T> var1);

    public Connection getConnection() throws SQLException;

    public DatabaseTiming timings(String var1);

    public Logger getLogger();

    public DatabaseOptions getOptions();

    default public void fatalError(Exception e) {
        this.getOptions().onFatalError.accept(e);
    }

    default public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    default public DbStatement createStatement() throws SQLException {
        return new DbStatement(this);
    }

    default public DbStatement query(@Language(value="SQL") String query) throws SQLException {
        DbStatement stm = new DbStatement(this);
        try {
            stm.query(query);
            return stm;
        }
        catch (Exception e) {
            stm.close();
            throw e;
        }
    }

    default public CompletableFuture<DbStatement> queryAsync(@Language(value="SQL") String query) {
        return this.dispatchAsync(() -> new DbStatement(this).query(query));
    }

    default public DbRow getFirstRow(@Language(value="SQL") String query, Object ... params) throws SQLException {
        try (DbStatement statement = this.query(query);){
            statement.execute(params);
            DbRow dbRow = statement.getNextRow();
            return dbRow;
        }
    }

    default public CompletableFuture<DbRow> getFirstRowAsync(@Language(value="SQL") String query, Object ... params) {
        return this.dispatchAsync(() -> this.getFirstRow(query, params));
    }

    default public <T> T getFirstColumn(@Language(value="SQL") String query, Object ... params) throws SQLException {
        try (DbStatement statement = this.query(query);){
            statement.execute(params);
            Object t = statement.getFirstColumn();
            return t;
        }
    }

    default public <T> CompletableFuture<T> getFirstColumnAsync(@Language(value="SQL") String query, Object ... params) {
        return this.dispatchAsync(() -> this.getFirstColumn(query, params));
    }

    default public <T> List<T> getFirstColumnResults(@Language(value="SQL") String query, Object ... params) throws SQLException {
        ArrayList dbRows = new ArrayList();
        try (DbStatement statement = this.query(query);){
            Object result;
            statement.execute(params);
            while ((result = statement.getFirstColumn()) != null) {
                dbRows.add(result);
            }
        }
        return dbRows;
    }

    default public <T> CompletableFuture<List<T>> getFirstColumnResultsAsync(@Language(value="SQL") String query, Object ... params) {
        return this.dispatchAsync(() -> this.getFirstColumnResults(query, params));
    }

    default public List<DbRow> getResults(@Language(value="SQL") String query, Object ... params) throws SQLException {
        try (DbStatement statement = this.query(query);){
            statement.execute(params);
            ArrayList<DbRow> arrayList = statement.getResults();
            return arrayList;
        }
    }

    default public CompletableFuture<List<DbRow>> getResultsAsync(@Language(value="SQL") String query, Object ... params) {
        return this.dispatchAsync(() -> this.getResults(query, params));
    }

    default public Long executeInsert(@Language(value="SQL") String query, Object ... params) throws SQLException {
        try (DbStatement statement = this.query(query);){
            int i = statement.executeUpdate(params);
            if (i > 0) {
                Long l = statement.getLastInsertId();
                return l;
            }
        }
        return null;
    }

    default public int executeUpdate(@Language(value="SQL") String query, Object ... params) throws SQLException {
        try (DbStatement statement = this.query(query);){
            int n = statement.executeUpdate(params);
            return n;
        }
    }

    default public CompletableFuture<Integer> executeUpdateAsync(@Language(value="SQL") String query, Object ... params) {
        return this.dispatchAsync(() -> this.executeUpdate(query, params));
    }

    default public void createTransactionAsync(TransactionCallback run) {
        this.createTransactionAsync(run, null, null);
    }

    default public void createTransactionAsync(TransactionCallback run, Runnable onSuccess, Runnable onFail) {
        this.dispatchAsync(() -> {
            if (!this.createTransaction(run)) {
                if (onFail != null) {
                    onFail.run();
                }
            } else if (onSuccess != null) {
                onSuccess.run();
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public boolean createTransaction(TransactionCallback run) {
        try (DbStatement stm = new DbStatement(this);){
            stm.startTransaction();
            if (!run.apply(stm).booleanValue()) {
                stm.rollback();
                boolean bl = false;
                return bl;
            }
            stm.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e2) {
            DB.logException(e2);
        }
        return false;
    }

    default public void logException(String message, Exception e) {
        DB.logException(this.getLogger(), Level.SEVERE, message, e);
    }

    default public void logException(Exception e) {
        DB.logException(this.getLogger(), Level.SEVERE, e.getMessage(), e);
    }
}

