/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.idb;

import co.aikar.idb.DB;
import co.aikar.idb.DatabaseTiming;
import co.aikar.idb.NullDatabaseTiming;
import co.aikar.idb.TimingsProvider;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.logging.Logger;
import lombok.NonNull;

public class DatabaseOptions {
    private static final DatabaseTiming NULL_TIMING = new NullDatabaseTiming();
    @NonNull
    String dsn;
    @NonNull
    String driverClassName;
    String dataSourceClassName;
    String defaultIsolationLevel;
    boolean favorDataSourceOverDriver;
    String poolName;
    boolean useOptimizations;
    int minAsyncThreads;
    int maxAsyncThreads;
    int asyncThreadTimeout;
    TimingsProvider timingsProvider;
    Consumer<Exception> onFatalError;
    Consumer<Exception> onDatabaseConnectionFailure;
    String user;
    String pass;
    Logger logger;
    ExecutorService executor;

    private static boolean $default$favorDataSourceOverDriver() {
        return true;
    }

    private static String $default$poolName() {
        return "DB";
    }

    private static boolean $default$useOptimizations() {
        return true;
    }

    private static int $default$minAsyncThreads() {
        return Math.min(Runtime.getRuntime().availableProcessors(), 2);
    }

    private static int $default$maxAsyncThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static int $default$asyncThreadTimeout() {
        return 60;
    }

    private static TimingsProvider $default$timingsProvider() {
        return (name, parent) -> NULL_TIMING;
    }

    private static Consumer<Exception> $default$onFatalError() {
        return DB::logException;
    }

    private static Consumer<Exception> $default$onDatabaseConnectionFailure() {
        return DB::logException;
    }

    DatabaseOptions(@NonNull String dsn, @NonNull String driverClassName, String dataSourceClassName, String defaultIsolationLevel, boolean favorDataSourceOverDriver, String poolName, boolean useOptimizations, int minAsyncThreads, int maxAsyncThreads, int asyncThreadTimeout, TimingsProvider timingsProvider, Consumer<Exception> onFatalError, Consumer<Exception> onDatabaseConnectionFailure, String user, String pass, Logger logger, ExecutorService executor) {
        if (dsn == null) {
            throw new NullPointerException("dsn is marked non-null but is null");
        }
        if (driverClassName == null) {
            throw new NullPointerException("driverClassName is marked non-null but is null");
        }
        this.dsn = dsn;
        this.driverClassName = driverClassName;
        this.dataSourceClassName = dataSourceClassName;
        this.defaultIsolationLevel = defaultIsolationLevel;
        this.favorDataSourceOverDriver = favorDataSourceOverDriver;
        this.poolName = poolName;
        this.useOptimizations = useOptimizations;
        this.minAsyncThreads = minAsyncThreads;
        this.maxAsyncThreads = maxAsyncThreads;
        this.asyncThreadTimeout = asyncThreadTimeout;
        this.timingsProvider = timingsProvider;
        this.onFatalError = onFatalError;
        this.onDatabaseConnectionFailure = onDatabaseConnectionFailure;
        this.user = user;
        this.pass = pass;
        this.logger = logger;
        this.executor = executor;
    }

    public static DatabaseOptionsBuilder builder() {
        return new DatabaseOptionsBuilder();
    }

    public DatabaseOptionsBuilder toBuilder() {
        return new DatabaseOptionsBuilder().dsn(this.dsn).driverClassName(this.driverClassName).dataSourceClassName(this.dataSourceClassName).defaultIsolationLevel(this.defaultIsolationLevel).favorDataSourceOverDriver(this.favorDataSourceOverDriver).poolName(this.poolName).useOptimizations(this.useOptimizations).minAsyncThreads(this.minAsyncThreads).maxAsyncThreads(this.maxAsyncThreads).asyncThreadTimeout(this.asyncThreadTimeout).timingsProvider(this.timingsProvider).onFatalError(this.onFatalError).onDatabaseConnectionFailure(this.onDatabaseConnectionFailure).user(this.user).pass(this.pass).logger(this.logger).executor(this.executor);
    }

    @NonNull
    public String getDsn() {
        return this.dsn;
    }

    @NonNull
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public String getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    public boolean isFavorDataSourceOverDriver() {
        return this.favorDataSourceOverDriver;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public boolean isUseOptimizations() {
        return this.useOptimizations;
    }

    public int getMinAsyncThreads() {
        return this.minAsyncThreads;
    }

    public int getMaxAsyncThreads() {
        return this.maxAsyncThreads;
    }

    public int getAsyncThreadTimeout() {
        return this.asyncThreadTimeout;
    }

    public TimingsProvider getTimingsProvider() {
        return this.timingsProvider;
    }

    public Consumer<Exception> getOnFatalError() {
        return this.onFatalError;
    }

    public Consumer<Exception> getOnDatabaseConnectionFailure() {
        return this.onDatabaseConnectionFailure;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setDsn(@NonNull String dsn) {
        if (dsn == null) {
            throw new NullPointerException("dsn is marked non-null but is null");
        }
        this.dsn = dsn;
    }

    public void setDriverClassName(@NonNull String driverClassName) {
        if (driverClassName == null) {
            throw new NullPointerException("driverClassName is marked non-null but is null");
        }
        this.driverClassName = driverClassName;
    }

    public void setDataSourceClassName(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    public void setDefaultIsolationLevel(String defaultIsolationLevel) {
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    public void setFavorDataSourceOverDriver(boolean favorDataSourceOverDriver) {
        this.favorDataSourceOverDriver = favorDataSourceOverDriver;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setUseOptimizations(boolean useOptimizations) {
        this.useOptimizations = useOptimizations;
    }

    public void setMinAsyncThreads(int minAsyncThreads) {
        this.minAsyncThreads = minAsyncThreads;
    }

    public void setMaxAsyncThreads(int maxAsyncThreads) {
        this.maxAsyncThreads = maxAsyncThreads;
    }

    public void setAsyncThreadTimeout(int asyncThreadTimeout) {
        this.asyncThreadTimeout = asyncThreadTimeout;
    }

    public void setTimingsProvider(TimingsProvider timingsProvider) {
        this.timingsProvider = timingsProvider;
    }

    public void setOnFatalError(Consumer<Exception> onFatalError) {
        this.onFatalError = onFatalError;
    }

    public void setOnDatabaseConnectionFailure(Consumer<Exception> onDatabaseConnectionFailure) {
        this.onDatabaseConnectionFailure = onDatabaseConnectionFailure;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseOptions)) {
            return false;
        }
        DatabaseOptions other = (DatabaseOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dsn = this.getDsn();
        String other$dsn = other.getDsn();
        if (this$dsn == null ? other$dsn != null : !this$dsn.equals(other$dsn)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        String this$dataSourceClassName = this.getDataSourceClassName();
        String other$dataSourceClassName = other.getDataSourceClassName();
        if (this$dataSourceClassName == null ? other$dataSourceClassName != null : !this$dataSourceClassName.equals(other$dataSourceClassName)) {
            return false;
        }
        String this$defaultIsolationLevel = this.getDefaultIsolationLevel();
        String other$defaultIsolationLevel = other.getDefaultIsolationLevel();
        if (this$defaultIsolationLevel == null ? other$defaultIsolationLevel != null : !this$defaultIsolationLevel.equals(other$defaultIsolationLevel)) {
            return false;
        }
        if (this.isFavorDataSourceOverDriver() != other.isFavorDataSourceOverDriver()) {
            return false;
        }
        String this$poolName = this.getPoolName();
        String other$poolName = other.getPoolName();
        if (this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName)) {
            return false;
        }
        if (this.isUseOptimizations() != other.isUseOptimizations()) {
            return false;
        }
        if (this.getMinAsyncThreads() != other.getMinAsyncThreads()) {
            return false;
        }
        if (this.getMaxAsyncThreads() != other.getMaxAsyncThreads()) {
            return false;
        }
        if (this.getAsyncThreadTimeout() != other.getAsyncThreadTimeout()) {
            return false;
        }
        TimingsProvider this$timingsProvider = this.getTimingsProvider();
        TimingsProvider other$timingsProvider = other.getTimingsProvider();
        if (this$timingsProvider == null ? other$timingsProvider != null : !this$timingsProvider.equals(other$timingsProvider)) {
            return false;
        }
        Consumer<Exception> this$onFatalError = this.getOnFatalError();
        Consumer<Exception> other$onFatalError = other.getOnFatalError();
        if (this$onFatalError == null ? other$onFatalError != null : !this$onFatalError.equals(other$onFatalError)) {
            return false;
        }
        Consumer<Exception> this$onDatabaseConnectionFailure = this.getOnDatabaseConnectionFailure();
        Consumer<Exception> other$onDatabaseConnectionFailure = other.getOnDatabaseConnectionFailure();
        if (this$onDatabaseConnectionFailure == null ? other$onDatabaseConnectionFailure != null : !this$onDatabaseConnectionFailure.equals(other$onDatabaseConnectionFailure)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$pass = this.getPass();
        String other$pass = other.getPass();
        if (this$pass == null ? other$pass != null : !this$pass.equals(other$pass)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dsn = this.getDsn();
        result = result * 59 + ($dsn == null ? 43 : $dsn.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        String $dataSourceClassName = this.getDataSourceClassName();
        result = result * 59 + ($dataSourceClassName == null ? 43 : $dataSourceClassName.hashCode());
        String $defaultIsolationLevel = this.getDefaultIsolationLevel();
        result = result * 59 + ($defaultIsolationLevel == null ? 43 : $defaultIsolationLevel.hashCode());
        result = result * 59 + (this.isFavorDataSourceOverDriver() ? 79 : 97);
        String $poolName = this.getPoolName();
        result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
        result = result * 59 + (this.isUseOptimizations() ? 79 : 97);
        result = result * 59 + this.getMinAsyncThreads();
        result = result * 59 + this.getMaxAsyncThreads();
        result = result * 59 + this.getAsyncThreadTimeout();
        TimingsProvider $timingsProvider = this.getTimingsProvider();
        result = result * 59 + ($timingsProvider == null ? 43 : $timingsProvider.hashCode());
        Consumer<Exception> $onFatalError = this.getOnFatalError();
        result = result * 59 + ($onFatalError == null ? 43 : $onFatalError.hashCode());
        Consumer<Exception> $onDatabaseConnectionFailure = this.getOnDatabaseConnectionFailure();
        result = result * 59 + ($onDatabaseConnectionFailure == null ? 43 : $onDatabaseConnectionFailure.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $pass = this.getPass();
        result = result * 59 + ($pass == null ? 43 : $pass.hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseOptions(dsn=" + this.getDsn() + ", driverClassName=" + this.getDriverClassName() + ", dataSourceClassName=" + this.getDataSourceClassName() + ", defaultIsolationLevel=" + this.getDefaultIsolationLevel() + ", favorDataSourceOverDriver=" + this.isFavorDataSourceOverDriver() + ", poolName=" + this.getPoolName() + ", useOptimizations=" + this.isUseOptimizations() + ", minAsyncThreads=" + this.getMinAsyncThreads() + ", maxAsyncThreads=" + this.getMaxAsyncThreads() + ", asyncThreadTimeout=" + this.getAsyncThreadTimeout() + ", timingsProvider=" + this.getTimingsProvider() + ", onFatalError=" + this.getOnFatalError() + ", onDatabaseConnectionFailure=" + this.getOnDatabaseConnectionFailure() + ", user=" + this.getUser() + ", pass=" + this.getPass() + ", logger=" + this.getLogger() + ", executor=" + this.getExecutor() + ")";
    }

    public static class DatabaseOptionsBuilder {
        private String dsn;
        private String driverClassName;
        private String dataSourceClassName;
        private String defaultIsolationLevel;
        private boolean favorDataSourceOverDriver$set;
        private boolean favorDataSourceOverDriver$value;
        private boolean poolName$set;
        private String poolName$value;
        private boolean useOptimizations$set;
        private boolean useOptimizations$value;
        private boolean minAsyncThreads$set;
        private int minAsyncThreads$value;
        private boolean maxAsyncThreads$set;
        private int maxAsyncThreads$value;
        private boolean asyncThreadTimeout$set;
        private int asyncThreadTimeout$value;
        private boolean timingsProvider$set;
        private TimingsProvider timingsProvider$value;
        private boolean onFatalError$set;
        private Consumer<Exception> onFatalError$value;
        private boolean onDatabaseConnectionFailure$set;
        private Consumer<Exception> onDatabaseConnectionFailure$value;
        private String user;
        private String pass;
        private Logger logger;
        private ExecutorService executor;

        public DatabaseOptionsBuilder mysql(@NonNull String user, @NonNull String pass, @NonNull String db, @NonNull String hostAndPort) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            if (pass == null) {
                throw new NullPointerException("pass is marked non-null but is null");
            }
            if (db == null) {
                throw new NullPointerException("db is marked non-null but is null");
            }
            if (hostAndPort == null) {
                throw new NullPointerException("hostAndPort is marked non-null but is null");
            }
            if (hostAndPort == null) {
                hostAndPort = "localhost:3306";
            }
            this.user = user;
            this.pass = pass;
            if (this.defaultIsolationLevel == null) {
                this.defaultIsolationLevel = "TRANSACTION_READ_COMMITTED";
            }
            if (this.dataSourceClassName == null) {
                this.tryDataSourceClassName("org.mariadb.jdbc.MariaDbDataSource");
            }
            if (this.dataSourceClassName == null) {
                this.tryDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
            }
            if (this.dataSourceClassName == null) {
                this.tryDataSourceClassName("com.mysql.cj.jdbc.MysqlDataSource");
            }
            if (this.driverClassName == null) {
                this.tryDriverClassName("org.mariadb.jdbc.Driver");
            }
            if (this.driverClassName == null) {
                this.tryDriverClassName("com.mysql.cj.jdbc.Driver");
            }
            if (this.driverClassName == null) {
                this.tryDriverClassName("com.mysql.jdbc.Driver");
            }
            this.dsn = "mysql://" + hostAndPort + "/" + db;
            return this;
        }

        public DatabaseOptionsBuilder sqlite(@NonNull String fileName) {
            if (fileName == null) {
                throw new NullPointerException("fileName is marked non-null but is null");
            }
            if (this.defaultIsolationLevel == null) {
                this.defaultIsolationLevel = "TRANSACTION_SERIALIZABLE";
            }
            if (this.dataSourceClassName == null) {
                this.tryDataSourceClassName("org.sqlite.SQLiteDataSource");
            }
            if (this.driverClassName == null) {
                this.tryDriverClassName("org.sqlite.JDBC");
            }
            this.dsn = "sqlite:" + fileName;
            return this;
        }

        public DatabaseOptionsBuilder tryDriverClassName(@NonNull String className) {
            if (className == null) {
                throw new NullPointerException("className is marked non-null but is null");
            }
            try {
                this.driverClassName(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        public DatabaseOptionsBuilder tryDataSourceClassName(@NonNull String className) {
            if (className == null) {
                throw new NullPointerException("className is marked non-null but is null");
            }
            try {
                this.dataSourceClassName(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        public DatabaseOptionsBuilder driverClassName(@NonNull String className) {
            if (className == null) {
                throw new NullPointerException("className is marked non-null but is null");
            }
            try {
                Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            this.driverClassName = className;
            return this;
        }

        public DatabaseOptionsBuilder dataSourceClassName(@NonNull String className) {
            if (className == null) {
                throw new NullPointerException("className is marked non-null but is null");
            }
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.dataSourceClassName = className;
            return this;
        }

        DatabaseOptionsBuilder() {
        }

        public DatabaseOptionsBuilder dsn(@NonNull String dsn) {
            if (dsn == null) {
                throw new NullPointerException("dsn is marked non-null but is null");
            }
            this.dsn = dsn;
            return this;
        }

        public DatabaseOptionsBuilder defaultIsolationLevel(String defaultIsolationLevel) {
            this.defaultIsolationLevel = defaultIsolationLevel;
            return this;
        }

        public DatabaseOptionsBuilder favorDataSourceOverDriver(boolean favorDataSourceOverDriver) {
            this.favorDataSourceOverDriver$value = favorDataSourceOverDriver;
            this.favorDataSourceOverDriver$set = true;
            return this;
        }

        public DatabaseOptionsBuilder poolName(String poolName) {
            this.poolName$value = poolName;
            this.poolName$set = true;
            return this;
        }

        public DatabaseOptionsBuilder useOptimizations(boolean useOptimizations) {
            this.useOptimizations$value = useOptimizations;
            this.useOptimizations$set = true;
            return this;
        }

        public DatabaseOptionsBuilder minAsyncThreads(int minAsyncThreads) {
            this.minAsyncThreads$value = minAsyncThreads;
            this.minAsyncThreads$set = true;
            return this;
        }

        public DatabaseOptionsBuilder maxAsyncThreads(int maxAsyncThreads) {
            this.maxAsyncThreads$value = maxAsyncThreads;
            this.maxAsyncThreads$set = true;
            return this;
        }

        public DatabaseOptionsBuilder asyncThreadTimeout(int asyncThreadTimeout) {
            this.asyncThreadTimeout$value = asyncThreadTimeout;
            this.asyncThreadTimeout$set = true;
            return this;
        }

        public DatabaseOptionsBuilder timingsProvider(TimingsProvider timingsProvider) {
            this.timingsProvider$value = timingsProvider;
            this.timingsProvider$set = true;
            return this;
        }

        public DatabaseOptionsBuilder onFatalError(Consumer<Exception> onFatalError) {
            this.onFatalError$value = onFatalError;
            this.onFatalError$set = true;
            return this;
        }

        public DatabaseOptionsBuilder onDatabaseConnectionFailure(Consumer<Exception> onDatabaseConnectionFailure) {
            this.onDatabaseConnectionFailure$value = onDatabaseConnectionFailure;
            this.onDatabaseConnectionFailure$set = true;
            return this;
        }

        public DatabaseOptionsBuilder user(String user) {
            this.user = user;
            return this;
        }

        public DatabaseOptionsBuilder pass(String pass) {
            this.pass = pass;
            return this;
        }

        public DatabaseOptionsBuilder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public DatabaseOptionsBuilder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public DatabaseOptions build() {
            boolean favorDataSourceOverDriver$value = this.favorDataSourceOverDriver$value;
            if (!this.favorDataSourceOverDriver$set) {
                favorDataSourceOverDriver$value = DatabaseOptions.$default$favorDataSourceOverDriver();
            }
            String poolName$value = this.poolName$value;
            if (!this.poolName$set) {
                poolName$value = DatabaseOptions.$default$poolName();
            }
            boolean useOptimizations$value = this.useOptimizations$value;
            if (!this.useOptimizations$set) {
                useOptimizations$value = DatabaseOptions.$default$useOptimizations();
            }
            int minAsyncThreads$value = this.minAsyncThreads$value;
            if (!this.minAsyncThreads$set) {
                minAsyncThreads$value = DatabaseOptions.$default$minAsyncThreads();
            }
            int maxAsyncThreads$value = this.maxAsyncThreads$value;
            if (!this.maxAsyncThreads$set) {
                maxAsyncThreads$value = DatabaseOptions.$default$maxAsyncThreads();
            }
            int asyncThreadTimeout$value = this.asyncThreadTimeout$value;
            if (!this.asyncThreadTimeout$set) {
                asyncThreadTimeout$value = DatabaseOptions.$default$asyncThreadTimeout();
            }
            TimingsProvider timingsProvider$value = this.timingsProvider$value;
            if (!this.timingsProvider$set) {
                timingsProvider$value = DatabaseOptions.$default$timingsProvider();
            }
            Consumer onFatalError$value = this.onFatalError$value;
            if (!this.onFatalError$set) {
                onFatalError$value = DatabaseOptions.$default$onFatalError();
            }
            Consumer onDatabaseConnectionFailure$value = this.onDatabaseConnectionFailure$value;
            if (!this.onDatabaseConnectionFailure$set) {
                onDatabaseConnectionFailure$value = DatabaseOptions.$default$onDatabaseConnectionFailure();
            }
            return new DatabaseOptions(this.dsn, this.driverClassName, this.dataSourceClassName, this.defaultIsolationLevel, favorDataSourceOverDriver$value, poolName$value, useOptimizations$value, minAsyncThreads$value, maxAsyncThreads$value, asyncThreadTimeout$value, timingsProvider$value, onFatalError$value, onDatabaseConnectionFailure$value, this.user, this.pass, this.logger, this.executor);
        }

        public String toString() {
            return "DatabaseOptions.DatabaseOptionsBuilder(dsn=" + this.dsn + ", driverClassName=" + this.driverClassName + ", dataSourceClassName=" + this.dataSourceClassName + ", defaultIsolationLevel=" + this.defaultIsolationLevel + ", favorDataSourceOverDriver$value=" + this.favorDataSourceOverDriver$value + ", poolName$value=" + this.poolName$value + ", useOptimizations$value=" + this.useOptimizations$value + ", minAsyncThreads$value=" + this.minAsyncThreads$value + ", maxAsyncThreads$value=" + this.maxAsyncThreads$value + ", asyncThreadTimeout$value=" + this.asyncThreadTimeout$value + ", timingsProvider$value=" + this.timingsProvider$value + ", onFatalError$value=" + this.onFatalError$value + ", onDatabaseConnectionFailure$value=" + this.onDatabaseConnectionFailure$value + ", user=" + this.user + ", pass=" + this.pass + ", logger=" + this.logger + ", executor=" + this.executor + ")";
        }
    }
}

