/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.idb;

import co.aikar.idb.DB;
import co.aikar.idb.Database;
import co.aikar.idb.DatabaseTiming;
import co.aikar.idb.DbRow;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;

public class DbStatement
implements AutoCloseable {
    private Database db;
    private Connection dbConn;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;
    private String[] resultCols;
    public String query = "";
    private volatile boolean isDirty = false;
    private final List<Consumer<DbStatement>> onCommit = new ArrayList<Consumer<DbStatement>>(0);
    private final List<Consumer<DbStatement>> onRollback = new ArrayList<Consumer<DbStatement>>(0);

    public DbStatement() throws SQLException {
        this(DB.getGlobalDatabase());
    }

    public DbStatement(Database db) throws SQLException {
        this.db = db;
        this.dbConn = db.getConnection();
        if (this.dbConn == null) {
            db.fatalError(new SQLException("We do not have a database"));
        }
    }

    public void startTransaction() throws SQLException {
        try (DatabaseTiming ignored = this.db.timings("startTransaction");){
            this.dbConn.setAutoCommit(false);
            this.isDirty = true;
        }
    }

    public void commit() throws SQLException {
        if (!this.isDirty) {
            return;
        }
        try (DatabaseTiming ignored = this.db.timings("commit");){
            this.isDirty = false;
            this.dbConn.commit();
            this.dbConn.setAutoCommit(true);
            this.runEvents(this.onCommit);
        }
    }

    private synchronized void runEvents(List<Consumer<DbStatement>> runnables) {
        runnables.forEach(run -> {
            try {
                run.accept(this);
            }
            catch (Exception e) {
                DB.logException("Exception on transaction runnable", e);
            }
        });
        this.onCommit.clear();
        this.onRollback.clear();
    }

    public synchronized void rollback() throws SQLException {
        if (!this.isDirty) {
            return;
        }
        try (DatabaseTiming ignored = this.db.timings("rollback");){
            this.isDirty = false;
            this.dbConn.rollback();
            this.dbConn.setAutoCommit(true);
            this.runEvents(this.onRollback);
        }
    }

    public boolean inTransaction() {
        return this.isDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onCommit(Consumer<DbStatement> run) {
        List<Consumer<DbStatement>> list = this.onCommit;
        synchronized (list) {
            this.onCommit.add(run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onRollback(Consumer<DbStatement> run) {
        List<Consumer<DbStatement>> list = this.onRollback;
        synchronized (list) {
            this.onRollback.add(run);
        }
    }

    public DbStatement query(@Language(value="SQL") String query) throws SQLException {
        this.query = query;
        try (DatabaseTiming ignored = this.db.timings("query: " + query);){
            this.closeStatement();
            try {
                this.preparedStatement = this.dbConn.prepareStatement(query, 1);
            }
            catch (SQLException e) {
                this.close();
                throw e;
            }
        }
        return this;
    }

    public ArrayList<DbRow> executeQueryGetResults(@Language(value="SQL") String query, Object ... params) throws SQLException {
        this.query(query);
        this.execute(params);
        return this.getResults();
    }

    public int executeUpdateQuery(@Language(value="SQL") String query, Object ... params) throws SQLException {
        this.query(query);
        return this.executeUpdate(params);
    }

    public DbRow executeQueryGetFirstRow(@Language(value="SQL") String query, Object ... params) throws SQLException {
        this.query(query);
        this.execute(params);
        return this.getNextRow();
    }

    public <T> T executeQueryGetFirstColumn(@Language(value="SQL") String query, Object ... params) throws SQLException {
        this.query(query);
        this.execute(params);
        return this.getFirstColumn();
    }

    public <T> List<T> executeQueryGetFirstColumnResults(@Language(value="SQL") String query, Object ... params) throws SQLException {
        T result;
        this.query(query);
        this.execute(params);
        ArrayList<T> dbRows = new ArrayList<T>();
        while ((result = this.getFirstColumn()) != null) {
            dbRows.add(result);
        }
        return dbRows;
    }

    private void prepareExecute(Object ... params) throws SQLException {
        try (DatabaseTiming ignored = this.db.timings("prepareExecute: " + this.query);){
            this.closeResult();
            if (this.preparedStatement == null) {
                throw new IllegalStateException("Run Query first on statement before executing!");
            }
            for (int i = 0; i < params.length; ++i) {
                this.preparedStatement.setObject(i + 1, params[i]);
            }
        }
    }

    public int executeUpdate(Object ... params) throws SQLException {
        DatabaseTiming ignored = this.db.timings("executeUpdate: " + this.query);
        try {
            this.prepareExecute(params);
            int result = this.preparedStatement.executeUpdate();
            if (!this.isDirty) {
                this.runEvents(this.onCommit);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (!this.isDirty) {
                this.runEvents(this.onRollback);
            }
            this.close();
            throw e;
        }
        finally {
            if (ignored != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public DbStatement execute(Object ... params) throws SQLException {
        try (DatabaseTiming ignored = this.db.timings("execute: " + this.query);){
            try {
                this.prepareExecute(params);
                this.resultSet = this.preparedStatement.executeQuery();
                ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
                int numberOfColumns = resultSetMetaData.getColumnCount();
                this.resultCols = new String[numberOfColumns];
                for (int i = 1; i < numberOfColumns + 1; ++i) {
                    this.resultCols[i - 1] = resultSetMetaData.getColumnLabel(i);
                }
            }
            catch (SQLException e) {
                this.close();
                throw e;
            }
        }
        return this;
    }

    public Long getLastInsertId() throws SQLException {
        try (DatabaseTiming ignored = this.db.timings("getLastInsertId");){
            Long l;
            block17: {
                ResultSet genKeys;
                block15: {
                    Long l2;
                    block16: {
                        genKeys = this.preparedStatement.getGeneratedKeys();
                        try {
                            if (genKeys != null) break block15;
                            l2 = null;
                            if (genKeys == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (genKeys != null) {
                                try {
                                    genKeys.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        genKeys.close();
                    }
                    return l2;
                }
                Long result = null;
                if (genKeys.next()) {
                    result = genKeys.getLong(1);
                }
                l = result;
                if (genKeys == null) break block17;
                genKeys.close();
            }
            return l;
        }
    }

    public ArrayList<DbRow> getResults() throws SQLException {
        if (this.resultSet == null) {
            return null;
        }
        try (DatabaseTiming ignored = this.db.timings("getResults");){
            DbRow row;
            ArrayList<DbRow> result = new ArrayList<DbRow>();
            while ((row = this.getNextRow()) != null) {
                result.add(row);
            }
            ArrayList<DbRow> arrayList = result;
            return arrayList;
        }
    }

    public DbRow getNextRow() throws SQLException {
        if (this.resultSet == null) {
            return null;
        }
        ResultSet nextResultSet = this.getNextResultSet();
        if (nextResultSet != null) {
            DbRow row = new DbRow();
            for (String col : this.resultCols) {
                row.put(col, nextResultSet.getObject(col));
            }
            return row;
        }
        return null;
    }

    public <T> T getFirstColumn() throws SQLException {
        ResultSet resultSet = this.getNextResultSet();
        if (resultSet != null) {
            return (T)resultSet.getObject(1);
        }
        return null;
    }

    private ResultSet getNextResultSet() throws SQLException {
        if (this.resultSet != null && this.resultSet.next()) {
            return this.resultSet;
        }
        this.closeResult();
        return null;
    }

    private void closeResult() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }

    private void closeStatement() throws SQLException {
        this.closeResult();
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
            this.preparedStatement = null;
        }
    }

    @Override
    public void close() {
        try (DatabaseTiming ignored = this.db.timings("close");){
            try {
                this.closeStatement();
                if (this.dbConn != null) {
                    if (this.isDirty && !this.dbConn.getAutoCommit()) {
                        DB.logException(new Exception("Statement was not finalized: " + this.query));
                        this.rollback();
                    }
                    this.db.closeConnection(this.dbConn);
                }
            }
            catch (SQLException ex) {
                DB.logException("Failed to close DB connection: " + this.query, ex);
            }
            finally {
                this.dbConn = null;
            }
        }
    }

    public boolean isClosed() throws SQLException {
        return this.dbConn == null || this.dbConn.isClosed();
    }
}

