/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.idb;

import co.aikar.idb.DatabaseOptions;
import co.aikar.idb.HikariPooledDatabase;
import java.util.Map;
import lombok.NonNull;

public class PooledDatabaseOptions {
    int minIdleConnections;
    int maxConnections;
    Map<String, Object> dataSourceProperties;
    @NonNull
    DatabaseOptions options;

    private static int $default$minIdleConnections() {
        return 3;
    }

    private static int $default$maxConnections() {
        return 5;
    }

    PooledDatabaseOptions(int minIdleConnections, int maxConnections, Map<String, Object> dataSourceProperties, @NonNull DatabaseOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.minIdleConnections = minIdleConnections;
        this.maxConnections = maxConnections;
        this.dataSourceProperties = dataSourceProperties;
        this.options = options;
    }

    public static PooledDatabaseOptionsBuilder builder() {
        return new PooledDatabaseOptionsBuilder();
    }

    public PooledDatabaseOptionsBuilder toBuilder() {
        return new PooledDatabaseOptionsBuilder().minIdleConnections(this.minIdleConnections).maxConnections(this.maxConnections).dataSourceProperties(this.dataSourceProperties).options(this.options);
    }

    public int getMinIdleConnections() {
        return this.minIdleConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public Map<String, Object> getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    @NonNull
    public DatabaseOptions getOptions() {
        return this.options;
    }

    public void setMinIdleConnections(int minIdleConnections) {
        this.minIdleConnections = minIdleConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setDataSourceProperties(Map<String, Object> dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }

    public void setOptions(@NonNull DatabaseOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PooledDatabaseOptions)) {
            return false;
        }
        PooledDatabaseOptions other = (PooledDatabaseOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinIdleConnections() != other.getMinIdleConnections()) {
            return false;
        }
        if (this.getMaxConnections() != other.getMaxConnections()) {
            return false;
        }
        Map<String, Object> this$dataSourceProperties = this.getDataSourceProperties();
        Map<String, Object> other$dataSourceProperties = other.getDataSourceProperties();
        if (this$dataSourceProperties == null ? other$dataSourceProperties != null : !((Object)this$dataSourceProperties).equals(other$dataSourceProperties)) {
            return false;
        }
        DatabaseOptions this$options = this.getOptions();
        DatabaseOptions other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PooledDatabaseOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinIdleConnections();
        result = result * 59 + this.getMaxConnections();
        Map<String, Object> $dataSourceProperties = this.getDataSourceProperties();
        result = result * 59 + ($dataSourceProperties == null ? 43 : ((Object)$dataSourceProperties).hashCode());
        DatabaseOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "PooledDatabaseOptions(minIdleConnections=" + this.getMinIdleConnections() + ", maxConnections=" + this.getMaxConnections() + ", dataSourceProperties=" + this.getDataSourceProperties() + ", options=" + this.getOptions() + ")";
    }

    public static class PooledDatabaseOptionsBuilder {
        private boolean minIdleConnections$set;
        private int minIdleConnections$value;
        private boolean maxConnections$set;
        private int maxConnections$value;
        private Map<String, Object> dataSourceProperties;
        private DatabaseOptions options;

        public HikariPooledDatabase createHikariDatabase() {
            return new HikariPooledDatabase(this.build());
        }

        PooledDatabaseOptionsBuilder() {
        }

        public PooledDatabaseOptionsBuilder minIdleConnections(int minIdleConnections) {
            this.minIdleConnections$value = minIdleConnections;
            this.minIdleConnections$set = true;
            return this;
        }

        public PooledDatabaseOptionsBuilder maxConnections(int maxConnections) {
            this.maxConnections$value = maxConnections;
            this.maxConnections$set = true;
            return this;
        }

        public PooledDatabaseOptionsBuilder dataSourceProperties(Map<String, Object> dataSourceProperties) {
            this.dataSourceProperties = dataSourceProperties;
            return this;
        }

        public PooledDatabaseOptionsBuilder options(@NonNull DatabaseOptions options) {
            if (options == null) {
                throw new NullPointerException("options is marked non-null but is null");
            }
            this.options = options;
            return this;
        }

        public PooledDatabaseOptions build() {
            int minIdleConnections$value = this.minIdleConnections$value;
            if (!this.minIdleConnections$set) {
                minIdleConnections$value = PooledDatabaseOptions.$default$minIdleConnections();
            }
            int maxConnections$value = this.maxConnections$value;
            if (!this.maxConnections$set) {
                maxConnections$value = PooledDatabaseOptions.$default$maxConnections();
            }
            return new PooledDatabaseOptions(minIdleConnections$value, maxConnections$value, this.dataSourceProperties, this.options);
        }

        public String toString() {
            return "PooledDatabaseOptions.PooledDatabaseOptionsBuilder(minIdleConnections$value=" + this.minIdleConnections$value + ", maxConnections$value=" + this.maxConnections$value + ", dataSourceProperties=" + this.dataSourceProperties + ", options=" + this.options + ")";
        }
    }
}

