/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane.util;

import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Mask {
    private final boolean[][] mask;

    public Mask(String ... mask) {
        this.mask = new boolean[mask.length][mask.length == 0 ? 0 : mask[0].length()];
        for (int row = 0; row < mask.length; ++row) {
            int length = mask[row].length();
            if (length != this.mask[row].length) {
                throw new IllegalArgumentException("Lengths of each string should be equal");
            }
            for (int column = 0; column < length; ++column) {
                char character = mask[row].charAt(column);
                if (character == '0') {
                    this.mask[row][column] = false;
                    continue;
                }
                if (character == '1') {
                    this.mask[row][column] = true;
                    continue;
                }
                throw new IllegalArgumentException("Strings may only contain '0' and '1'");
            }
        }
    }

    private Mask(boolean[][] mask) {
        this.mask = mask;
    }

    @NotNull
    @Contract(pure=true)
    public Mask setHeight(int height) {
        int index;
        boolean[][] newRows = new boolean[height][this.getLength()];
        for (index = 0; index < Math.min(height, this.getHeight()); ++index) {
            System.arraycopy(this.mask[index], 0, newRows[index], 0, this.mask[index].length);
        }
        for (index = Math.min(height, this.getHeight()); index < height; ++index) {
            newRows[index] = new boolean[this.getLength()];
            Arrays.fill(newRows[index], true);
        }
        return new Mask(newRows);
    }

    @NotNull
    @Contract(pure=true)
    public Mask setLength(int length) {
        boolean[][] newRows = new boolean[this.getHeight()][length];
        for (int index = 0; index < this.mask.length; ++index) {
            boolean[] newRow = new boolean[length];
            System.arraycopy(this.mask[index], 0, newRow, 0, Math.min(length, this.mask[index].length));
            Arrays.fill(newRow, Math.min(length, this.mask[index].length), newRow.length, true);
            newRows[index] = newRow;
        }
        return new Mask(newRows);
    }

    public int amountOfEnabledSlots() {
        int amount = 0;
        boolean[][] blArray = this.mask;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean[] row;
            for (boolean cell : row = blArray[i]) {
                if (!cell) continue;
                ++amount;
            }
        }
        return amount;
    }

    public boolean[] getColumn(int index) {
        boolean[] column = new boolean[this.mask.length];
        for (int i = 0; i < this.getHeight(); ++i) {
            column[i] = this.mask[i][index];
        }
        return column;
    }

    public boolean[] getRow(int index) {
        boolean[] row = this.mask[index];
        return Arrays.copyOf(row, row.length);
    }

    public boolean isEnabled(int x, int y) {
        return this.mask[y][x];
    }

    public int getLength() {
        return this.mask[0].length;
    }

    public int getHeight() {
        return this.mask.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Mask mask = (Mask)object;
        return Arrays.deepEquals((Object[])this.mask, (Object[])mask.mask);
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.mask);
    }

    public String toString() {
        return "Mask{mask=" + Arrays.deepToString((Object[])this.mask) + "}";
    }
}

