/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.util.version;

import com.github.stefvanschie.inventoryframework.abstraction.AnvilInventory;
import com.github.stefvanschie.inventoryframework.abstraction.BeaconInventory;
import com.github.stefvanschie.inventoryframework.abstraction.CartographyTableInventory;
import com.github.stefvanschie.inventoryframework.abstraction.EnchantingTableInventory;
import com.github.stefvanschie.inventoryframework.abstraction.GrindstoneInventory;
import com.github.stefvanschie.inventoryframework.abstraction.MerchantInventory;
import com.github.stefvanschie.inventoryframework.abstraction.SmithingTableInventory;
import com.github.stefvanschie.inventoryframework.abstraction.StonecutterInventory;
import com.github.stefvanschie.inventoryframework.exception.UnsupportedVersionException;
import com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.EnchantingTableInventoryImpl;
import com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.MerchantInventoryImpl;
import com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.SmithingTableInventoryImpl;
import com.github.stefvanschie.inventoryframework.nms.v1_21_4.GrindstoneInventoryImpl;
import com.github.stefvanschie.inventoryframework.nms.v1_21_5.AnvilInventoryImpl;
import com.github.stefvanschie.inventoryframework.nms.v1_21_5.CartographyTableInventoryImpl;
import com.github.stefvanschie.inventoryframework.nms.v1_21_6_8.BeaconInventoryImpl;
import com.github.stefvanschie.inventoryframework.nms.v1_21_6_8.StonecutterInventoryImpl;
import com.github.stefvanschie.inventoryframework.util.version.Version;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class VersionMatcher {
    private static final EnumMap<Version, Class<? extends AnvilInventory>> ANVIL_INVENTORIES = new EnumMap(Version.class);
    private static final EnumMap<Version, Class<? extends BeaconInventory>> BEACON_INVENTORIES;
    private static final EnumMap<Version, Class<? extends CartographyTableInventory>> CARTOGRAPHY_TABLE_INVENTORIES;
    private static final EnumMap<Version, Class<? extends EnchantingTableInventory>> ENCHANTING_TABLE_INVENTORIES;
    private static final EnumMap<Version, Class<? extends GrindstoneInventory>> GRINDSTONE_INVENTORIES;
    private static final EnumMap<Version, Class<? extends MerchantInventory>> MERCHANT_INVENTORIES;
    private static final EnumMap<Version, Class<? extends SmithingTableInventory>> SMITHING_TABLE_INVENTORIES;
    private static final EnumMap<Version, Class<? extends StonecutterInventory>> STONECUTTER_INVENTORIES;

    @NotNull
    @Contract(pure=true)
    public static AnvilInventory newAnvilInventory(@NotNull Version version) {
        try {
            return ANVIL_INVENTORIES.get((Object)version).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static BeaconInventory newBeaconInventory(@NotNull Version version) {
        try {
            return BEACON_INVENTORIES.get((Object)version).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static CartographyTableInventory newCartographyTableInventory(@NotNull Version version) {
        try {
            return CARTOGRAPHY_TABLE_INVENTORIES.get((Object)version).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static EnchantingTableInventory newEnchantingTableInventory(@NotNull Version version) {
        try {
            Class<? extends EnchantingTableInventory> clazz = ENCHANTING_TABLE_INVENTORIES.get((Object)version);
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static GrindstoneInventory newGrindstoneInventory(@NotNull Version version) {
        try {
            Class<? extends GrindstoneInventory> clazz = GRINDSTONE_INVENTORIES.get((Object)version);
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static MerchantInventory newMerchantInventory(@NotNull Version version) {
        try {
            return MERCHANT_INVENTORIES.get((Object)version).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static SmithingTableInventory newModernSmithingTableInventory(@NotNull Version version) {
        if (!version.existsModernSmithingTable() && !version.existsLegacySmithingTable()) {
            throw new UnsupportedVersionException("Smithing tables didn't exist in version " + String.valueOf((Object)version));
        }
        if (!version.existsModernSmithingTable()) {
            throw new UnsupportedVersionException("Modern smithing tables didn't exist in version " + String.valueOf((Object)version));
        }
        try {
            return SMITHING_TABLE_INVENTORIES.get((Object)version).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Contract(pure=true)
    public static SmithingTableInventory newSmithingTableInventory(@NotNull Version version) {
        if (!version.existsModernSmithingTable() && !version.existsLegacySmithingTable()) {
            throw new UnsupportedVersionException("Smithing tables didn't exist in version " + String.valueOf((Object)version));
        }
        if (!version.existsLegacySmithingTable()) {
            throw new UnsupportedVersionException("Legacy smithing tables don't exist in version " + String.valueOf((Object)version));
        }
        return null;
    }

    @NotNull
    @Contract(pure=true)
    public static StonecutterInventory newStonecutterInventory(@NotNull Version version) {
        try {
            return STONECUTTER_INVENTORIES.get((Object)version).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    static {
        ANVIL_INVENTORIES.put(Version.V1_21_1, com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_21_2_3, com.github.stefvanschie.inventoryframework.nms.v1_21_2_3.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_21_4, com.github.stefvanschie.inventoryframework.nms.v1_21_4.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_21_5, AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_21_6_8, com.github.stefvanschie.inventoryframework.nms.v1_21_6_8.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_21_9_10, com.github.stefvanschie.inventoryframework.nms.v1_21_9_10.AnvilInventoryImpl.class);
        BEACON_INVENTORIES = new EnumMap(Version.class);
        BEACON_INVENTORIES.put(Version.V1_21_0, com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_21_1, com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_21_2_3, com.github.stefvanschie.inventoryframework.nms.v1_21_2_3.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_21_4, com.github.stefvanschie.inventoryframework.nms.v1_21_4.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_21_5, com.github.stefvanschie.inventoryframework.nms.v1_21_5.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_21_6_8, BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_21_9_10, com.github.stefvanschie.inventoryframework.nms.v1_21_9_10.BeaconInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES = new EnumMap(Version.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_0, com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_1, com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_2_3, com.github.stefvanschie.inventoryframework.nms.v1_21_2_3.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_4, com.github.stefvanschie.inventoryframework.nms.v1_21_4.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_5, CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_6_8, com.github.stefvanschie.inventoryframework.nms.v1_21_6_8.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_9_10, com.github.stefvanschie.inventoryframework.nms.v1_21_9_10.CartographyTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES = new EnumMap(Version.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_0, EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_1, EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_2_3, com.github.stefvanschie.inventoryframework.nms.v1_21_2_3.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_4, com.github.stefvanschie.inventoryframework.nms.v1_21_4.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_5, com.github.stefvanschie.inventoryframework.nms.v1_21_5.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_6_8, com.github.stefvanschie.inventoryframework.nms.v1_21_6_8.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_9_10, com.github.stefvanschie.inventoryframework.nms.v1_21_9_10.EnchantingTableInventoryImpl.class);
        GRINDSTONE_INVENTORIES = new EnumMap(Version.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_0, com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_1, com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_2_3, com.github.stefvanschie.inventoryframework.nms.v1_21_2_3.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_4, GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_5, com.github.stefvanschie.inventoryframework.nms.v1_21_5.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_6_8, com.github.stefvanschie.inventoryframework.nms.v1_21_6_8.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_9_10, com.github.stefvanschie.inventoryframework.nms.v1_21_9_10.GrindstoneInventoryImpl.class);
        MERCHANT_INVENTORIES = new EnumMap(Version.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_0, MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_1, MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_2_3, com.github.stefvanschie.inventoryframework.nms.v1_21_2_3.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_4, com.github.stefvanschie.inventoryframework.nms.v1_21_4.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_5, com.github.stefvanschie.inventoryframework.nms.v1_21_5.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_6_8, com.github.stefvanschie.inventoryframework.nms.v1_21_6_8.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_9_10, com.github.stefvanschie.inventoryframework.nms.v1_21_9_10.MerchantInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES = new EnumMap(Version.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_0, SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_1, SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_2_3, com.github.stefvanschie.inventoryframework.nms.v1_21_2_3.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_4, com.github.stefvanschie.inventoryframework.nms.v1_21_4.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_5, com.github.stefvanschie.inventoryframework.nms.v1_21_5.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_6_8, com.github.stefvanschie.inventoryframework.nms.v1_21_6_8.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_9_10, com.github.stefvanschie.inventoryframework.nms.v1_21_9_10.SmithingTableInventoryImpl.class);
        STONECUTTER_INVENTORIES = new EnumMap(Version.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_0, com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_1, com.github.stefvanschie.inventoryframework.nms.v1_21_0_1.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_2_3, com.github.stefvanschie.inventoryframework.nms.v1_21_2_3.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_4, com.github.stefvanschie.inventoryframework.nms.v1_21_4.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_5, com.github.stefvanschie.inventoryframework.nms.v1_21_5.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_6_8, StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_9_10, com.github.stefvanschie.inventoryframework.nms.v1_21_9_10.StonecutterInventoryImpl.class);
    }
}

