/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims;

import co.aikar.commands.PaperCommandManager;
import dev.mizarc.bellclaims.di.ModulesKt;
import dev.mizarc.bellclaims.infrastructure.persistence.migrations.SQLiteMigrations;
import dev.mizarc.bellclaims.interaction.commands.AddFlagCommand;
import dev.mizarc.bellclaims.interaction.commands.ClaimCommand;
import dev.mizarc.bellclaims.interaction.commands.ClaimListCommand;
import dev.mizarc.bellclaims.interaction.commands.ClaimMenuCommand;
import dev.mizarc.bellclaims.interaction.commands.ClaimOverrideCommand;
import dev.mizarc.bellclaims.interaction.commands.DescriptionCommand;
import dev.mizarc.bellclaims.interaction.commands.InfoCommand;
import dev.mizarc.bellclaims.interaction.commands.PartitionsCommand;
import dev.mizarc.bellclaims.interaction.commands.RemoveCommand;
import dev.mizarc.bellclaims.interaction.commands.RemoveFlagCommand;
import dev.mizarc.bellclaims.interaction.commands.RenameCommand;
import dev.mizarc.bellclaims.interaction.commands.TrustAllCommand;
import dev.mizarc.bellclaims.interaction.commands.TrustCommand;
import dev.mizarc.bellclaims.interaction.commands.TrustListCommand;
import dev.mizarc.bellclaims.interaction.commands.UntrustAllCommand;
import dev.mizarc.bellclaims.interaction.commands.UntrustCommand;
import dev.mizarc.bellclaims.interaction.listeners.BlockLaunchListener;
import dev.mizarc.bellclaims.interaction.listeners.ClaimAnchorListener;
import dev.mizarc.bellclaims.interaction.listeners.ClaimDestructionListener;
import dev.mizarc.bellclaims.interaction.listeners.CloseInventoryListener;
import dev.mizarc.bellclaims.interaction.listeners.EditToolListener;
import dev.mizarc.bellclaims.interaction.listeners.EditToolVisualisingListener;
import dev.mizarc.bellclaims.interaction.listeners.HarvestReplantListener;
import dev.mizarc.bellclaims.interaction.listeners.MoveToolListener;
import dev.mizarc.bellclaims.interaction.listeners.PartitionUpdateListener;
import dev.mizarc.bellclaims.interaction.listeners.PlayerClaimProtectionListener;
import dev.mizarc.bellclaims.interaction.listeners.ToolRemovalListener;
import dev.mizarc.bellclaims.interaction.listeners.WorldClaimProtectionListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;
import org.koin.core.KoinApplication;
import org.koin.core.context.GlobalContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0015J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Ldev/mizarc/bellclaims/BellClaims;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "commandManager", "Lco/aikar/commands/PaperCommandManager;", "metadata", "Lnet/milkbowl/vault/chat/Chat;", "getMetadata", "()Lnet/milkbowl/vault/chat/Chat;", "setMetadata", "(Lnet/milkbowl/vault/chat/Chat;)V", "scheduler", "Lorg/bukkit/scheduler/BukkitScheduler;", "pluginScope", "Lkotlinx/coroutines/CoroutineScope;", "getPluginScope", "()Lkotlinx/coroutines/CoroutineScope;", "setPluginScope", "(Lkotlinx/coroutines/CoroutineScope;)V", "onEnable", "", "initDataFolder", "initDatabase", "initLang", "onDisable", "initialiseConfig", "initialiseVaultDependency", "registerCommands", "registerEvents", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nBellClaims.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BellClaims.kt\ndev/mizarc/bellclaims/BellClaims\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1869#2,2:193\n1#3:195\n*S KotlinDebug\n*F\n+ 1 BellClaims.kt\ndev/mizarc/bellclaims/BellClaims\n*L\n121#1:193,2\n*E\n"})
public final class BellClaims
extends JavaPlugin {
    private PaperCommandManager commandManager;
    public Chat metadata;
    private BukkitScheduler scheduler;
    public CoroutineScope pluginScope;

    @NotNull
    public final Chat getMetadata() {
        Chat chat = this.metadata;
        if (chat != null) {
            return chat;
        }
        Intrinsics.throwUninitializedPropertyAccessException("metadata");
        return null;
    }

    public final void setMetadata(@NotNull Chat chat) {
        Intrinsics.checkNotNullParameter(chat, "<set-?>");
        this.metadata = chat;
    }

    @NotNull
    public final CoroutineScope getPluginScope() {
        CoroutineScope coroutineScope = this.pluginScope;
        if (coroutineScope != null) {
            return coroutineScope;
        }
        Intrinsics.throwUninitializedPropertyAccessException("pluginScope");
        return null;
    }

    public final void setPluginScope(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(coroutineScope, "<set-?>");
        this.pluginScope = coroutineScope;
    }

    public void onEnable() {
        this.initDataFolder();
        this.initDatabase();
        this.setPluginScope(CoroutineScopeKt.CoroutineScope(Dispatchers.getIO().plus(SupervisorKt.SupervisorJob$default(null, 1, null))));
        BukkitScheduler bukkitScheduler = this.getServer().getScheduler();
        Intrinsics.checkNotNullExpressionValue(bukkitScheduler, "getScheduler(...)");
        this.scheduler = bukkitScheduler;
        GlobalContext.INSTANCE.startKoin(arg_0 -> BellClaims.onEnable$lambda$0(this, arg_0));
        this.initLang();
        this.initialiseVaultDependency();
        this.initialiseConfig();
        this.commandManager = new PaperCommandManager((Plugin)this);
        this.registerCommands();
        this.registerEvents();
        this.getLogger().info("Bell Claims has been Enabled");
    }

    public final void initDataFolder() {
        if (!this.getDataFolder().exists()) {
            this.getLogger().info("Data folder '" + this.getDataFolder().getAbsolutePath() + "' not found. Creating it...");
            try {
                this.getDataFolder().mkdirs();
                this.getLogger().info("Data folder created successfully.");
            }
            catch (SecurityException e) {
                this.getLogger().severe("Failed to create data folder '" + this.getDataFolder().getAbsolutePath() + "': " + e.getMessage());
                e.printStackTrace();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initDatabase() {
        File databaseFile = new File(this.getDataFolder(), "claims.db");
        if (databaseFile.exists()) {
            Connection tempConnectionForMigration = null;
            try {
                tempConnectionForMigration = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath());
                JavaPlugin javaPlugin = this;
                Connection connection = tempConnectionForMigration;
                Intrinsics.checkNotNull(connection);
                SQLiteMigrations migrator = new SQLiteMigrations(javaPlugin, connection);
                migrator.migrate();
            }
            finally {
                Connection connection = tempConnectionForMigration;
                if (connection != null) {
                    Connection it = connection;
                    boolean bl = false;
                    try {
                        if (!it.isClosed()) {
                            it.close();
                            this.getLogger().info("Closed temporary connection after migration.");
                        }
                    }
                    catch (SQLException e) {
                        this.getLogger().severe("Failed to close temporary database connection: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
        this.getLogger().info("Database file not found. Creating a new database and setting schema version to v2.");
        Connection newConnection = null;
        try {
            newConnection = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath());
            Statement statement = newConnection.createStatement();
            statement.execute("PRAGMA user_version = 2;");
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().severe("Failed to create new database or set user_version: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            Connection connection = newConnection;
            if (connection != null) {
                Connection it = connection;
                boolean bl = false;
                try {
                    if (!it.isClosed()) {
                        it.close();
                        this.getLogger().info("Closed connection for new database creation.");
                    }
                }
                catch (SQLException e) {
                    this.getLogger().severe("Failed to close new database connection: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    public final void initLang() {
        List<String> defaultLanguageFilenames = CollectionsKt.listOf("en.properties");
        Iterable $this$forEach$iv = defaultLanguageFilenames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String filename = (String)element$iv;
            boolean bl = false;
            String resourcePathInJar = "lang/defaults/" + filename;
            this.saveResource(resourcePathInJar, true);
        }
        this.saveResource("lang/overrides/README.txt", true);
    }

    public void onDisable() {
        CoroutineScopeKt.cancel$default(this.getPluginScope(), null, 1, null);
        this.getLogger().info("Bell Claims has been Disabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initialiseConfig() {
        this.saveDefaultConfig();
        InputStream inputStream = this.getResource("config.yml");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                Object object;
                InputStream defaultConfigStream = (InputStream)closeable;
                boolean bl = false;
                File sampleConfigFile = new File(this.getDataFolder(), "sample-config.yml");
                try {
                    object = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    object = Files.copy(defaultConfigStream, sampleConfigFile.toPath(), object);
                }
                catch (IOException e) {
                    this.getLogger().severe("Failed to copy config: " + e.getMessage());
                    object = Unit.INSTANCE;
                }
                CopyOption[] copyOptionArray = object;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        this.getLogger().warning("Default config file not found in the plugin resources");
    }

    private final void initialiseVaultDependency() {
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Chat.class);
            if (registeredServiceProvider != null) {
                RegisteredServiceProvider it = registeredServiceProvider;
                boolean bl = false;
                Object object = it.getProvider();
                Intrinsics.checkNotNullExpressionValue(object, "getProvider(...)");
                this.setMetadata((Chat)object);
            }
            this.getLogger().info(Chat.class.toString());
        }
    }

    private final void registerCommands() {
        PaperCommandManager paperCommandManager = this.commandManager;
        if (paperCommandManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager = null;
        }
        paperCommandManager.registerCommand(new ClaimListCommand());
        PaperCommandManager paperCommandManager2 = this.commandManager;
        if (paperCommandManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager2 = null;
        }
        paperCommandManager2.registerCommand(new ClaimCommand());
        PaperCommandManager paperCommandManager3 = this.commandManager;
        if (paperCommandManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager3 = null;
        }
        paperCommandManager3.registerCommand(new InfoCommand());
        PaperCommandManager paperCommandManager4 = this.commandManager;
        if (paperCommandManager4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager4 = null;
        }
        paperCommandManager4.registerCommand(new RenameCommand());
        PaperCommandManager paperCommandManager5 = this.commandManager;
        if (paperCommandManager5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager5 = null;
        }
        paperCommandManager5.registerCommand(new DescriptionCommand());
        PaperCommandManager paperCommandManager6 = this.commandManager;
        if (paperCommandManager6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager6 = null;
        }
        paperCommandManager6.registerCommand(new PartitionsCommand());
        PaperCommandManager paperCommandManager7 = this.commandManager;
        if (paperCommandManager7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager7 = null;
        }
        paperCommandManager7.registerCommand(new AddFlagCommand());
        PaperCommandManager paperCommandManager8 = this.commandManager;
        if (paperCommandManager8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager8 = null;
        }
        paperCommandManager8.registerCommand(new RemoveFlagCommand());
        PaperCommandManager paperCommandManager9 = this.commandManager;
        if (paperCommandManager9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager9 = null;
        }
        paperCommandManager9.registerCommand(new TrustListCommand());
        PaperCommandManager paperCommandManager10 = this.commandManager;
        if (paperCommandManager10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager10 = null;
        }
        paperCommandManager10.registerCommand(new TrustCommand());
        PaperCommandManager paperCommandManager11 = this.commandManager;
        if (paperCommandManager11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager11 = null;
        }
        paperCommandManager11.registerCommand(new TrustAllCommand());
        PaperCommandManager paperCommandManager12 = this.commandManager;
        if (paperCommandManager12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager12 = null;
        }
        paperCommandManager12.registerCommand(new UntrustCommand());
        PaperCommandManager paperCommandManager13 = this.commandManager;
        if (paperCommandManager13 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager13 = null;
        }
        paperCommandManager13.registerCommand(new UntrustAllCommand());
        PaperCommandManager paperCommandManager14 = this.commandManager;
        if (paperCommandManager14 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager14 = null;
        }
        paperCommandManager14.registerCommand(new RemoveCommand());
        PaperCommandManager paperCommandManager15 = this.commandManager;
        if (paperCommandManager15 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager15 = null;
        }
        paperCommandManager15.registerCommand(new ClaimOverrideCommand());
        PaperCommandManager paperCommandManager16 = this.commandManager;
        if (paperCommandManager16 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            paperCommandManager16 = null;
        }
        paperCommandManager16.registerCommand(new ClaimMenuCommand());
    }

    private final void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new BlockLaunchListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClaimAnchorListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClaimDestructionListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CloseInventoryListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EditToolListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EditToolVisualisingListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HarvestReplantListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MoveToolListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PartitionUpdateListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerClaimProtectionListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ToolRemovalListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldClaimProtectionListener(), (Plugin)this);
    }

    private static final Unit onEnable$lambda$0(BellClaims this$0, KoinApplication $this$startKoin) {
        Intrinsics.checkNotNullParameter($this$startKoin, "$this$startKoin");
        $this$startKoin.modules(ModulesKt.appModule(this$0));
        return Unit.INSTANCE;
    }
}

