/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.results.claim.CreateClaimResult;
import dev.mizarc.bellclaims.application.services.PlayerMetadataService;
import dev.mizarc.bellclaims.application.services.WorldManipulationService;
import dev.mizarc.bellclaims.config.MainConfig;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.Area;
import dev.mizarc.bellclaims.domain.values.Position2D;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/CreateClaim;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "playerMetadataService", "Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;", "worldManipulationService", "Ldev/mizarc/bellclaims/application/services/WorldManipulationService;", "config", "Ldev/mizarc/bellclaims/config/MainConfig;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;Ldev/mizarc/bellclaims/application/services/WorldManipulationService;Ldev/mizarc/bellclaims/config/MainConfig;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/CreateClaimResult;", "playerId", "Ljava/util/UUID;", "name", "", "position3D", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "worldId", "BellClaims"})
public final class CreateClaim {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final PlayerMetadataService playerMetadataService;
    @NotNull
    private final WorldManipulationService worldManipulationService;
    @NotNull
    private final MainConfig config;

    public CreateClaim(@NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository, @NotNull PlayerMetadataService playerMetadataService, @NotNull WorldManipulationService worldManipulationService, @NotNull MainConfig config) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(playerMetadataService, "playerMetadataService");
        Intrinsics.checkNotNullParameter(worldManipulationService, "worldManipulationService");
        Intrinsics.checkNotNullParameter(config, "config");
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
        this.playerMetadataService = playerMetadataService;
        this.worldManipulationService = worldManipulationService;
        this.config = config;
    }

    @NotNull
    public final CreateClaimResult execute(@NotNull UUID playerId, @NotNull String name, @NotNull Position3D position3D, @NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(position3D, "position3D");
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Set<Claim> claims = this.claimRepository.getByPlayer(playerId);
        if (((Collection)claims).size() >= this.playerMetadataService.getPlayerClaimLimit(playerId)) {
            return CreateClaimResult.LimitExceeded.INSTANCE;
        }
        if (StringsKt.isBlank(name)) {
            return CreateClaimResult.NameCannotBeBlank.INSTANCE;
        }
        Claim existingClaim = this.claimRepository.getByName(playerId, name);
        if (existingClaim != null) {
            return CreateClaimResult.NameAlreadyExists.INSTANCE;
        }
        int areaSize = this.config.getInitialClaimSize();
        int offsetMin = (areaSize - 1) / 2;
        int offsetMax = areaSize / 2;
        Area area = new Area(new Position2D(position3D.getX() - offsetMin, position3D.getZ() - offsetMin), new Position2D(position3D.getX() + offsetMax, position3D.getZ() + offsetMax));
        if (!this.worldManipulationService.isInsideWorldBorder(worldId, area)) {
            return CreateClaimResult.TooCloseToWorldBorder.INSTANCE;
        }
        Claim newClaim = new Claim(worldId, playerId, position3D, name);
        Partition partition = new Partition(newClaim.getId(), area);
        this.claimRepository.add(newClaim);
        this.partitionRepository.add(partition);
        return new CreateClaimResult.Success(newClaim);
    }
}

