/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.results.claim.GetClaimAtPositionResult;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.Position;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/GetClaimAtPosition;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/GetClaimAtPositionResult;", "worldId", "Ljava/util/UUID;", "position", "Ldev/mizarc/bellclaims/domain/values/Position;", "filterByWorld", "Ldev/mizarc/bellclaims/domain/entities/Partition;", "inputPartitions", "", "BellClaims"})
public final class GetClaimAtPosition {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;

    public GetClaimAtPosition(@NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
    }

    @NotNull
    public final GetClaimAtPositionResult execute(@NotNull UUID worldId, @NotNull Position position) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(position, "position");
        Set<Partition> partitions = this.partitionRepository.getByPosition(position);
        Partition partition = this.filterByWorld(worldId, partitions);
        if (partition == null) {
            return GetClaimAtPositionResult.NoClaimFound.INSTANCE;
        }
        Partition worldPartition = partition;
        Claim claim = this.claimRepository.getById(worldPartition.getClaimId());
        if (claim == null) {
            return GetClaimAtPositionResult.NoClaimFound.INSTANCE;
        }
        Claim claim2 = claim;
        return new GetClaimAtPositionResult.Success(claim2);
    }

    private final Partition filterByWorld(UUID worldId, Set<Partition> inputPartitions) {
        for (Partition partition : inputPartitions) {
            Claim claimPartition;
            if (this.claimRepository.getById(partition.getClaimId()) == null || !Intrinsics.areEqual(claimPartition.getWorldId(), worldId)) continue;
            return partition;
        }
        return null;
    }
}

