/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.results.claim.IsNewClaimLocationValidResult;
import dev.mizarc.bellclaims.application.services.WorldManipulationService;
import dev.mizarc.bellclaims.config.MainConfig;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.Area;
import dev.mizarc.bellclaims.domain.values.Position;
import dev.mizarc.bellclaims.domain.values.Position2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/IsNewClaimLocationValid;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "worldManipulationService", "Ldev/mizarc/bellclaims/application/services/WorldManipulationService;", "config", "Ldev/mizarc/bellclaims/config/MainConfig;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/services/WorldManipulationService;Ldev/mizarc/bellclaims/config/MainConfig;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/IsNewClaimLocationValidResult;", "position", "Ldev/mizarc/bellclaims/domain/values/Position;", "worldId", "Ljava/util/UUID;", "getSurroundingPositions", "", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "radius", "", "getByChunk", "", "Ldev/mizarc/bellclaims/domain/entities/Partition;", "position2D", "filterByWorld", "inputPartitions", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nIsNewClaimLocationValid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IsNewClaimLocationValid.kt\ndev/mizarc/bellclaims/application/actions/claim/IsNewClaimLocationValid\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1374#2:81\n1460#2,5:82\n1374#2:87\n1460#2,5:88\n*S KotlinDebug\n*F\n+ 1 IsNewClaimLocationValid.kt\ndev/mizarc/bellclaims/application/actions/claim/IsNewClaimLocationValid\n*L\n31#1:81\n31#1:82,5\n32#1:87\n32#1:88,5\n*E\n"})
public final class IsNewClaimLocationValid {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final WorldManipulationService worldManipulationService;
    @NotNull
    private final MainConfig config;

    public IsNewClaimLocationValid(@NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository, @NotNull WorldManipulationService worldManipulationService, @NotNull MainConfig config) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(worldManipulationService, "worldManipulationService");
        Intrinsics.checkNotNullParameter(config, "config");
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
        this.worldManipulationService = worldManipulationService;
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IsNewClaimLocationValidResult execute(@NotNull Position position, @NotNull UUID worldId) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        int initialClaimSize = this.config.getInitialClaimSize();
        int offsetMin = (initialClaimSize - 1) / 2;
        int offsetMax = initialClaimSize / 2;
        Area area = new Area(new Position2D(position.getX() - offsetMin, position.getZ() - offsetMin), new Position2D(position.getX() + offsetMax, position.getZ() + offsetMax));
        Iterable $this$flatMap$iv = area.getChunks();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            Position2D it = (Position2D)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getSurroundingPositions(it, 1);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List chunks = (List)destination$iv$iv;
        Iterable $this$flatMap$iv2 = chunks;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Position2D it = (Position2D)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getByChunk(worldId, it);
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        Set<Partition> partitions = CollectionsKt.toSet((List)destination$iv$iv2);
        Area areaWithBoundary = new Area(new Position2D(area.getLowerPosition2D().getX() - this.config.getDistanceBetweenClaims(), area.getLowerPosition2D().getZ() - this.config.getDistanceBetweenClaims()), new Position2D(area.getUpperPosition2D().getX() + this.config.getDistanceBetweenClaims(), area.getUpperPosition2D().getZ() + this.config.getDistanceBetweenClaims()));
        for (Partition partition : partitions) {
            if (!partition.isAreaOverlap(areaWithBoundary)) continue;
            return IsNewClaimLocationValidResult.Overlap.INSTANCE;
        }
        if (!this.worldManipulationService.isInsideWorldBorder(worldId, areaWithBoundary)) {
            return IsNewClaimLocationValidResult.TooCloseToWorldBorder.INSTANCE;
        }
        return IsNewClaimLocationValidResult.Valid.INSTANCE;
    }

    private final List<Position2D> getSurroundingPositions(Position2D position, int radius) {
        List positions = new ArrayList();
        int i = -1 * radius;
        int n = 1 * radius;
        if (i <= n) {
            while (true) {
                int n2;
                int j;
                if ((j = -1 * radius) <= (n2 = 1 * radius)) {
                    while (true) {
                        positions.add(new Position2D(position.getX() + i, position.getZ() + j));
                        if (j == n2) break;
                        ++j;
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        return positions;
    }

    private final Set<Partition> getByChunk(UUID worldId, Position2D position2D) {
        return this.filterByWorld(worldId, this.partitionRepository.getByChunk(new Position2D(position2D.getX(), position2D.getZ())));
    }

    private final Set<Partition> filterByWorld(UUID worldId, Set<Partition> inputPartitions) {
        Set outputPartitions = new LinkedHashSet();
        for (Partition partition : inputPartitions) {
            Claim claimPartition;
            if (this.claimRepository.getById(partition.getClaimId()) == null || !Intrinsics.areEqual(claimPartition.getWorldId(), worldId)) continue;
            outputPartitions.add(partition);
        }
        return outputPartitions;
    }
}

