/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim;

import dev.mizarc.bellclaims.application.actions.claim.GetClaimAtPosition;
import dev.mizarc.bellclaims.application.persistence.ClaimPermissionRepository;
import dev.mizarc.bellclaims.application.persistence.PlayerAccessRepository;
import dev.mizarc.bellclaims.application.persistence.PlayerStateRepository;
import dev.mizarc.bellclaims.application.results.claim.GetClaimAtPositionResult;
import dev.mizarc.bellclaims.application.results.claim.IsPlayerActionAllowedResult;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.PlayerState;
import dev.mizarc.bellclaims.domain.values.ClaimPermission;
import dev.mizarc.bellclaims.domain.values.PlayerActionType;
import dev.mizarc.bellclaims.domain.values.Position2D;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/IsPlayerActionAllowed;", "", "playerAccessRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerAccessRepository;", "claimPermissionRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimPermissionRepository;", "getClaimAtPosition", "Ldev/mizarc/bellclaims/application/actions/claim/GetClaimAtPosition;", "playerStateRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PlayerAccessRepository;Ldev/mizarc/bellclaims/application/persistence/ClaimPermissionRepository;Ldev/mizarc/bellclaims/application/actions/claim/GetClaimAtPosition;Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/IsPlayerActionAllowedResult;", "playerId", "Ljava/util/UUID;", "worldId", "position", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "playerActionType", "Ldev/mizarc/bellclaims/domain/values/PlayerActionType;", "actionToPermissionMapping", "", "Ldev/mizarc/bellclaims/domain/values/ClaimPermission;", "BellClaims"})
public final class IsPlayerActionAllowed {
    @NotNull
    private final PlayerAccessRepository playerAccessRepository;
    @NotNull
    private final ClaimPermissionRepository claimPermissionRepository;
    @NotNull
    private final GetClaimAtPosition getClaimAtPosition;
    @NotNull
    private final PlayerStateRepository playerStateRepository;
    @NotNull
    private final Map<PlayerActionType, ClaimPermission> actionToPermissionMapping;

    public IsPlayerActionAllowed(@NotNull PlayerAccessRepository playerAccessRepository, @NotNull ClaimPermissionRepository claimPermissionRepository, @NotNull GetClaimAtPosition getClaimAtPosition, @NotNull PlayerStateRepository playerStateRepository) {
        Intrinsics.checkNotNullParameter(playerAccessRepository, "playerAccessRepository");
        Intrinsics.checkNotNullParameter(claimPermissionRepository, "claimPermissionRepository");
        Intrinsics.checkNotNullParameter(getClaimAtPosition, "getClaimAtPosition");
        Intrinsics.checkNotNullParameter(playerStateRepository, "playerStateRepository");
        this.playerAccessRepository = playerAccessRepository;
        this.claimPermissionRepository = claimPermissionRepository;
        this.getClaimAtPosition = getClaimAtPosition;
        this.playerStateRepository = playerStateRepository;
        Pair[] pairArray = new Pair[]{TuplesKt.to(PlayerActionType.BREAK_BLOCK, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.PLACE_BLOCK, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.PLACE_FLUID, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.PLACE_ENTITY, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.DAMAGE_STATIC_ENTITY, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.FERTILIZE_LAND, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.STEP_ON_FARMLAND, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.TELEPORT_DRAGON_EGG, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.FILL_BUCKET, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.SHEAR_PUMPKIN, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.BREAK_POT, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.PUSH_ARMOUR_STAND, ClaimPermission.BUILD), TuplesKt.to(PlayerActionType.HARVEST_CROP, ClaimPermission.HARVEST), TuplesKt.to(PlayerActionType.FERTILIZE_CROP, ClaimPermission.HARVEST), TuplesKt.to(PlayerActionType.OPEN_CONTAINER, ClaimPermission.CONTAINER), TuplesKt.to(PlayerActionType.TAKE_LECTERN_BOOK, ClaimPermission.DISPLAY), TuplesKt.to(PlayerActionType.MODIFY_BLOCK, ClaimPermission.DISPLAY), TuplesKt.to(PlayerActionType.MODIFY_STATIC_ENTITY, ClaimPermission.DISPLAY), TuplesKt.to(PlayerActionType.PLACE_VEHICLE, ClaimPermission.VEHICLE), TuplesKt.to(PlayerActionType.DESTROY_VEHICLE, ClaimPermission.VEHICLE), TuplesKt.to(PlayerActionType.EDIT_SIGN, ClaimPermission.SIGN), TuplesKt.to(PlayerActionType.DYE_SIGN, ClaimPermission.SIGN), TuplesKt.to(PlayerActionType.USE_REDSTONE, ClaimPermission.REDSTONE), TuplesKt.to(PlayerActionType.OPEN_DOOR, ClaimPermission.DOOR), TuplesKt.to(PlayerActionType.TRADE_VILLAGER, ClaimPermission.TRADE), TuplesKt.to(PlayerActionType.DAMAGE_ANIMAL, ClaimPermission.HUSBANDRY), TuplesKt.to(PlayerActionType.INTERACT_WITH_ANIMAL, ClaimPermission.HUSBANDRY), TuplesKt.to(PlayerActionType.ROD_ANIMAL, ClaimPermission.HUSBANDRY), TuplesKt.to(PlayerActionType.DETACH_LEAD, ClaimPermission.HUSBANDRY), TuplesKt.to(PlayerActionType.USE_BEEHIVE, ClaimPermission.HUSBANDRY), TuplesKt.to(PlayerActionType.POTION_ANIMAL, ClaimPermission.HUSBANDRY), TuplesKt.to(PlayerActionType.PUSH_ANIMAL, ClaimPermission.HUSBANDRY), TuplesKt.to(PlayerActionType.PRIME_TNT, ClaimPermission.DETONATE), TuplesKt.to(PlayerActionType.DETONATE_ENTITY, ClaimPermission.DETONATE), TuplesKt.to(PlayerActionType.DETONATE_BLOCK, ClaimPermission.DETONATE), TuplesKt.to(PlayerActionType.TRIGGER_RAID, ClaimPermission.DETONATE), TuplesKt.to(PlayerActionType.SLEEP_IN_BED, ClaimPermission.DETONATE), TuplesKt.to(PlayerActionType.SET_RESPAWN_POINT, ClaimPermission.DETONATE), TuplesKt.to(PlayerActionType.TRIGGER_RAID, ClaimPermission.EVENT), TuplesKt.to(PlayerActionType.SLEEP_IN_BED, ClaimPermission.SLEEP), TuplesKt.to(PlayerActionType.SET_RESPAWN_POINT, ClaimPermission.SLEEP), TuplesKt.to(PlayerActionType.VIEW_LECTERN_BOOK, ClaimPermission.VIEW)};
        this.actionToPermissionMapping = MapsKt.mapOf(pairArray);
    }

    @NotNull
    public final IsPlayerActionAllowedResult execute(@NotNull UUID playerId, @NotNull UUID worldId, @NotNull Position2D position, @NotNull PlayerActionType playerActionType) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter((Object)playerActionType, "playerActionType");
        GetClaimAtPositionResult result = this.getClaimAtPosition.execute(worldId, position);
        if (Intrinsics.areEqual(result, GetClaimAtPositionResult.NoClaimFound.INSTANCE)) {
            return IsPlayerActionAllowedResult.NoClaimFound.INSTANCE;
        }
        if (Intrinsics.areEqual(result, GetClaimAtPositionResult.StorageError.INSTANCE)) {
            return IsPlayerActionAllowedResult.StorageError.INSTANCE;
        }
        if (!(result instanceof GetClaimAtPositionResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        Claim claim = ((GetClaimAtPositionResult.Success)result).getClaim();
        PlayerState playerState = this.playerStateRepository.get(playerId);
        if (Intrinsics.areEqual(playerId, claim.getPlayerId()) || playerState != null && playerState.getClaimOverride()) {
            return new IsPlayerActionAllowedResult.Allowed(claim);
        }
        ClaimPermission claimPermission = this.actionToPermissionMapping.get((Object)playerActionType);
        if (claimPermission == null) {
            return IsPlayerActionAllowedResult.NoAssociatedPermission.INSTANCE;
        }
        ClaimPermission relevantPermission = claimPermission;
        if (this.playerAccessRepository.doesPlayerHavePermission(playerId, claim.getId(), relevantPermission) || this.claimPermissionRepository.doesClaimHavePermission(claim.getId(), relevantPermission)) {
            return new IsPlayerActionAllowedResult.Allowed(claim);
        }
        return new IsPlayerActionAllowedResult.Denied(claim);
    }
}

