/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim;

import dev.mizarc.bellclaims.application.actions.claim.GetClaimAtPosition;
import dev.mizarc.bellclaims.application.persistence.ClaimFlagRepository;
import dev.mizarc.bellclaims.application.results.claim.GetClaimAtPositionResult;
import dev.mizarc.bellclaims.application.results.claim.IsWorldActionAllowedResult;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.values.Flag;
import dev.mizarc.bellclaims.domain.values.Position2D;
import dev.mizarc.bellclaims.domain.values.WorldActionType;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/IsWorldActionAllowed;", "", "flagRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimFlagRepository;", "getClaimAtPosition", "Ldev/mizarc/bellclaims/application/actions/claim/GetClaimAtPosition;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimFlagRepository;Ldev/mizarc/bellclaims/application/actions/claim/GetClaimAtPosition;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/IsWorldActionAllowedResult;", "worldId", "Ljava/util/UUID;", "position", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "worldActionType", "Ldev/mizarc/bellclaims/domain/values/WorldActionType;", "actionToFlagMapping", "", "Ldev/mizarc/bellclaims/domain/values/Flag;", "BellClaims"})
public final class IsWorldActionAllowed {
    @NotNull
    private final ClaimFlagRepository flagRepository;
    @NotNull
    private final GetClaimAtPosition getClaimAtPosition;
    @NotNull
    private final Map<WorldActionType, Flag> actionToFlagMapping;

    public IsWorldActionAllowed(@NotNull ClaimFlagRepository flagRepository, @NotNull GetClaimAtPosition getClaimAtPosition) {
        Intrinsics.checkNotNullParameter(flagRepository, "flagRepository");
        Intrinsics.checkNotNullParameter(getClaimAtPosition, "getClaimAtPosition");
        this.flagRepository = flagRepository;
        this.getClaimAtPosition = getClaimAtPosition;
        Pair[] pairArray = new Pair[]{TuplesKt.to(WorldActionType.FIRE_BURN, Flag.FIRE), TuplesKt.to(WorldActionType.FIRE_SPREAD, Flag.FIRE), TuplesKt.to(WorldActionType.FLUID_ABSORB, Flag.SPONGE), TuplesKt.to(WorldActionType.PISTON_EXTEND, Flag.PISTON), TuplesKt.to(WorldActionType.PISTON_RETRACT, Flag.PISTON), TuplesKt.to(WorldActionType.ANIMAL_ENTER_VEHICLE, Flag.PASSIVE_ENTITY_VEHICLE), TuplesKt.to(WorldActionType.BLOCK_EXPLOSION_DAMAGE_ENTITY, Flag.EXPLOSION), TuplesKt.to(WorldActionType.BLOCK_EXPLOSION_DESTROY_BLOCK, Flag.EXPLOSION), TuplesKt.to(WorldActionType.ENTITY_EXPLOSION_DAMAGE_ENTITY, Flag.EXPLOSION), TuplesKt.to(WorldActionType.ENTITY_EXPLOSION_DESTROY_BLOCK, Flag.EXPLOSION), TuplesKt.to(WorldActionType.DISPENSE, Flag.DISPENSER), TuplesKt.to(WorldActionType.FALLING_BLOCK_MATERIALISE, Flag.FALLING_BLOCK), TuplesKt.to(WorldActionType.MOB_DESTROY_BLOCK, Flag.MOB), TuplesKt.to(WorldActionType.MOB_DAMAGE_ENTITY, Flag.MOB), TuplesKt.to(WorldActionType.FLUID_FLOW, Flag.FLUID), TuplesKt.to(WorldActionType.FLUID_FORM_BLOCK, Flag.FLUID), TuplesKt.to(WorldActionType.TREE_GROWTH, Flag.TREE), TuplesKt.to(WorldActionType.SPREAD, Flag.SCULK), TuplesKt.to(WorldActionType.LIGHTNING_DAMAGE, Flag.LIGHTNING)};
        this.actionToFlagMapping = MapsKt.mapOf(pairArray);
    }

    @NotNull
    public final IsWorldActionAllowedResult execute(@NotNull UUID worldId, @NotNull Position2D position, @NotNull WorldActionType worldActionType) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter((Object)worldActionType, "worldActionType");
        GetClaimAtPositionResult result = this.getClaimAtPosition.execute(worldId, position);
        if (Intrinsics.areEqual(result, GetClaimAtPositionResult.NoClaimFound.INSTANCE)) {
            return IsWorldActionAllowedResult.NoClaimFound.INSTANCE;
        }
        if (Intrinsics.areEqual(result, GetClaimAtPositionResult.StorageError.INSTANCE)) {
            return IsWorldActionAllowedResult.StorageError.INSTANCE;
        }
        if (!(result instanceof GetClaimAtPositionResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        Claim claim = ((GetClaimAtPositionResult.Success)result).getClaim();
        Flag flag = this.actionToFlagMapping.get((Object)worldActionType);
        if (flag == null) {
            return IsWorldActionAllowedResult.NoAssociatedFlag.INSTANCE;
        }
        Flag relevantFlag = flag;
        if (this.flagRepository.doesClaimHaveFlag(claim.getId(), relevantFlag)) {
            return IsWorldActionAllowedResult.Allowed.INSTANCE;
        }
        return IsWorldActionAllowedResult.Denied.INSTANCE;
    }
}

