/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.anchor;

import dev.mizarc.bellclaims.application.persistence.ClaimFlagRepository;
import dev.mizarc.bellclaims.application.persistence.ClaimPermissionRepository;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.persistence.PlayerAccessRepository;
import dev.mizarc.bellclaims.application.results.claim.anchor.BreakClaimAnchorResult;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/anchor/BreakClaimAnchor;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "flagRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimFlagRepository;", "claimPermissionRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimPermissionRepository;", "playerAccessRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerAccessRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/persistence/ClaimFlagRepository;Ldev/mizarc/bellclaims/application/persistence/ClaimPermissionRepository;Ldev/mizarc/bellclaims/application/persistence/PlayerAccessRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/anchor/BreakClaimAnchorResult;", "worldId", "Ljava/util/UUID;", "position", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "BellClaims"})
public final class BreakClaimAnchor {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final ClaimFlagRepository flagRepository;
    @NotNull
    private final ClaimPermissionRepository claimPermissionRepository;
    @NotNull
    private final PlayerAccessRepository playerAccessRepository;

    public BreakClaimAnchor(@NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository, @NotNull ClaimFlagRepository flagRepository, @NotNull ClaimPermissionRepository claimPermissionRepository, @NotNull PlayerAccessRepository playerAccessRepository) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(flagRepository, "flagRepository");
        Intrinsics.checkNotNullParameter(claimPermissionRepository, "claimPermissionRepository");
        Intrinsics.checkNotNullParameter(playerAccessRepository, "playerAccessRepository");
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
        this.flagRepository = flagRepository;
        this.claimPermissionRepository = claimPermissionRepository;
        this.playerAccessRepository = playerAccessRepository;
    }

    @NotNull
    public final BreakClaimAnchorResult execute(@NotNull UUID worldId, @NotNull Position3D position) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(position, "position");
        Claim claim = this.claimRepository.getByPosition(position, worldId);
        if (claim == null) {
            return BreakClaimAnchorResult.ClaimNotFound.INSTANCE;
        }
        Claim claim2 = claim;
        claim2.resetBreakCount();
        if (claim2.getBreakCount() > 1) {
            claim2.setBreakCount(claim2.getBreakCount() - 1);
            return new BreakClaimAnchorResult.ClaimBreaking(claim2.getBreakCount());
        }
        this.playerAccessRepository.removeByClaim(claim2.getId());
        this.claimPermissionRepository.removeByClaim(claim2.getId());
        this.flagRepository.removeByClaim(claim2.getId());
        this.partitionRepository.removeByClaim(claim2.getId());
        this.claimRepository.remove(claim2.getId());
        return BreakClaimAnchorResult.Success.INSTANCE;
    }
}

