/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.anchor;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.results.claim.anchor.GetClaimAnchorAtPositionResult;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/anchor/GetClaimAnchorAtPosition;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/anchor/GetClaimAnchorAtPositionResult;", "position3D", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "worldId", "Ljava/util/UUID;", "BellClaims"})
public final class GetClaimAnchorAtPosition {
    @NotNull
    private final ClaimRepository claimRepository;

    public GetClaimAnchorAtPosition(@NotNull ClaimRepository claimRepository) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        this.claimRepository = claimRepository;
    }

    @NotNull
    public final GetClaimAnchorAtPositionResult execute(@NotNull Position3D position3D, @NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(position3D, "position3D");
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Claim claim = this.claimRepository.getByPosition(position3D, worldId);
        if (claim == null) {
            return GetClaimAnchorAtPositionResult.NoClaimAnchorFound.INSTANCE;
        }
        Claim claim2 = claim;
        return new GetClaimAnchorAtPositionResult.Success(claim2);
    }
}

