/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.anchor;

import dev.mizarc.bellclaims.application.actions.claim.GetClaimAtPosition;
import dev.mizarc.bellclaims.application.actions.player.DoesPlayerHaveClaimOverride;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.results.claim.GetClaimAtPositionResult;
import dev.mizarc.bellclaims.application.results.claim.anchor.MoveClaimAnchorResult;
import dev.mizarc.bellclaims.application.results.player.DoesPlayerHaveClaimOverrideResult;
import dev.mizarc.bellclaims.application.services.WorldManipulationService;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/anchor/MoveClaimAnchor;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "worldManipulationService", "Ldev/mizarc/bellclaims/application/services/WorldManipulationService;", "getClaimAtPosition", "Ldev/mizarc/bellclaims/application/actions/claim/GetClaimAtPosition;", "doesPlayerHaveClaimOverride", "Ldev/mizarc/bellclaims/application/actions/player/DoesPlayerHaveClaimOverride;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/services/WorldManipulationService;Ldev/mizarc/bellclaims/application/actions/claim/GetClaimAtPosition;Ldev/mizarc/bellclaims/application/actions/player/DoesPlayerHaveClaimOverride;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/anchor/MoveClaimAnchorResult;", "claimId", "Ljava/util/UUID;", "playerId", "newWorldId", "newPosition", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "BellClaims"})
public final class MoveClaimAnchor {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final WorldManipulationService worldManipulationService;
    @NotNull
    private final GetClaimAtPosition getClaimAtPosition;
    @NotNull
    private final DoesPlayerHaveClaimOverride doesPlayerHaveClaimOverride;

    public MoveClaimAnchor(@NotNull ClaimRepository claimRepository, @NotNull WorldManipulationService worldManipulationService, @NotNull GetClaimAtPosition getClaimAtPosition, @NotNull DoesPlayerHaveClaimOverride doesPlayerHaveClaimOverride) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(worldManipulationService, "worldManipulationService");
        Intrinsics.checkNotNullParameter(getClaimAtPosition, "getClaimAtPosition");
        Intrinsics.checkNotNullParameter(doesPlayerHaveClaimOverride, "doesPlayerHaveClaimOverride");
        this.claimRepository = claimRepository;
        this.worldManipulationService = worldManipulationService;
        this.getClaimAtPosition = getClaimAtPosition;
        this.doesPlayerHaveClaimOverride = doesPlayerHaveClaimOverride;
    }

    @NotNull
    public final MoveClaimAnchorResult execute(@NotNull UUID claimId, @NotNull UUID playerId, @NotNull UUID newWorldId, @NotNull Position3D newPosition) {
        boolean bl;
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(newWorldId, "newWorldId");
        Intrinsics.checkNotNullParameter(newPosition, "newPosition");
        Claim claim = this.claimRepository.getById(claimId);
        if (claim == null) {
            return MoveClaimAnchorResult.StorageError.INSTANCE;
        }
        Claim existingClaim = claim;
        Object result = this.getClaimAtPosition.execute(newWorldId, newPosition);
        if (!(result instanceof GetClaimAtPositionResult.Success)) {
            if (result instanceof GetClaimAtPositionResult.NoClaimFound) {
                return MoveClaimAnchorResult.InvalidPosition.INSTANCE;
            }
            if (result instanceof GetClaimAtPositionResult.StorageError) {
                return MoveClaimAnchorResult.StorageError.INSTANCE;
            }
            throw new NoWhenBranchMatchedException();
        }
        Claim claimAtPosition = ((GetClaimAtPositionResult.Success)result).getClaim();
        if (!Intrinsics.areEqual(claimAtPosition.getId(), claimId)) {
            return MoveClaimAnchorResult.InvalidPosition.INSTANCE;
        }
        result = this.doesPlayerHaveClaimOverride.execute(playerId);
        Object object = result;
        if (object instanceof DoesPlayerHaveClaimOverrideResult.StorageError) {
            bl = false;
        } else if (object instanceof DoesPlayerHaveClaimOverrideResult.Success) {
            bl = ((DoesPlayerHaveClaimOverrideResult.Success)result).getHasOverride();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean claimOverride = bl;
        if (!Intrinsics.areEqual(existingClaim.getPlayerId(), playerId) && !claimOverride) {
            return MoveClaimAnchorResult.NoPermission.INSTANCE;
        }
        this.worldManipulationService.breakWithoutItemDrop(existingClaim.getWorldId(), existingClaim.getPosition());
        Claim newClaim = Claim.copy$default(existingClaim, null, null, null, null, null, null, newPosition, null, 191, null);
        this.claimRepository.update(newClaim);
        return MoveClaimAnchorResult.Success.INSTANCE;
    }
}

