/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.flag;

import dev.mizarc.bellclaims.application.errors.DatabaseOperationException;
import dev.mizarc.bellclaims.application.persistence.ClaimFlagRepository;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.results.claim.flags.EnableAllClaimFlagsResult;
import dev.mizarc.bellclaims.domain.values.Flag;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/flag/EnableAllClaimFlags;", "", "flagRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimFlagRepository;", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimFlagRepository;Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/flags/EnableAllClaimFlagsResult;", "claimId", "Ljava/util/UUID;", "BellClaims"})
public final class EnableAllClaimFlags {
    @NotNull
    private final ClaimFlagRepository flagRepository;
    @NotNull
    private final ClaimRepository claimRepository;

    public EnableAllClaimFlags(@NotNull ClaimFlagRepository flagRepository, @NotNull ClaimRepository claimRepository) {
        Intrinsics.checkNotNullParameter(flagRepository, "flagRepository");
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        this.flagRepository = flagRepository;
        this.claimRepository = claimRepository;
    }

    @NotNull
    public final EnableAllClaimFlagsResult execute(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        if (this.claimRepository.getById(claimId) == null) {
            return EnableAllClaimFlagsResult.ClaimNotFound.INSTANCE;
        }
        boolean anyFlagEnabled = false;
        try {
            EnumEntries<Flag> allFlags = Flag.getEntries();
            for (Flag flag : allFlags) {
                if (!this.flagRepository.add(claimId, flag)) continue;
                anyFlagEnabled = true;
            }
            return anyFlagEnabled ? (EnableAllClaimFlagsResult)EnableAllClaimFlagsResult.Success.INSTANCE : (EnableAllClaimFlagsResult)EnableAllClaimFlagsResult.AllAlreadyEnabled.INSTANCE;
        }
        catch (DatabaseOperationException error) {
            System.out.println((Object)("Error has occurred trying to save to the database: " + error.getMessage()));
            return EnableAllClaimFlagsResult.StorageError.INSTANCE;
        }
    }
}

