/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.partition;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.results.claim.partition.CanRemovePartitionResult;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.Position2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u001e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0002J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/partition/CanRemovePartition;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/partition/CanRemovePartitionResult;", "partitionId", "Ljava/util/UUID;", "getPrimaryPartition", "Ldev/mizarc/bellclaims/domain/entities/Partition;", "claim", "Ldev/mizarc/bellclaims/domain/entities/Claim;", "isRemoveResultInAnyDisconnected", "", "partition", "isPartitionDisconnected", "testPartitions", "", "getLinked", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nCanRemovePartition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanRemovePartition.kt\ndev/mizarc/bellclaims/application/actions/claim/partition/CanRemovePartition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n774#2:85\n865#2,2:86\n*S KotlinDebug\n*F\n+ 1 CanRemovePartition.kt\ndev/mizarc/bellclaims/application/actions/claim/partition/CanRemovePartition\n*L\n82#1:85\n82#1:86,2\n*E\n"})
public final class CanRemovePartition {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;

    public CanRemovePartition(@NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
    }

    @NotNull
    public final CanRemovePartitionResult execute(@NotNull UUID partitionId) {
        Intrinsics.checkNotNullParameter(partitionId, "partitionId");
        Partition partition = this.partitionRepository.getById(partitionId);
        if (partition == null) {
            return CanRemovePartitionResult.StorageError.INSTANCE;
        }
        Partition partition2 = partition;
        if (this.isRemoveResultInAnyDisconnected(partition2)) {
            return CanRemovePartitionResult.Disconnected.INSTANCE;
        }
        Claim claim = this.claimRepository.getById(partition2.getClaimId());
        if (claim == null) {
            return CanRemovePartitionResult.StorageError.INSTANCE;
        }
        Claim claim2 = claim;
        if (Intrinsics.areEqual(partitionId, this.getPrimaryPartition(claim2).getId())) {
            return CanRemovePartitionResult.ExposedClaimAnchor.INSTANCE;
        }
        return CanRemovePartitionResult.Success.INSTANCE;
    }

    private final Partition getPrimaryPartition(Claim claim) {
        Set<Partition> claimPartitions = this.partitionRepository.getByClaim(claim.getId());
        return (Partition)CollectionsKt.first(CollectionsKt.intersect((Iterable)this.partitionRepository.getByPosition(new Position2D(claim.getPosition())), CollectionsKt.toSet((Iterable)claimPartitions)));
    }

    private final boolean isRemoveResultInAnyDisconnected(Partition partition) {
        Claim claim = this.claimRepository.getById(partition.getClaimId());
        if (claim == null) {
            return false;
        }
        Claim claim2 = claim;
        Set<Partition> claimPartitions = CollectionsKt.toMutableSet((Iterable)this.partitionRepository.getByClaim(claim2.getId()));
        Partition mainPartition = (Partition)CollectionsKt.first(CollectionsKt.intersect((Iterable)this.partitionRepository.getByPosition(claim2.getPosition()), CollectionsKt.toSet((Iterable)claimPartitions)));
        claimPartitions.remove(partition);
        for (Partition claimPartition : claimPartitions) {
            if (Intrinsics.areEqual(claimPartition.getId(), mainPartition.getId()) || !this.isPartitionDisconnected(claimPartition, claimPartitions)) continue;
            return true;
        }
        return false;
    }

    private final boolean isPartitionDisconnected(Partition partition, Set<Partition> testPartitions) {
        Claim claim = this.claimRepository.getById(partition.getClaimId());
        if (claim == null) {
            return false;
        }
        Claim claim2 = claim;
        Set<Partition> claimPartitions = this.partitionRepository.getByClaim(claim2.getId());
        Partition mainPartition = (Partition)CollectionsKt.first(CollectionsKt.intersect((Iterable)this.partitionRepository.getByPosition(claim2.getPosition()), CollectionsKt.toSet((Iterable)claimPartitions)));
        ArrayList<Partition> traversedPartitions = new ArrayList<Partition>();
        ArrayList<Partition> partitionQueries = new ArrayList<Partition>();
        partitionQueries.add(partition);
        while (!((Collection)partitionQueries).isEmpty()) {
            Iterator iterator2;
            ArrayList<Partition> partitionsToAdd = new ArrayList<Partition>();
            ArrayList<Partition> partitionsToRemove = new ArrayList<Partition>();
            Intrinsics.checkNotNullExpressionValue(partitionQueries.iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                Partition partitionQuery = (Partition)iterator2.next();
                Set<Partition> adjacentPartitions = this.getLinked(partitionQuery, testPartitions);
                for (Partition adjacentPartition : adjacentPartitions) {
                    if (Intrinsics.areEqual(adjacentPartition.getId(), mainPartition.getId())) {
                        return false;
                    }
                    if (traversedPartitions.contains(adjacentPartition)) continue;
                    partitionsToAdd.add(adjacentPartition);
                }
                partitionsToRemove.add(partitionQuery);
                traversedPartitions.add(partitionQuery);
            }
            partitionQueries.removeAll(CollectionsKt.toSet((Iterable)partitionsToRemove));
            partitionQueries.addAll((Collection)partitionsToAdd);
            partitionsToAdd.clear();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Partition> getLinked(Partition partition, Set<Partition> testPartitions) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = testPartitions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Partition it = (Partition)element$iv$iv;
            boolean bl = false;
            if (!(it.isPartitionLinked(partition) && Intrinsics.areEqual(it.getClaimId(), partition.getClaimId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }
}

