/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.partition;

import dev.mizarc.bellclaims.application.actions.claim.partition.CreatePartition;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.results.claim.partition.CreatePartitionResult;
import dev.mizarc.bellclaims.application.services.PlayerMetadataService;
import dev.mizarc.bellclaims.config.MainConfig;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.Area;
import dev.mizarc.bellclaims.domain.values.Position2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f2\u0006\u0010 \u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u001fH\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J \u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u00160$j\b\u0012\u0004\u0012\u00020\u0016`%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/partition/CreatePartition;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "playerMetadataService", "Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;", "config", "Ldev/mizarc/bellclaims/config/MainConfig;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;Ldev/mizarc/bellclaims/config/MainConfig;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/partition/CreatePartitionResult;", "claimId", "Ljava/util/UUID;", "area", "Ldev/mizarc/bellclaims/domain/values/Area;", "(Ljava/util/UUID;Ldev/mizarc/bellclaims/domain/values/Area;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isPartitionTooClose", "", "partition", "Ldev/mizarc/bellclaims/domain/entities/Partition;", "getSurroundingPositions", "", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "position", "radius", "", "isPartitionOverlap", "filterByWorld", "", "worldId", "inputPartitions", "getByChunk", "getAdjacent", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nCreatePartition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreatePartition.kt\ndev/mizarc/bellclaims/application/actions/claim/partition/CreatePartition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1374#2:159\n1460#2,5:160\n1374#2:165\n1460#2,5:166\n1374#2:171\n1460#2,5:172\n1761#2,3:177\n*S KotlinDebug\n*F\n+ 1 CreatePartition.kt\ndev/mizarc/bellclaims/application/actions/claim/partition/CreatePartition\n*L\n34#1:159\n34#1:160,5\n60#1:165\n60#1:166,5\n61#1:171\n61#1:172,5\n68#1:177,3\n*E\n"})
public final class CreatePartition {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final PlayerMetadataService playerMetadataService;
    @NotNull
    private final MainConfig config;

    public CreatePartition(@NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository, @NotNull PlayerMetadataService playerMetadataService, @NotNull MainConfig config) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(playerMetadataService, "playerMetadataService");
        Intrinsics.checkNotNullParameter(config, "config");
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
        this.playerMetadataService = playerMetadataService;
        this.config = config;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object execute(@NotNull UUID claimId, @NotNull Area area, @NotNull Continuation<? super CreatePartitionResult> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var20_4 = $completion;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ CreatePartition this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                partition = new Partition(claimId, area);
                if (this.isPartitionOverlap(partition)) {
                    return CreatePartitionResult.Overlaps.INSTANCE;
                }
                if (this.isPartitionTooClose(partition)) {
                    return CreatePartitionResult.TooClose.INSTANCE;
                }
                if (area.getXLength() < this.config.getMinimumPartitionSize() || area.getZLength() < this.config.getMinimumPartitionSize()) {
                    return new CreatePartitionResult.TooSmall(this.config.getMinimumPartitionSize());
                }
                v0 = this.claimRepository.getById(claimId);
                if (v0 == null) {
                    return CreatePartitionResult.StorageError.INSTANCE;
                }
                claim = v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(claimId);
                $continuation.L$1 = area;
                $continuation.L$2 = partition;
                $continuation.L$3 = claim;
                $continuation.label = 1;
                v1 = this.playerMetadataService.getPlayerClaimBlockLimitAsync(claim.getPlayerId(), $continuation);
                if (v1 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl39
            }
            case 1: {
                claim = (Claim)$continuation.L$3;
                partition = (Partition)$continuation.L$2;
                area = (Area)$continuation.L$1;
                claimId = (UUID)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl39:
                // 2 sources

                playerBlockLimit = ((Number)v1).intValue();
                $this$flatMap$iv = this.claimRepository.getByPlayer(claim.getPlayerId());
                $i$f$flatMap = false;
                var10_14 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                var13_18 = $this$flatMapTo$iv$iv.iterator();
                while (var13_18.hasNext()) {
                    element$iv$iv = var13_18.next();
                    playerClaim = (Claim)element$iv$iv;
                    $i$a$-flatMap-CreatePartition$execute$playerBlockCount$1 = false;
                    list$iv$iv = this.partitionRepository.getByClaim(playerClaim.getId());
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                var9_12 = 0;
                for (T var11_15 : $this$flatMap$iv) {
                    $i$f$flatMapTo = (Partition)var11_15;
                    var17_23 = var9_12;
                    $i$a$-sumOfInt-CreatePartition$execute$playerBlockCount$2 = false;
                    var18_24 = partition.getBlockCount();
                    var9_12 = var17_23 + var18_24;
                }
                playerBlockCount = var9_12;
                if (playerBlockCount + area.getBlockCount() > playerBlockLimit) {
                    requiredExtraBlocks = playerBlockCount + area.getBlockCount() - playerBlockLimit;
                    return new CreatePartitionResult.InsufficientBlocks(requiredExtraBlocks);
                }
                adjacentPartitions = this.getAdjacent(partition);
                v2 = adjacentPartitions.iterator();
                Intrinsics.checkNotNullExpressionValue(v2, "iterator(...)");
                var9_13 = v2;
                while (var9_13.hasNext()) {
                    adjacentPartition = var9_13.next();
                    if (!Intrinsics.areEqual(adjacentPartition.getClaimId(), partition.getClaimId())) continue;
                    this.partitionRepository.add(partition);
                    return new CreatePartitionResult.Success(claim, partition);
                }
                return CreatePartitionResult.Disconnected.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPartitionTooClose(Partition partition) {
        boolean bl;
        block6: {
            void $this$flatMapTo$iv$iv;
            void $this$flatMapTo$iv$iv2;
            Claim claim = this.claimRepository.getById(partition.getClaimId());
            if (claim == null) {
                return true;
            }
            Claim claim2 = claim;
            Iterable $this$flatMap$iv = partition.getArea().getChunks();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                Position2D it = (Position2D)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = this.getSurroundingPositions(it, 1);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List chunks = (List)destination$iv$iv;
            Iterable $this$flatMap$iv2 = chunks;
            boolean $i$f$flatMap2 = false;
            destination$iv$iv = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Position2D it = (Position2D)element$iv$iv;
                boolean bl3 = false;
                Iterable list$iv$iv = this.filterByWorld(claim2.getWorldId(), this.getByChunk(claim2.getWorldId(), it));
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            List partitions = CollectionsKt.toMutableList((List)destination$iv$iv2);
            CollectionsKt.removeAll(partitions, arg_0 -> CreatePartition.isPartitionTooClose$lambda$2(partition, arg_0));
            Area areaWithBoundary = new Area(new Position2D(partition.getArea().getLowerPosition2D().getX() - this.config.getDistanceBetweenClaims(), partition.getArea().getLowerPosition2D().getZ() - this.config.getDistanceBetweenClaims()), new Position2D(partition.getArea().getUpperPosition2D().getX() + this.config.getDistanceBetweenClaims(), partition.getArea().getUpperPosition2D().getZ() + this.config.getDistanceBetweenClaims()));
            Iterable $this$any$iv = partitions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Partition it = (Partition)element$iv;
                    boolean bl4 = false;
                    if (!it.isAreaOverlap(areaWithBoundary)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<Position2D> getSurroundingPositions(Position2D position, int radius) {
        List positions = new ArrayList();
        int i = -1 * radius;
        int n = 1 * radius;
        if (i <= n) {
            while (true) {
                int n2;
                int j;
                if ((j = -1 * radius) <= (n2 = 1 * radius)) {
                    while (true) {
                        positions.add(new Position2D(position.getX() + i, position.getZ() + j));
                        if (j == n2) break;
                        ++j;
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        return positions;
    }

    private final boolean isPartitionOverlap(Partition partition) {
        Claim claim = this.claimRepository.getById(partition.getClaimId());
        if (claim == null) {
            return true;
        }
        Claim claim2 = claim;
        ArrayList<Position2D> chunks = partition.getArea().getChunks();
        Set existingPartitions = new LinkedHashSet();
        Iterator<Position2D> iterator2 = chunks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Position2D> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Position2D chunk;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            existingPartitions.addAll((Collection)this.filterByWorld(claim2.getWorldId(), this.getByChunk(claim2.getWorldId(), chunk)));
        }
        CollectionsKt.removeAll(existingPartitions, arg_0 -> CreatePartition.isPartitionOverlap$lambda$0(partition, arg_0));
        for (Partition existingPartition : existingPartitions) {
            if (!existingPartition.isAreaOverlap(partition.getArea())) continue;
            return true;
        }
        return false;
    }

    private final Set<Partition> filterByWorld(UUID worldId, Set<Partition> inputPartitions) {
        Set outputPartitions = new LinkedHashSet();
        for (Partition partition : inputPartitions) {
            Claim claimPartition;
            if (this.claimRepository.getById(partition.getClaimId()) == null || !Intrinsics.areEqual(claimPartition.getWorldId(), worldId)) continue;
            outputPartitions.add(partition);
        }
        return outputPartitions;
    }

    private final Set<Partition> getByChunk(UUID worldId, Position2D position) {
        return this.filterByWorld(worldId, this.partitionRepository.getByChunk(position));
    }

    private final ArrayList<Partition> getAdjacent(Partition partition) {
        Claim claim = this.claimRepository.getById(partition.getClaimId());
        if (claim == null) {
            return new ArrayList<Partition>();
        }
        Claim claim2 = claim;
        Set<Object> partitionChunks = CollectionsKt.toSet((Iterable)partition.getChunks());
        Set chunks = new LinkedHashSet();
        for (Object chunk : partitionChunks) {
            chunks.add(chunk);
            chunks.addAll((Collection)this.getSurroundingPositions((Position2D)chunk, 1));
        }
        ArrayList chunkPartitions = new ArrayList();
        for (Object e : chunks) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Position2D chunk = (Position2D)e;
            chunkPartitions.addAll(this.getByChunk(claim2.getWorldId(), chunk));
        }
        ArrayList<Partition> adjacentPartitions = new ArrayList<Partition>();
        Iterator iterator2 = chunkPartitions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Partition chunkPartition = (Partition)iterator3.next();
            if (!chunkPartition.isPartitionAdjacent(partition)) continue;
            adjacentPartitions.add(chunkPartition);
        }
        return adjacentPartitions;
    }

    private static final boolean isPartitionTooClose$lambda$2(Partition $partition, Partition it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getClaimId(), $partition.getClaimId());
    }

    private static final boolean isPartitionOverlap$lambda$0(Partition $partition, Partition it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getId(), $partition.getId());
    }
}

