/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.partition;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.Position;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/partition/GetPartitionByPosition;", "", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;)V", "execute", "Ldev/mizarc/bellclaims/domain/entities/Partition;", "position", "Ldev/mizarc/bellclaims/domain/values/Position;", "worldId", "Ljava/util/UUID;", "BellClaims"})
public final class GetPartitionByPosition {
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final ClaimRepository claimRepository;

    public GetPartitionByPosition(@NotNull PartitionRepository partitionRepository, @NotNull ClaimRepository claimRepository) {
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        this.partitionRepository = partitionRepository;
        this.claimRepository = claimRepository;
    }

    @Nullable
    public final Partition execute(@NotNull Position position, @NotNull UUID worldId) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Set<Partition> partitions = this.partitionRepository.getByPosition(position);
        for (Partition partition : partitions) {
            Claim claim;
            if (this.claimRepository.getById(partition.getClaimId()) == null || !Intrinsics.areEqual(claim.getWorldId(), worldId)) continue;
            return partition;
        }
        return null;
    }
}

