/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.partition;

import dev.mizarc.bellclaims.application.actions.claim.partition.CanRemovePartition;
import dev.mizarc.bellclaims.application.errors.DatabaseOperationException;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.results.claim.partition.CanRemovePartitionResult;
import dev.mizarc.bellclaims.application.results.claim.partition.RemovePartitionResult;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/partition/RemovePartition;", "", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "canRemovePartition", "Ldev/mizarc/bellclaims/application/actions/claim/partition/CanRemovePartition;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/actions/claim/partition/CanRemovePartition;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/partition/RemovePartitionResult;", "partitionId", "Ljava/util/UUID;", "BellClaims"})
public final class RemovePartition {
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final CanRemovePartition canRemovePartition;

    public RemovePartition(@NotNull PartitionRepository partitionRepository, @NotNull CanRemovePartition canRemovePartition) {
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(canRemovePartition, "canRemovePartition");
        this.partitionRepository = partitionRepository;
        this.canRemovePartition = canRemovePartition;
    }

    @NotNull
    public final RemovePartitionResult execute(@NotNull UUID partitionId) {
        Intrinsics.checkNotNullParameter(partitionId, "partitionId");
        CanRemovePartitionResult canRemovePartitionResult = this.canRemovePartition.execute(partitionId);
        if (!Intrinsics.areEqual(canRemovePartitionResult, CanRemovePartitionResult.Success.INSTANCE)) {
            if (Intrinsics.areEqual(canRemovePartitionResult, CanRemovePartitionResult.StorageError.INSTANCE)) {
                return RemovePartitionResult.StorageError.INSTANCE;
            }
            if (Intrinsics.areEqual(canRemovePartitionResult, CanRemovePartitionResult.Disconnected.INSTANCE)) {
                return RemovePartitionResult.Disconnected.INSTANCE;
            }
            if (Intrinsics.areEqual(canRemovePartitionResult, CanRemovePartitionResult.ExposedClaimAnchor.INSTANCE)) {
                return RemovePartitionResult.ExposedClaimAnchor.INSTANCE;
            }
            throw new NoWhenBranchMatchedException();
        }
        try {
            RemovePartitionResult removePartitionResult;
            boolean bl = this.partitionRepository.remove(partitionId);
            if (bl) {
                removePartitionResult = RemovePartitionResult.Success.INSTANCE;
            } else if (!bl) {
                removePartitionResult = RemovePartitionResult.DoesNotExist.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return removePartitionResult;
        }
        catch (DatabaseOperationException databaseOperationException) {
            System.out.println((Object)"Error has occurred trying to save to the database");
            return RemovePartitionResult.StorageError.INSTANCE;
        }
    }
}

