/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.partition;

import dev.mizarc.bellclaims.application.actions.claim.partition.ResizePartition;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.results.claim.partition.ResizePartitionResult;
import dev.mizarc.bellclaims.application.services.PlayerMetadataService;
import dev.mizarc.bellclaims.config.MainConfig;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.Area;
import dev.mizarc.bellclaims.domain.values.Position2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u001e\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150#H\u0002J$\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010\u001a\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150#H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0011H\u0002J$\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010'\u001a\u00020\u000f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150#H\u0002J \u0010+\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010-\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/partition/ResizePartition;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "playerMetadataService", "Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;", "config", "Ldev/mizarc/bellclaims/config/MainConfig;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;Ldev/mizarc/bellclaims/config/MainConfig;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/partition/ResizePartitionResult;", "partitionId", "Ljava/util/UUID;", "selectedCorner", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "newCorner", "(Ljava/util/UUID;Ldev/mizarc/bellclaims/domain/values/Position2D;Ldev/mizarc/bellclaims/domain/values/Position2D;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPrimaryPartition", "Ldev/mizarc/bellclaims/domain/entities/Partition;", "claim", "Ldev/mizarc/bellclaims/domain/entities/Claim;", "isPartitionTooClose", "", "partition", "getSurroundingPositions", "", "position", "radius", "", "isResizeResultInAnyDisconnected", "isPartitionDisconnected", "testPartitions", "", "getLinked", "isPartitionOverlap", "getByChunk", "worldId", "chunkPosition", "filterByWorld", "inputPartitions", "setNewCorner", "Ldev/mizarc/bellclaims/domain/values/Area;", "area", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nResizePartition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResizePartition.kt\ndev/mizarc/bellclaims/application/actions/claim/partition/ResizePartition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1374#2:225\n1460#2,5:226\n1374#2:231\n1460#2,5:232\n1374#2:237\n1460#2,5:238\n1761#2,3:243\n774#2:246\n865#2,2:247\n*S KotlinDebug\n*F\n+ 1 ResizePartition.kt\ndev/mizarc/bellclaims/application/actions/claim/partition/ResizePartition\n*L\n44#1:225\n44#1:226,5\n77#1:231\n77#1:232,5\n78#1:237\n78#1:238,5\n85#1:243,3\n151#1:246\n151#1:247,2\n*E\n"})
public final class ResizePartition {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final PlayerMetadataService playerMetadataService;
    @NotNull
    private final MainConfig config;

    public ResizePartition(@NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository, @NotNull PlayerMetadataService playerMetadataService, @NotNull MainConfig config) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(playerMetadataService, "playerMetadataService");
        Intrinsics.checkNotNullParameter(config, "config");
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
        this.playerMetadataService = playerMetadataService;
        this.config = config;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object execute(@NotNull UUID partitionId, @NotNull Position2D selectedCorner, @NotNull Position2D newCorner, @NotNull Continuation<? super ResizePartitionResult> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var23_5 = $completion;
        if ((var23_5.label & -2147483648) != 0) {
            var23_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ ResizePartition this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var24_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                v0 = this.partitionRepository.getById(partitionId);
                if (v0 == null) {
                    return ResizePartitionResult.StorageError.INSTANCE;
                }
                partition = v0;
                newArea = this.setNewCorner(selectedCorner, newCorner, partition.getArea());
                newPartition = Partition.copy$default(partition, null, null, newArea, 3, null);
                if (this.isPartitionOverlap(newPartition)) {
                    return ResizePartitionResult.Overlaps.INSTANCE;
                }
                if (this.isPartitionTooClose(newPartition)) {
                    return ResizePartitionResult.TooClose.INSTANCE;
                }
                v1 = this.claimRepository.getById(newPartition.getClaimId());
                if (v1 == null) {
                    return ResizePartitionResult.StorageError.INSTANCE;
                }
                claim = v1;
                if (this.isResizeResultInAnyDisconnected(newPartition)) {
                    return ResizePartitionResult.Disconnected.INSTANCE;
                }
                if (Intrinsics.areEqual(newPartition.getId(), this.getPrimaryPartition(claim).getId()) && !newPartition.getArea().isPositionInArea(claim.getPosition())) {
                    return ResizePartitionResult.ExposedClaimAnchor.INSTANCE;
                }
                if (newPartition.getArea().getXLength() < this.config.getMinimumPartitionSize() || newPartition.getArea().getZLength() < this.config.getMinimumPartitionSize()) {
                    return new ResizePartitionResult.TooSmall(this.config.getMinimumPartitionSize());
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(partitionId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(selectedCorner);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(newCorner);
                $continuation.L$3 = partition;
                $continuation.L$4 = newArea;
                $continuation.L$5 = newPartition;
                $continuation.L$6 = claim;
                $continuation.label = 1;
                v2 = this.playerMetadataService.getPlayerClaimBlockLimitAsync(claim.getPlayerId(), $continuation);
                if (v2 == var24_7) {
                    return var24_7;
                }
                ** GOTO lbl54
            }
            case 1: {
                claim = (Claim)$continuation.L$6;
                newPartition = (Partition)$continuation.L$5;
                newArea = (Area)$continuation.L$4;
                partition = (Partition)$continuation.L$3;
                newCorner = (Position2D)$continuation.L$2;
                selectedCorner = (Position2D)$continuation.L$1;
                partitionId = (UUID)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl54:
                // 2 sources

                playerBlockLimit = ((Number)v2).intValue();
                $this$flatMap$iv = this.claimRepository.getByPlayer(claim.getPlayerId());
                $i$f$flatMap = false;
                var13_17 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    playerClaim = (Claim)element$iv$iv;
                    $i$a$-flatMap-ResizePartition$execute$playerBlockCount$1 = false;
                    list$iv$iv = this.partitionRepository.getByClaim(playerClaim.getId());
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                var12_16 = 0;
                for (E var14_18 : $this$flatMap$iv) {
                    $i$f$flatMapTo = (Partition)var14_18;
                    var20_26 = var12_16;
                    $i$a$-sumOfInt-ResizePartition$execute$playerBlockCount$2 = false;
                    var21_27 = partition.getBlockCount();
                    var12_16 = var20_26 + var21_27;
                }
                playerBlockCount = var12_16;
                if (playerBlockCount - partition.getArea().getBlockCount() + newPartition.getArea().getBlockCount() > playerBlockLimit) {
                    requiredExtraBlocks = playerBlockCount + newArea.getBlockCount() - playerBlockLimit;
                    return new ResizePartitionResult.InsufficientBlocks(requiredExtraBlocks);
                }
                if (this.isResizeResultInAnyDisconnected(newPartition)) {
                    return ResizePartitionResult.Disconnected.INSTANCE;
                }
                this.partitionRepository.update(newPartition);
                blocksRemaining = playerBlockLimit - playerBlockCount - newArea.getBlockCount();
                return new ResizePartitionResult.Success(claim, partition, blocksRemaining);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Partition getPrimaryPartition(Claim claim) {
        Set<Partition> claimPartitions = this.partitionRepository.getByClaim(claim.getId());
        return (Partition)CollectionsKt.first(CollectionsKt.intersect((Iterable)this.partitionRepository.getByPosition(new Position2D(claim.getPosition())), CollectionsKt.toSet((Iterable)claimPartitions)));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPartitionTooClose(Partition partition) {
        boolean bl;
        block6: {
            void $this$flatMapTo$iv$iv;
            void $this$flatMapTo$iv$iv2;
            Claim claim = this.claimRepository.getById(partition.getClaimId());
            if (claim == null) {
                return true;
            }
            Claim claim2 = claim;
            Iterable $this$flatMap$iv = partition.getArea().getChunks();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                Position2D it = (Position2D)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = this.getSurroundingPositions(it, 1);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List chunks = (List)destination$iv$iv;
            Iterable $this$flatMap$iv2 = chunks;
            boolean $i$f$flatMap2 = false;
            destination$iv$iv = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Position2D it = (Position2D)element$iv$iv;
                boolean bl3 = false;
                Iterable list$iv$iv = this.filterByWorld(claim2.getWorldId(), this.getByChunk(claim2.getWorldId(), it));
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            List partitions = CollectionsKt.toMutableList((List)destination$iv$iv2);
            CollectionsKt.removeAll(partitions, arg_0 -> ResizePartition.isPartitionTooClose$lambda$2(partition, arg_0));
            Area areaWithBoundary = new Area(new Position2D(partition.getArea().getLowerPosition2D().getX() - this.config.getDistanceBetweenClaims(), partition.getArea().getLowerPosition2D().getZ() - this.config.getDistanceBetweenClaims()), new Position2D(partition.getArea().getUpperPosition2D().getX() + this.config.getDistanceBetweenClaims(), partition.getArea().getUpperPosition2D().getZ() + this.config.getDistanceBetweenClaims()));
            Iterable $this$any$iv = partitions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Partition it = (Partition)element$iv;
                    boolean bl4 = false;
                    if (!it.isAreaOverlap(areaWithBoundary)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<Position2D> getSurroundingPositions(Position2D position, int radius) {
        List positions = new ArrayList();
        int i = -1 * radius;
        int n = 1 * radius;
        if (i <= n) {
            while (true) {
                int n2;
                int j;
                if ((j = -1 * radius) <= (n2 = 1 * radius)) {
                    while (true) {
                        positions.add(new Position2D(position.getX() + i, position.getZ() + j));
                        if (j == n2) break;
                        ++j;
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        return positions;
    }

    private final boolean isResizeResultInAnyDisconnected(Partition partition) {
        Claim claim = this.claimRepository.getById(partition.getClaimId());
        if (claim == null) {
            return false;
        }
        Claim claim2 = claim;
        Set<Partition> claimPartitions = CollectionsKt.toMutableSet((Iterable)this.partitionRepository.getByClaim(claim2.getId()));
        Partition mainPartition = (Partition)CollectionsKt.first(CollectionsKt.intersect((Iterable)this.partitionRepository.getByPosition(new Position2D(claim2.getPosition())), CollectionsKt.toSet((Iterable)claimPartitions)));
        CollectionsKt.removeAll((Iterable)claimPartitions, arg_0 -> ResizePartition.isResizeResultInAnyDisconnected$lambda$0(partition, arg_0));
        claimPartitions.add(partition);
        for (Partition claimPartition : claimPartitions) {
            if (Intrinsics.areEqual(claimPartition.getId(), mainPartition.getId()) || !this.isPartitionDisconnected(claimPartition, claimPartitions)) continue;
            return true;
        }
        return false;
    }

    private final boolean isPartitionDisconnected(Partition partition, Set<Partition> testPartitions) {
        Claim claim = this.claimRepository.getById(partition.getClaimId());
        if (claim == null) {
            return false;
        }
        Claim claim2 = claim;
        Set<Partition> claimPartitions = this.partitionRepository.getByClaim(claim2.getId());
        Partition mainPartition = (Partition)CollectionsKt.first(CollectionsKt.intersect((Iterable)this.partitionRepository.getByPosition(new Position2D(claim2.getPosition())), CollectionsKt.toSet((Iterable)claimPartitions)));
        ArrayList<Partition> traversedPartitions = new ArrayList<Partition>();
        ArrayList<Partition> partitionQueries = new ArrayList<Partition>();
        partitionQueries.add(partition);
        while (!((Collection)partitionQueries).isEmpty()) {
            Iterator iterator2;
            ArrayList<Partition> partitionsToAdd = new ArrayList<Partition>();
            ArrayList<Partition> partitionsToRemove = new ArrayList<Partition>();
            Intrinsics.checkNotNullExpressionValue(partitionQueries.iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                Partition partitionQuery = (Partition)iterator2.next();
                Set<Partition> adjacentPartitions = this.getLinked(partitionQuery, testPartitions);
                for (Partition adjacentPartition : adjacentPartitions) {
                    if (Intrinsics.areEqual(adjacentPartition.getId(), mainPartition.getId())) {
                        return false;
                    }
                    if (traversedPartitions.contains(adjacentPartition)) continue;
                    partitionsToAdd.add(adjacentPartition);
                }
                partitionsToRemove.add(partitionQuery);
                traversedPartitions.add(partitionQuery);
            }
            partitionQueries.removeAll(CollectionsKt.toSet((Iterable)partitionsToRemove));
            partitionQueries.addAll((Collection)partitionsToAdd);
            partitionsToAdd.clear();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Partition> getLinked(Partition partition, Set<Partition> testPartitions) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = testPartitions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Partition it = (Partition)element$iv$iv;
            boolean bl = false;
            if (!it.isPartitionLinked(partition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private final boolean isPartitionOverlap(Partition partition) {
        Claim claim = this.claimRepository.getById(partition.getClaimId());
        if (claim == null) {
            return true;
        }
        Claim claim2 = claim;
        ArrayList<Position2D> chunks = partition.getArea().getChunks();
        Set existingPartitions = new LinkedHashSet();
        Iterator<Position2D> iterator2 = chunks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Position2D> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Position2D chunk;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            existingPartitions.addAll((Collection)this.filterByWorld(claim2.getWorldId(), this.getByChunk(claim2.getWorldId(), chunk)));
        }
        CollectionsKt.removeAll(existingPartitions, arg_0 -> ResizePartition.isPartitionOverlap$lambda$0(partition, arg_0));
        for (Partition existingPartition : existingPartitions) {
            if (!existingPartition.isAreaOverlap(partition.getArea())) continue;
            return true;
        }
        return false;
    }

    private final Set<Partition> getByChunk(UUID worldId, Position2D chunkPosition) {
        return this.filterByWorld(worldId, this.partitionRepository.getByChunk(chunkPosition));
    }

    private final Set<Partition> filterByWorld(UUID worldId, Set<Partition> inputPartitions) {
        Set outputPartitions = new LinkedHashSet();
        for (Partition partition : inputPartitions) {
            Claim claimPartition;
            if (this.claimRepository.getById(partition.getClaimId()) == null || !Intrinsics.areEqual(claimPartition.getWorldId(), worldId)) continue;
            outputPartitions.add(partition);
        }
        return outputPartitions;
    }

    private final Area setNewCorner(Position2D selectedCorner, Position2D newCorner, Area area) {
        Position2D firstPosition2D = selectedCorner.getX() == area.getLowerPosition2D().getX() ? new Position2D(newCorner.getX(), 0) : new Position2D(area.getLowerPosition2D().getX(), 0);
        Position2D secondPosition2D = selectedCorner.getX() == area.getUpperPosition2D().getX() ? new Position2D(newCorner.getX(), 0) : new Position2D(area.getUpperPosition2D().getX(), 0);
        firstPosition2D = selectedCorner.getZ() == area.getLowerPosition2D().getZ() ? new Position2D(firstPosition2D.getX(), newCorner.getZ()) : new Position2D(firstPosition2D.getX(), area.getLowerPosition2D().getZ());
        secondPosition2D = selectedCorner.getZ() == area.getUpperPosition2D().getZ() ? new Position2D(secondPosition2D.getX(), newCorner.getZ()) : new Position2D(secondPosition2D.getX(), area.getUpperPosition2D().getZ());
        return new Area(firstPosition2D, secondPosition2D);
    }

    private static final boolean isPartitionTooClose$lambda$2(Partition $partition, Partition it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getClaimId(), $partition.getClaimId());
    }

    private static final boolean isResizeResultInAnyDisconnected$lambda$0(Partition $partition, Partition it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getId(), $partition.getId());
    }

    private static final boolean isPartitionOverlap$lambda$0(Partition $partition, Partition it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getId(), $partition.getId());
    }
}

