/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.permission;

import dev.mizarc.bellclaims.application.errors.DatabaseOperationException;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PlayerAccessRepository;
import dev.mizarc.bellclaims.application.results.claim.permission.GrantAllPlayerClaimPermissionsResult;
import dev.mizarc.bellclaims.domain.values.ClaimPermission;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/permission/GrantAllPlayerClaimPermissions;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "playerAccessRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerAccessRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PlayerAccessRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/permission/GrantAllPlayerClaimPermissionsResult;", "claimId", "Ljava/util/UUID;", "playerId", "BellClaims"})
public final class GrantAllPlayerClaimPermissions {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PlayerAccessRepository playerAccessRepository;

    public GrantAllPlayerClaimPermissions(@NotNull ClaimRepository claimRepository, @NotNull PlayerAccessRepository playerAccessRepository) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(playerAccessRepository, "playerAccessRepository");
        this.claimRepository = claimRepository;
        this.playerAccessRepository = playerAccessRepository;
    }

    @NotNull
    public final GrantAllPlayerClaimPermissionsResult execute(@NotNull UUID claimId, @NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        if (this.claimRepository.getById(claimId) == null) {
            return GrantAllPlayerClaimPermissionsResult.ClaimNotFound.INSTANCE;
        }
        boolean anyPermissionEnabled = false;
        try {
            EnumEntries<ClaimPermission> allPermissions = ClaimPermission.getEntries();
            for (ClaimPermission permission : allPermissions) {
                if (!this.playerAccessRepository.remove(claimId, playerId, permission)) continue;
                anyPermissionEnabled = true;
            }
            return anyPermissionEnabled ? (GrantAllPlayerClaimPermissionsResult)GrantAllPlayerClaimPermissionsResult.Success.INSTANCE : (GrantAllPlayerClaimPermissionsResult)GrantAllPlayerClaimPermissionsResult.AllAlreadyGranted.INSTANCE;
        }
        catch (DatabaseOperationException error) {
            System.out.println((Object)("Error has occurred trying to save to the database: " + error.getMessage()));
            return GrantAllPlayerClaimPermissionsResult.StorageError.INSTANCE;
        }
    }
}

