/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.permission;

import dev.mizarc.bellclaims.application.errors.DatabaseOperationException;
import dev.mizarc.bellclaims.application.persistence.ClaimPermissionRepository;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.results.claim.permission.RevokeClaimWidePermissionResult;
import dev.mizarc.bellclaims.domain.values.ClaimPermission;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/permission/RevokeClaimWidePermission;", "", "claimPermissionRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimPermissionRepository;", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimPermissionRepository;Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/permission/RevokeClaimWidePermissionResult;", "claimId", "Ljava/util/UUID;", "permission", "Ldev/mizarc/bellclaims/domain/values/ClaimPermission;", "BellClaims"})
public final class RevokeClaimWidePermission {
    @NotNull
    private final ClaimPermissionRepository claimPermissionRepository;
    @NotNull
    private final ClaimRepository claimRepository;

    public RevokeClaimWidePermission(@NotNull ClaimPermissionRepository claimPermissionRepository, @NotNull ClaimRepository claimRepository) {
        Intrinsics.checkNotNullParameter(claimPermissionRepository, "claimPermissionRepository");
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        this.claimPermissionRepository = claimPermissionRepository;
        this.claimRepository = claimRepository;
    }

    @NotNull
    public final RevokeClaimWidePermissionResult execute(@NotNull UUID claimId, @NotNull ClaimPermission permission) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter((Object)permission, "permission");
        if (this.claimRepository.getById(claimId) == null) {
            return RevokeClaimWidePermissionResult.ClaimNotFound.INSTANCE;
        }
        try {
            RevokeClaimWidePermissionResult revokeClaimWidePermissionResult;
            boolean bl = this.claimPermissionRepository.remove(claimId, permission);
            if (bl) {
                revokeClaimWidePermissionResult = RevokeClaimWidePermissionResult.Success.INSTANCE;
            } else if (!bl) {
                revokeClaimWidePermissionResult = RevokeClaimWidePermissionResult.DoesNotExist.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return revokeClaimWidePermissionResult;
        }
        catch (DatabaseOperationException error) {
            System.out.println((Object)"Error has occurred trying to save to the database");
            return RevokeClaimWidePermissionResult.StorageError.INSTANCE;
        }
    }
}

