/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.permission;

import dev.mizarc.bellclaims.application.errors.DatabaseOperationException;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PlayerAccessRepository;
import dev.mizarc.bellclaims.application.results.claim.permission.RevokePlayerClaimPermissionResult;
import dev.mizarc.bellclaims.domain.values.ClaimPermission;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/permission/RevokePlayerClaimPermission;", "", "playerAccessRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerAccessRepository;", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PlayerAccessRepository;Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/permission/RevokePlayerClaimPermissionResult;", "claimId", "Ljava/util/UUID;", "playerId", "permission", "Ldev/mizarc/bellclaims/domain/values/ClaimPermission;", "BellClaims"})
public final class RevokePlayerClaimPermission {
    @NotNull
    private final PlayerAccessRepository playerAccessRepository;
    @NotNull
    private final ClaimRepository claimRepository;

    public RevokePlayerClaimPermission(@NotNull PlayerAccessRepository playerAccessRepository, @NotNull ClaimRepository claimRepository) {
        Intrinsics.checkNotNullParameter(playerAccessRepository, "playerAccessRepository");
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        this.playerAccessRepository = playerAccessRepository;
        this.claimRepository = claimRepository;
    }

    @NotNull
    public final RevokePlayerClaimPermissionResult execute(@NotNull UUID claimId, @NotNull UUID playerId, @NotNull ClaimPermission permission) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)permission, "permission");
        if (this.claimRepository.getById(claimId) == null) {
            return RevokePlayerClaimPermissionResult.ClaimNotFound.INSTANCE;
        }
        try {
            RevokePlayerClaimPermissionResult revokePlayerClaimPermissionResult;
            boolean bl = this.playerAccessRepository.remove(claimId, playerId, permission);
            if (bl) {
                revokePlayerClaimPermissionResult = RevokePlayerClaimPermissionResult.Success.INSTANCE;
            } else if (!bl) {
                revokePlayerClaimPermissionResult = RevokePlayerClaimPermissionResult.DoesNotExist.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return revokePlayerClaimPermissionResult;
        }
        catch (DatabaseOperationException error) {
            System.out.println((Object)"Error has occurred trying to save to the database");
            return RevokePlayerClaimPermissionResult.StorageError.INSTANCE;
        }
    }
}

