/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.transfer;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.results.claim.transfer.AcceptTransferRequestResult;
import dev.mizarc.bellclaims.application.services.PlayerMetadataService;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/transfer/AcceptTransferRequest;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "playerMetadataService", "Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/transfer/AcceptTransferRequestResult;", "claimId", "Ljava/util/UUID;", "playerId", "newName", "", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nAcceptTransferRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcceptTransferRequest.kt\ndev/mizarc/bellclaims/application/actions/claim/transfer/AcceptTransferRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1374#2:48\n1460#2,5:49\n*S KotlinDebug\n*F\n+ 1 AcceptTransferRequest.kt\ndev/mizarc/bellclaims/application/actions/claim/transfer/AcceptTransferRequest\n*L\n28#1:48\n28#1:49,5\n*E\n"})
public final class AcceptTransferRequest {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PlayerMetadataService playerMetadataService;
    @NotNull
    private final PartitionRepository partitionRepository;

    public AcceptTransferRequest(@NotNull ClaimRepository claimRepository, @NotNull PlayerMetadataService playerMetadataService, @NotNull PartitionRepository partitionRepository) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(playerMetadataService, "playerMetadataService");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        this.claimRepository = claimRepository;
        this.playerMetadataService = playerMetadataService;
        this.partitionRepository = partitionRepository;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AcceptTransferRequestResult execute(@NotNull UUID claimId, @NotNull UUID playerId, @NotNull String newName) {
        int n;
        int n2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(newName, "newName");
        Claim claim = this.claimRepository.getById(claimId);
        if (claim == null) {
            return AcceptTransferRequestResult.ClaimNotFound.INSTANCE;
        }
        Claim claim2 = claim;
        if (Intrinsics.areEqual(claim2.getPlayerId(), playerId)) {
            return AcceptTransferRequestResult.PlayerOwnsClaim.INSTANCE;
        }
        if (!claim2.getTransferRequests().containsKey(playerId)) {
            return AcceptTransferRequestResult.NoActiveTransferRequest.INSTANCE;
        }
        int playerClaimLimit = this.playerMetadataService.getPlayerClaimLimit(playerId);
        int playerClaimCount = ((Collection)this.claimRepository.getByPlayer(playerId)).size();
        if (playerClaimCount >= playerClaimLimit) {
            return AcceptTransferRequestResult.ClaimLimitExceeded.INSTANCE;
        }
        int playerBlockLimit = this.playerMetadataService.getPlayerClaimBlockLimit(playerId);
        Iterable $this$flatMap$iv = this.claimRepository.getByPlayer(playerId);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Claim playerClaim = (Claim)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.partitionRepository.getByClaim(playerClaim.getId());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        int n3 = 0;
        for (Object object : $this$flatMap$iv) {
            void partition;
            Partition $i$f$flatMapTo2 = (Partition)object;
            n2 = n3;
            boolean bl = false;
            n = partition.getBlockCount();
            n3 = n2 + n;
        }
        int playerBlockCount = n3;
        Iterable iterable2 = this.partitionRepository.getByClaim(claim2.getId());
        int n4 = 0;
        for (Object e : iterable2) {
            void partition;
            Partition bl = (Partition)e;
            n2 = n4;
            boolean bl2 = false;
            n = partition.getBlockCount();
            n4 = n2 + n;
        }
        int claimBlockCount = n4;
        if (playerBlockCount + claimBlockCount > playerBlockLimit) {
            return AcceptTransferRequestResult.BlockLimitExceeded.INSTANCE;
        }
        if (this.claimRepository.getByName(claim2.getPlayerId(), newName) != null) {
            return AcceptTransferRequestResult.NameAlreadyExists.INSTANCE;
        }
        claim2.setPlayerId(playerId);
        this.claimRepository.update(claim2);
        return AcceptTransferRequestResult.Success.INSTANCE;
    }
}

