/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.claim.transfer;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.results.claim.transfer.CanPlayerReceiveTransferRequestResult;
import dev.mizarc.bellclaims.application.services.PlayerMetadataService;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/mizarc/bellclaims/application/actions/claim/transfer/CanPlayerReceiveTransferRequest;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "playerMetadataService", "Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;)V", "execute", "Ldev/mizarc/bellclaims/application/results/claim/transfer/CanPlayerReceiveTransferRequestResult;", "claimId", "Ljava/util/UUID;", "playerId", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nCanPlayerReceiveTransferRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanPlayerReceiveTransferRequest.kt\ndev/mizarc/bellclaims/application/actions/claim/transfer/CanPlayerReceiveTransferRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1374#2:45\n1460#2,5:46\n*S KotlinDebug\n*F\n+ 1 CanPlayerReceiveTransferRequest.kt\ndev/mizarc/bellclaims/application/actions/claim/transfer/CanPlayerReceiveTransferRequest\n*L\n29#1:45\n29#1:46,5\n*E\n"})
public final class CanPlayerReceiveTransferRequest {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final PlayerMetadataService playerMetadataService;

    public CanPlayerReceiveTransferRequest(@NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository, @NotNull PlayerMetadataService playerMetadataService) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(playerMetadataService, "playerMetadataService");
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
        this.playerMetadataService = playerMetadataService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CanPlayerReceiveTransferRequestResult execute(@NotNull UUID claimId, @NotNull UUID playerId) {
        int n;
        int n2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Claim claim = this.claimRepository.getById(claimId);
        if (claim == null) {
            return CanPlayerReceiveTransferRequestResult.ClaimNotFound.INSTANCE;
        }
        Claim claim2 = claim;
        if (Intrinsics.areEqual(claim2.getPlayerId(), playerId)) {
            return CanPlayerReceiveTransferRequestResult.PlayerOwnsClaim.INSTANCE;
        }
        int playerClaimLimit = this.playerMetadataService.getPlayerClaimLimit(playerId);
        int playerClaimCount = ((Collection)this.claimRepository.getByPlayer(playerId)).size();
        if (playerClaimCount >= playerClaimLimit) {
            return CanPlayerReceiveTransferRequestResult.ClaimLimitExceeded.INSTANCE;
        }
        int playerBlockLimit = this.playerMetadataService.getPlayerClaimBlockLimit(playerId);
        Iterable $this$flatMap$iv = this.claimRepository.getByPlayer(playerId);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Claim playerClaim = (Claim)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.partitionRepository.getByClaim(playerClaim.getId());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        int n3 = 0;
        for (Object object : $this$flatMap$iv) {
            void partition;
            Partition $i$f$flatMapTo2 = (Partition)object;
            n2 = n3;
            boolean bl = false;
            n = partition.getBlockCount();
            n3 = n2 + n;
        }
        int playerBlockCount = n3;
        Iterable iterable2 = this.partitionRepository.getByClaim(claim2.getId());
        int n4 = 0;
        for (Object e : iterable2) {
            void partition;
            Partition bl = (Partition)e;
            n2 = n4;
            boolean bl2 = false;
            n = partition.getBlockCount();
            n4 = n2 + n;
        }
        int claimBlockCount = n4;
        if (playerBlockCount + claimBlockCount > playerBlockLimit) {
            return CanPlayerReceiveTransferRequestResult.BlockLimitExceeded.INSTANCE;
        }
        return CanPlayerReceiveTransferRequestResult.Success.INSTANCE;
    }
}

