/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.services.PlayerMetadataService;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/GetRemainingClaimBlockCount;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "playerMetadataService", "Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;)V", "execute", "", "playerId", "Ljava/util/UUID;", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nGetRemainingClaimBlockCount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetRemainingClaimBlockCount.kt\ndev/mizarc/bellclaims/application/actions/player/GetRemainingClaimBlockCount\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,20:1\n1374#2:21\n1460#2,5:22\n*S KotlinDebug\n*F\n+ 1 GetRemainingClaimBlockCount.kt\ndev/mizarc/bellclaims/application/actions/player/GetRemainingClaimBlockCount\n*L\n13#1:21\n13#1:22,5\n*E\n"})
public final class GetRemainingClaimBlockCount {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final PlayerMetadataService playerMetadataService;

    public GetRemainingClaimBlockCount(@NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository, @NotNull PlayerMetadataService playerMetadataService) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(playerMetadataService, "playerMetadataService");
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
        this.playerMetadataService = playerMetadataService;
    }

    /*
     * WARNING - void declaration
     */
    public final int execute(@NotNull UUID playerId) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        int playerBlockLimit = this.playerMetadataService.getPlayerClaimBlockLimit(playerId);
        Iterable $this$flatMap$iv = this.claimRepository.getByPlayer(playerId);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Claim playerClaim = (Claim)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.partitionRepository.getByClaim(playerClaim.getId());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        int n = 0;
        for (Object e : iterable2) {
            void partition;
            Partition $i$f$flatMapTo2 = (Partition)e;
            int n2 = n;
            boolean bl = false;
            int n3 = partition.getBlockCount();
            n = n2 + n3;
        }
        int playerBlockCount = n;
        return playerBlockLimit - playerBlockCount;
    }
}

