/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PlayerStateRepository;
import dev.mizarc.bellclaims.application.results.player.RegisterClaimMenuOpeningResult;
import dev.mizarc.bellclaims.domain.entities.PlayerState;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/RegisterClaimMenuOpening;", "", "playerStateRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/player/RegisterClaimMenuOpeningResult;", "playerId", "Ljava/util/UUID;", "claimId", "BellClaims"})
public final class RegisterClaimMenuOpening {
    @NotNull
    private final PlayerStateRepository playerStateRepository;
    @NotNull
    private final ClaimRepository claimRepository;

    public RegisterClaimMenuOpening(@NotNull PlayerStateRepository playerStateRepository, @NotNull ClaimRepository claimRepository) {
        Intrinsics.checkNotNullParameter(playerStateRepository, "playerStateRepository");
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        this.playerStateRepository = playerStateRepository;
        this.claimRepository = claimRepository;
    }

    @NotNull
    public final RegisterClaimMenuOpeningResult execute(@NotNull UUID playerId, @NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        if (this.claimRepository.getById(claimId) == null) {
            return RegisterClaimMenuOpeningResult.ClaimNotFound.INSTANCE;
        }
        PlayerState playerState = this.playerStateRepository.get(playerId);
        if (playerState == null) {
            playerState = new PlayerState(playerId);
            this.playerStateRepository.add(playerState);
        }
        playerState.setInClaimMenu(claimId);
        this.playerStateRepository.update(playerState);
        return RegisterClaimMenuOpeningResult.Success.INSTANCE;
    }
}

