/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player.tool;

import dev.mizarc.bellclaims.application.errors.PlayerNotFoundException;
import dev.mizarc.bellclaims.application.results.player.tool.GivePlayerClaimToolResult;
import dev.mizarc.bellclaims.application.services.ToolItemService;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/tool/GivePlayerClaimTool;", "", "toolItemService", "Ldev/mizarc/bellclaims/application/services/ToolItemService;", "<init>", "(Ldev/mizarc/bellclaims/application/services/ToolItemService;)V", "execute", "Ldev/mizarc/bellclaims/application/results/player/tool/GivePlayerClaimToolResult;", "playerId", "Ljava/util/UUID;", "BellClaims"})
public final class GivePlayerClaimTool {
    @NotNull
    private final ToolItemService toolItemService;

    public GivePlayerClaimTool(@NotNull ToolItemService toolItemService) {
        Intrinsics.checkNotNullParameter(toolItemService, "toolItemService");
        this.toolItemService = toolItemService;
    }

    @NotNull
    public final GivePlayerClaimToolResult execute(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        try {
            if (this.toolItemService.doesPlayerHaveClaimTool(playerId)) {
                return GivePlayerClaimToolResult.PlayerAlreadyHasTool.INSTANCE;
            }
        }
        catch (PlayerNotFoundException playerNotFoundException) {
            return GivePlayerClaimToolResult.PlayerNotFound.INSTANCE;
        }
        this.toolItemService.giveClaimTool(playerId);
        return GivePlayerClaimToolResult.Success.INSTANCE;
    }
}

