/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player.tool;

import dev.mizarc.bellclaims.application.errors.PlayerNotFoundException;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.results.player.tool.GivePlayerMoveToolResult;
import dev.mizarc.bellclaims.application.services.ToolItemService;
import dev.mizarc.bellclaims.domain.entities.Claim;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/tool/GivePlayerMoveTool;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "toolItemService", "Ldev/mizarc/bellclaims/application/services/ToolItemService;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/services/ToolItemService;)V", "execute", "Ldev/mizarc/bellclaims/application/results/player/tool/GivePlayerMoveToolResult;", "playerId", "Ljava/util/UUID;", "claimId", "BellClaims"})
public final class GivePlayerMoveTool {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final ToolItemService toolItemService;

    public GivePlayerMoveTool(@NotNull ClaimRepository claimRepository, @NotNull ToolItemService toolItemService) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(toolItemService, "toolItemService");
        this.claimRepository = claimRepository;
        this.toolItemService = toolItemService;
    }

    @NotNull
    public final GivePlayerMoveToolResult execute(@NotNull UUID playerId, @NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Claim claim = this.claimRepository.getById(claimId);
        if (claim == null) {
            return GivePlayerMoveToolResult.ClaimNotFound.INSTANCE;
        }
        Claim claim2 = claim;
        try {
            if (this.toolItemService.doesPlayerHaveMoveTool(playerId, claim2)) {
                return GivePlayerMoveToolResult.PlayerAlreadyHasTool.INSTANCE;
            }
        }
        catch (PlayerNotFoundException playerNotFoundException) {
            return GivePlayerMoveToolResult.PlayerNotFound.INSTANCE;
        }
        this.toolItemService.giveMoveTool(playerId, claim2);
        return GivePlayerMoveToolResult.Success.INSTANCE;
    }
}

