/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player.tool;

import dev.mizarc.bellclaims.application.actions.player.visualisation.DisplayVisualisation;
import dev.mizarc.bellclaims.application.actions.player.visualisation.IsPlayerVisualising;
import dev.mizarc.bellclaims.application.actions.player.visualisation.ScheduleClearVisualisation;
import dev.mizarc.bellclaims.application.results.player.visualisation.IsPlayerVisualisingResult;
import dev.mizarc.bellclaims.application.services.ToolItemService;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJB\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/tool/SyncToolVisualization;", "", "toolItemService", "Ldev/mizarc/bellclaims/application/services/ToolItemService;", "displayVisualisation", "Ldev/mizarc/bellclaims/application/actions/player/visualisation/DisplayVisualisation;", "scheduleClearVisualisation", "Ldev/mizarc/bellclaims/application/actions/player/visualisation/ScheduleClearVisualisation;", "isPlayerVisualising", "Ldev/mizarc/bellclaims/application/actions/player/visualisation/IsPlayerVisualising;", "<init>", "(Ldev/mizarc/bellclaims/application/services/ToolItemService;Ldev/mizarc/bellclaims/application/actions/player/visualisation/DisplayVisualisation;Ldev/mizarc/bellclaims/application/actions/player/visualisation/ScheduleClearVisualisation;Ldev/mizarc/bellclaims/application/actions/player/visualisation/IsPlayerVisualising;)V", "execute", "", "playerId", "Ljava/util/UUID;", "position", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "mainHandItemData", "", "", "offHandItemData", "BellClaims"})
public final class SyncToolVisualization {
    @NotNull
    private final ToolItemService toolItemService;
    @NotNull
    private final DisplayVisualisation displayVisualisation;
    @NotNull
    private final ScheduleClearVisualisation scheduleClearVisualisation;
    @NotNull
    private final IsPlayerVisualising isPlayerVisualising;

    public SyncToolVisualization(@NotNull ToolItemService toolItemService, @NotNull DisplayVisualisation displayVisualisation, @NotNull ScheduleClearVisualisation scheduleClearVisualisation, @NotNull IsPlayerVisualising isPlayerVisualising) {
        Intrinsics.checkNotNullParameter(toolItemService, "toolItemService");
        Intrinsics.checkNotNullParameter(displayVisualisation, "displayVisualisation");
        Intrinsics.checkNotNullParameter(scheduleClearVisualisation, "scheduleClearVisualisation");
        Intrinsics.checkNotNullParameter(isPlayerVisualising, "isPlayerVisualising");
        this.toolItemService = toolItemService;
        this.displayVisualisation = displayVisualisation;
        this.scheduleClearVisualisation = scheduleClearVisualisation;
        this.isPlayerVisualising = isPlayerVisualising;
    }

    public final void execute(@NotNull UUID playerId, @NotNull Position3D position, @Nullable Map<String, String> mainHandItemData, @Nullable Map<String, String> offHandItemData) {
        boolean holdingClaimTool;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(position, "position");
        boolean bl = holdingClaimTool = this.toolItemService.isClaimTool(mainHandItemData) || this.toolItemService.isClaimTool(offHandItemData);
        if (holdingClaimTool) {
            this.displayVisualisation.execute(playerId, position);
        } else {
            IsPlayerVisualisingResult result = this.isPlayerVisualising.execute(playerId);
            if (result instanceof IsPlayerVisualisingResult.Success && ((IsPlayerVisualisingResult.Success)result).isVisualising()) {
                this.scheduleClearVisualisation.execute(playerId);
            }
        }
    }
}

