/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player.visualisation;

import dev.mizarc.bellclaims.application.persistence.PlayerStateRepository;
import dev.mizarc.bellclaims.application.services.VisualisationService;
import dev.mizarc.bellclaims.domain.entities.PlayerState;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/visualisation/ClearSelectionVisualisation;", "", "playerStateRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;", "visualisationService", "Ldev/mizarc/bellclaims/application/services/VisualisationService;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;Ldev/mizarc/bellclaims/application/services/VisualisationService;)V", "execute", "", "playerId", "Ljava/util/UUID;", "BellClaims"})
public final class ClearSelectionVisualisation {
    @NotNull
    private final PlayerStateRepository playerStateRepository;
    @NotNull
    private final VisualisationService visualisationService;

    public ClearSelectionVisualisation(@NotNull PlayerStateRepository playerStateRepository, @NotNull VisualisationService visualisationService) {
        Intrinsics.checkNotNullParameter(playerStateRepository, "playerStateRepository");
        Intrinsics.checkNotNullParameter(visualisationService, "visualisationService");
        this.playerStateRepository = playerStateRepository;
        this.visualisationService = visualisationService;
    }

    public final void execute(@NotNull UUID playerId) {
        Position3D selectedBlock;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        PlayerState playerState = this.playerStateRepository.get(playerId);
        if (playerState == null) {
            playerState = new PlayerState(playerId);
            this.playerStateRepository.add(playerState);
        }
        if ((selectedBlock = playerState.getSelectedBlock()) == null) {
            return;
        }
        this.visualisationService.clear(playerId, SetsKt.setOf(selectedBlock));
        playerState.setSelectedBlock(null);
        this.playerStateRepository.update(playerState);
    }
}

