/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player.visualisation;

import dev.mizarc.bellclaims.application.persistence.PlayerStateRepository;
import dev.mizarc.bellclaims.application.services.VisualisationService;
import dev.mizarc.bellclaims.domain.entities.PlayerState;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/visualisation/ClearVisualisation;", "", "playerStateRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;", "visualisationService", "Ldev/mizarc/bellclaims/application/services/VisualisationService;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;Ldev/mizarc/bellclaims/application/services/VisualisationService;)V", "execute", "", "playerId", "Ljava/util/UUID;", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClearVisualisation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClearVisualisation.kt\ndev/mizarc/bellclaims/application/actions/player/visualisation/ClearVisualisation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1374#2:39\n1460#2,5:40\n*S KotlinDebug\n*F\n+ 1 ClearVisualisation.kt\ndev/mizarc/bellclaims/application/actions/player/visualisation/ClearVisualisation\n*L\n25#1:39\n25#1:40,5\n*E\n"})
public final class ClearVisualisation {
    @NotNull
    private final PlayerStateRepository playerStateRepository;
    @NotNull
    private final VisualisationService visualisationService;

    public ClearVisualisation(@NotNull PlayerStateRepository playerStateRepository, @NotNull VisualisationService visualisationService) {
        Intrinsics.checkNotNullParameter(playerStateRepository, "playerStateRepository");
        Intrinsics.checkNotNullParameter(visualisationService, "visualisationService");
        this.playerStateRepository = playerStateRepository;
        this.visualisationService = visualisationService;
    }

    /*
     * WARNING - void declaration
     */
    public final void execute(@NotNull UUID playerId) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        PlayerState playerState = this.playerStateRepository.get(playerId);
        if (playerState == null) {
            playerState = new PlayerState(playerId);
            this.playerStateRepository.add(playerState);
        }
        Set<Position3D> claimBlocksToUnvisualise = CollectionsKt.toMutableSet(CollectionsKt.flatten((Iterable)playerState.getVisualisedClaims().values()));
        Iterable iterable = playerState.getVisualisedPartitions().values();
        Set<Position3D> set2 = claimBlocksToUnvisualise;
        boolean $i$f$flatMap = false;
        void var6_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map innerMap = (Map)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = innerMap.values();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        set2.addAll(CollectionsKt.flatten((List)destination$iv$iv));
        this.visualisationService.clear(playerId, claimBlocksToUnvisualise);
        playerState.getVisualisedClaims().clear();
        playerState.getVisualisedPartitions().clear();
        playerState.setVisualisingClaims(false);
        this.playerStateRepository.update(playerState);
    }
}

