/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player.visualisation;

import dev.mizarc.bellclaims.application.persistence.PlayerStateRepository;
import dev.mizarc.bellclaims.application.services.VisualisationService;
import dev.mizarc.bellclaims.domain.entities.PlayerState;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/visualisation/DisplaySelectionVisualisation;", "", "playerStateRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;", "visualisationService", "Ldev/mizarc/bellclaims/application/services/VisualisationService;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;Ldev/mizarc/bellclaims/application/services/VisualisationService;)V", "selectionBlock", "", "selectionCarpet", "execute", "", "playerId", "Ljava/util/UUID;", "position", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "BellClaims"})
public final class DisplaySelectionVisualisation {
    @NotNull
    private final PlayerStateRepository playerStateRepository;
    @NotNull
    private final VisualisationService visualisationService;
    @NotNull
    private final String selectionBlock;
    @NotNull
    private final String selectionCarpet;

    public DisplaySelectionVisualisation(@NotNull PlayerStateRepository playerStateRepository, @NotNull VisualisationService visualisationService) {
        Intrinsics.checkNotNullParameter(playerStateRepository, "playerStateRepository");
        Intrinsics.checkNotNullParameter(visualisationService, "visualisationService");
        this.playerStateRepository = playerStateRepository;
        this.visualisationService = visualisationService;
        this.selectionBlock = "LIME_GLAZED_TERRACOTTA";
        this.selectionCarpet = "LIME_CARPET";
    }

    public final void execute(@NotNull UUID playerId, @NotNull Position3D position) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(position, "position");
        PlayerState playerState = this.playerStateRepository.get(playerId);
        if (playerState == null) {
            playerState = new PlayerState(playerId);
            this.playerStateRepository.add(playerState);
        }
        this.visualisationService.displaySelected(playerId, position, this.selectionBlock, this.selectionCarpet);
        playerState.setSelectedBlock(position);
        this.playerStateRepository.update(playerState);
    }
}

