/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player.visualisation;

import dev.mizarc.bellclaims.application.actions.player.visualisation.ClearVisualisation;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.persistence.PlayerStateRepository;
import dev.mizarc.bellclaims.application.services.VisualisationService;
import dev.mizarc.bellclaims.application.services.scheduling.Task;
import dev.mizarc.bellclaims.config.MainConfig;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.entities.PlayerState;
import dev.mizarc.bellclaims.domain.values.Area;
import dev.mizarc.bellclaims.domain.values.Position2D;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ(\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00112\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0014J2\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00182\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J2\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00182\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00132\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/visualisation/DisplayVisualisation;", "", "playerStateRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "visualisationService", "Ldev/mizarc/bellclaims/application/services/VisualisationService;", "clearVisualisation", "Ldev/mizarc/bellclaims/application/actions/player/visualisation/ClearVisualisation;", "config", "Ldev/mizarc/bellclaims/config/MainConfig;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/services/VisualisationService;Ldev/mizarc/bellclaims/application/actions/player/visualisation/ClearVisualisation;Ldev/mizarc/bellclaims/config/MainConfig;)V", "execute", "", "Ljava/util/UUID;", "", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "playerId", "playerPosition", "displayComplete", "", "playerState", "Ldev/mizarc/bellclaims/domain/entities/PlayerState;", "displayPartitioned", "handleNonOwnedClaimDisplay", "claim", "Ldev/mizarc/bellclaims/domain/entities/Claim;", "getSurroundingChunks", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "chunkPosition", "radius", "", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nDisplayVisualisation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayVisualisation.kt\ndev/mizarc/bellclaims/application/actions/player/visualisation/DisplayVisualisation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1374#2:166\n1460#2,5:167\n774#2:172\n865#2,2:173\n1563#2:175\n1634#2,3:176\n774#2:179\n865#2,2:180\n1374#2:182\n1460#2,5:183\n774#2:188\n865#2,2:189\n774#2:191\n865#2,2:192\n1563#2:194\n1634#2,3:195\n*S KotlinDebug\n*F\n+ 1 DisplayVisualisation.kt\ndev/mizarc/bellclaims/application/actions/player/visualisation/DisplayVisualisation\n*L\n68#1:166\n68#1:167,5\n79#1:172\n79#1:173,2\n85#1:175\n85#1:176,3\n89#1:179\n89#1:180,2\n104#1:182\n104#1:183,5\n125#1:188\n125#1:189,2\n132#1:191\n132#1:192,2\n146#1:194\n146#1:195,3\n*E\n"})
public final class DisplayVisualisation {
    @NotNull
    private final PlayerStateRepository playerStateRepository;
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final VisualisationService visualisationService;
    @NotNull
    private final ClearVisualisation clearVisualisation;
    @NotNull
    private final MainConfig config;

    public DisplayVisualisation(@NotNull PlayerStateRepository playerStateRepository, @NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository, @NotNull VisualisationService visualisationService, @NotNull ClearVisualisation clearVisualisation, @NotNull MainConfig config) {
        Intrinsics.checkNotNullParameter(playerStateRepository, "playerStateRepository");
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(visualisationService, "visualisationService");
        Intrinsics.checkNotNullParameter(clearVisualisation, "clearVisualisation");
        Intrinsics.checkNotNullParameter(config, "config");
        this.playerStateRepository = playerStateRepository;
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
        this.visualisationService = visualisationService;
        this.clearVisualisation = clearVisualisation;
        this.config = config;
    }

    @NotNull
    public final Map<UUID, Set<Position3D>> execute(@NotNull UUID playerId, @NotNull Position3D playerPosition) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(playerPosition, "playerPosition");
        PlayerState playerState = this.playerStateRepository.get(playerId);
        if (playerState == null) {
            playerState = new PlayerState(playerId);
            this.playerStateRepository.add(playerState);
        }
        long refreshPeriodInMillis = (long)(this.config.getVisualiserRefreshPeriod() * (double)1000);
        Instant lastVisualisation = playerState.getLastVisualisationTime();
        if (lastVisualisation != null && lastVisualisation.plus(Duration.ofMillis(refreshPeriodInMillis)).isAfter(Instant.now())) {
            return new LinkedHashMap();
        }
        this.clearVisualisation.execute(playerId);
        Map borders = new LinkedHashMap();
        if (playerState.getClaimToolMode() == 1) {
            borders.putAll(this.displayPartitioned(playerId, playerState, playerPosition));
        } else {
            borders.putAll(this.displayComplete(playerId, playerState, playerPosition));
            playerState.setVisualisedClaims(borders);
        }
        Task task = playerState.getScheduledVisualiserHide();
        if (task != null) {
            task.cancel();
        }
        playerState.setVisualisingClaims(true);
        playerState.setLastVisualisationTime(Instant.now());
        this.playerStateRepository.update(playerState);
        return borders;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<UUID, Set<Position3D>> displayComplete(UUID playerId, PlayerState playerState, Position3D playerPosition) {
        void $this$flatMapTo$iv$iv;
        Position2D chunkPosition = new Position2D((int)Math.floor((double)playerPosition.getX() / 16.0), (int)Math.floor((double)playerPosition.getZ() / 16.0));
        Set<Position2D> chunks = this.getSurroundingChunks(chunkPosition, 16);
        Iterable $this$flatMap$iv = chunks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Position2D it = (Position2D)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.partitionRepository.getByChunk(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Set<Partition> partitions = CollectionsKt.toSet((List)destination$iv$iv);
        if (partitions.isEmpty()) {
            return new LinkedHashMap();
        }
        Map visualised = new LinkedHashMap();
        for (Partition partition : partitions) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable $this$mapTo$iv$iv;
            Object it;
            Iterable $this$filterTo$iv$iv2;
            Claim claim;
            if (visualised.containsKey(partition.getClaimId()) || this.claimRepository.getById(partition.getClaimId()) == null) continue;
            if (!Intrinsics.areEqual(claim.getPlayerId(), playerId)) {
                Map $i$f$flatMapTo22 = visualised;
                UUID uUID = claim.getId();
                Set $this$filter$iv2 = this.handleNonOwnedClaimDisplay(playerId, claim);
                boolean $i$f$filter = false;
                Set bl = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it = (Position3D)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(it, playerState.getSelectedBlock()))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv2 = CollectionsKt.toSet((List)destination$iv$iv2);
                $i$f$flatMapTo22.put(uUID, $this$filter$iv2);
                continue;
            }
            Set<Partition> partitions2 = this.partitionRepository.getByClaim(claim.getId());
            Iterable $this$map$iv = partitions2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo232 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Partition)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(((Partition)it).getArea());
            }
            Set<Area> areas = CollectionsKt.toMutableSet((List)destination$iv$iv2);
            Map map2 = visualised;
            UUID uUID = claim.getId();
            $this$mapTo$iv$iv = this.visualisationService.displayComplete(playerId, areas, "LIGHT_BLUE_GLAZED_TERRACOTTA", "LIGHT_BLUE_CARPET", "BLUE_GLAZED_TERRACOTTA", "BLUE_CARPET");
            boolean $i$f$filter = false;
            void $i$f$mapTo232 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Position3D it2 = (Position3D)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it2, playerState.getSelectedBlock()))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            Set set2 = CollectionsKt.toSet((List)destination$iv$iv3);
            map2.put(uUID, set2);
        }
        return visualised;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<UUID, Set<Position3D>> displayPartitioned(UUID playerId, PlayerState playerState, Position3D playerPosition) {
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Position2D chunkPosition = new Position2D((int)Math.floor((double)playerPosition.getX() / 16.0), (int)Math.floor((double)playerPosition.getZ() / 16.0));
        Set<Position2D> chunks = this.getSurroundingChunks(chunkPosition, 16);
        Iterable $this$flatMap$iv = chunks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Object object = $this$flatMapTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            Position2D it = (Position2D)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.partitionRepository.getByChunk(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Set<Partition> partitions = CollectionsKt.toSet((List)destination$iv$iv);
        if (partitions.isEmpty()) {
            return new LinkedHashMap();
        }
        Map visualised = new LinkedHashMap();
        for (Partition partition : partitions) {
            Set set2;
            Claim claim;
            if (this.claimRepository.getById(partition.getClaimId()) == null) continue;
            if (!Intrinsics.areEqual(claim.getPlayerId(), playerId)) {
                Set positions = CollectionsKt.toMutableSet((Iterable)this.handleNonOwnedClaimDisplay(playerId, claim));
                visualised.put(claim.getId(), positions);
                playerState.getVisualisedClaims().put(claim.getId(), positions);
                continue;
            }
            if (partition.getArea().isPositionInArea(claim.getPosition())) {
                object = this.visualisationService.displayPartitioned(playerId, SetsKt.setOf(partition.getArea()), "CYAN_GLAZED_TERRACOTTA", "CYAN_CARPET", "BLUE_GLAZED_TERRACOTTA", "BLUE_CARPET");
                $i$f$filter = false;
                list$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Position3D)element$iv$iv;
                    bl = false;
                    if (!(!Intrinsics.areEqual(it, playerState.getSelectedBlock()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set2 = CollectionsKt.toSet((List)destination$iv$iv);
            } else {
                $this$filter$iv = this.visualisationService.displayPartitioned(playerId, SetsKt.setOf(partition.getArea()), "LIGHT_GRAY_GLAZED_TERRACOTTA", "LIGHT_GRAY_CARPET", "BLUE_GLAZED_TERRACOTTA", "BLUE_CARPET");
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Position3D)element$iv$iv;
                    bl = false;
                    if (!(!Intrinsics.areEqual(it, playerState.getSelectedBlock()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set2 = CollectionsKt.toSet((List)destination$iv$iv);
            }
            Set newPositions = set2;
            visualised.computeIfAbsent(claim.getId(), arg_0 -> DisplayVisualisation.displayPartitioned$lambda$4(DisplayVisualisation::displayPartitioned$lambda$3, arg_0)).addAll(newPositions);
            Intrinsics.checkNotNullExpressionValue(playerState.getVisualisedPartitions().computeIfAbsent(claim.getId(), arg_0 -> DisplayVisualisation.displayPartitioned$lambda$6(DisplayVisualisation::displayPartitioned$lambda$5, arg_0)), "computeIfAbsent(...)");
            object.put(partition.getId(), newPositions);
        }
        return visualised;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Position3D> handleNonOwnedClaimDisplay(UUID playerId, Claim claim) {
        void $this$mapTo$iv$iv;
        Set<Partition> partitions = this.partitionRepository.getByClaim(claim.getId());
        Iterable $this$map$iv = partitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Partition partition = (Partition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getArea());
        }
        Set<Area> areas = CollectionsKt.toMutableSet((List)destination$iv$iv);
        return this.visualisationService.displayComplete(playerId, areas, "RED_GLAZED_TERRACOTTA", "RED_CARPET", "BLACK_GLAZED_TERRACOTTA", "BLACK_CARPET");
    }

    private final Set<Position2D> getSurroundingChunks(Position2D chunkPosition, int radius) {
        int sideLength = radius * 2 + 1;
        Set chunks = new LinkedHashSet();
        for (int x = 0; x < sideLength; ++x) {
            for (int z = 0; z < sideLength; ++z) {
                chunks.add(new Position2D(chunkPosition.getX() + x - radius, chunkPosition.getZ() + z - radius));
            }
        }
        return chunks;
    }

    private static final Set displayPartitioned$lambda$3(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new LinkedHashSet();
    }

    private static final Set displayPartitioned$lambda$4(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Map displayPartitioned$lambda$5(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new LinkedHashMap();
    }

    private static final Map displayPartitioned$lambda$6(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }
}

