/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player.visualisation;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PlayerStateRepository;
import dev.mizarc.bellclaims.application.results.player.visualisation.GetVisualisedClaimBlocksResult;
import dev.mizarc.bellclaims.domain.entities.PlayerState;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/visualisation/GetVisualisedClaimBlocks;", "", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "playerStateRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;)V", "execute", "Ldev/mizarc/bellclaims/application/results/player/visualisation/GetVisualisedClaimBlocksResult;", "playerId", "Ljava/util/UUID;", "claimId", "BellClaims"})
public final class GetVisualisedClaimBlocks {
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PlayerStateRepository playerStateRepository;

    public GetVisualisedClaimBlocks(@NotNull ClaimRepository claimRepository, @NotNull PlayerStateRepository playerStateRepository) {
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(playerStateRepository, "playerStateRepository");
        this.claimRepository = claimRepository;
        this.playerStateRepository = playerStateRepository;
    }

    @NotNull
    public final GetVisualisedClaimBlocksResult execute(@NotNull UUID playerId, @NotNull UUID claimId) {
        Set<Position3D> blockPositions;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        if (this.claimRepository.getById(claimId) == null) {
            return GetVisualisedClaimBlocksResult.ClaimNotFound.INSTANCE;
        }
        PlayerState playerState = this.playerStateRepository.get(playerId);
        if (playerState == null) {
            playerState = new PlayerState(playerId);
            this.playerStateRepository.add(playerState);
        }
        if ((blockPositions = playerState.getVisualisedClaims().get(claimId)) != null) {
            return new GetVisualisedClaimBlocksResult.Success(CollectionsKt.toSet((Iterable)blockPositions));
        }
        return GetVisualisedClaimBlocksResult.NotVisualising.INSTANCE;
    }
}

