/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player.visualisation;

import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.application.persistence.PlayerStateRepository;
import dev.mizarc.bellclaims.application.services.VisualisationService;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.entities.PlayerState;
import dev.mizarc.bellclaims.domain.values.Area;
import dev.mizarc.bellclaims.domain.values.Position3D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/visualisation/RefreshVisualisation;", "", "playerStateRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;", "claimRepository", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "partitionRepository", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "visualisationService", "Ldev/mizarc/bellclaims/application/services/VisualisationService;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;Ldev/mizarc/bellclaims/application/services/VisualisationService;)V", "execute", "", "playerId", "Ljava/util/UUID;", "claimId", "partitionId", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nRefreshVisualisation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshVisualisation.kt\ndev/mizarc/bellclaims/application/actions/player/visualisation/RefreshVisualisation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1563#2:79\n1634#2,3:80\n1563#2:83\n1634#2,3:84\n*S KotlinDebug\n*F\n+ 1 RefreshVisualisation.kt\ndev/mizarc/bellclaims/application/actions/player/visualisation/RefreshVisualisation\n*L\n28#1:79\n28#1:80,3\n71#1:83\n71#1:84,3\n*E\n"})
public final class RefreshVisualisation {
    @NotNull
    private final PlayerStateRepository playerStateRepository;
    @NotNull
    private final ClaimRepository claimRepository;
    @NotNull
    private final PartitionRepository partitionRepository;
    @NotNull
    private final VisualisationService visualisationService;

    public RefreshVisualisation(@NotNull PlayerStateRepository playerStateRepository, @NotNull ClaimRepository claimRepository, @NotNull PartitionRepository partitionRepository, @NotNull VisualisationService visualisationService) {
        Intrinsics.checkNotNullParameter(playerStateRepository, "playerStateRepository");
        Intrinsics.checkNotNullParameter(claimRepository, "claimRepository");
        Intrinsics.checkNotNullParameter(partitionRepository, "partitionRepository");
        Intrinsics.checkNotNullParameter(visualisationService, "visualisationService");
        this.playerStateRepository = playerStateRepository;
        this.claimRepository = claimRepository;
        this.partitionRepository = partitionRepository;
        this.visualisationService = visualisationService;
    }

    /*
     * WARNING - void declaration
     */
    public final void execute(@NotNull UUID playerId, @NotNull UUID claimId, @NotNull UUID partitionId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(partitionId, "partitionId");
        PlayerState playerState = this.playerStateRepository.get(playerId);
        if (playerState == null) {
            playerState = new PlayerState(playerId);
            this.playerStateRepository.add(playerState);
        }
        Claim claim = this.claimRepository.getById(claimId);
        if (claim == null) {
            return;
        }
        Claim claim2 = claim;
        if (!Intrinsics.areEqual(claim2.getPlayerId(), playerId)) {
            void $this$mapTo$iv$iv;
            Set<Position3D> set2 = playerState.getVisualisedClaims().get(claimId);
            if (set2 == null) {
                return;
            }
            Set<Position3D> visualisedPositions = set2;
            Set<Partition> partitions = this.partitionRepository.getByClaim(claim2.getId());
            Iterable $this$map$iv = partitions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Partition partition = (Partition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getArea());
            }
            Set<Area> areas = CollectionsKt.toMutableSet((List)destination$iv$iv);
            Set<Position3D> newPositions2 = this.visualisationService.refreshComplete(playerId, visualisedPositions, areas, "RED_GLAZED_TERRACOTTA", "RED_CARPET", "BLACK_GLAZED_TERRACOTTA", "BLACK_CARPET");
            playerState.getVisualisedClaims().put(claimId, newPositions2);
            return;
        }
        if (playerState.getClaimToolMode() == 1) {
            Set<Position3D> visualisedPositions;
            Partition partition = this.partitionRepository.getById(partitionId);
            if (partition == null) {
                Set set3 = (Set)playerState.getVisualisedPartitions().computeIfAbsent(claim2.getId(), arg_0 -> RefreshVisualisation.execute$lambda$2(RefreshVisualisation::execute$lambda$1, arg_0)).remove(partitionId);
                if (set3 == null) {
                    return;
                }
                Set blocksToClear = set3;
                this.visualisationService.clear(playerId, blocksToClear);
                return;
            }
            Map<UUID, Set<Position3D>> map2 = playerState.getVisualisedPartitions().get(claimId);
            if (map2 != null) {
                map2.get(partitionId);
            }
            Map<UUID, Set<Position3D>> map3 = playerState.getVisualisedPartitions().get(claimId);
            Set<Position3D> set4 = visualisedPositions = map3 != null ? map3.get(partitionId) : null;
            if (visualisedPositions == null) {
                Set<Position3D> newPositions = this.visualisationService.refreshPartitioned(playerId, SetsKt.emptySet(), SetsKt.setOf(partition.getArea()), "LIGHT_GRAY_GLAZED_TERRACOTTA", "LIGHT_GRAY_CARPET", "BLUE_GLAZED_TERRACOTTA", "BLUE_CARPET");
                Map map4 = playerState.getVisualisedPartitions().computeIfAbsent(claim2.getId(), arg_0 -> RefreshVisualisation.execute$lambda$4(RefreshVisualisation::execute$lambda$3, arg_0));
                Intrinsics.checkNotNullExpressionValue(map4, "computeIfAbsent(...)");
                Map newPositions2 = map4;
                newPositions2.put(partition.getId(), newPositions);
            } else {
                Set<Position3D> newPositions = partition.getArea().isPositionInArea(claim2.getPosition()) ? this.visualisationService.refreshPartitioned(playerId, visualisedPositions, SetsKt.setOf(partition.getArea()), "CYAN_GLAZED_TERRACOTTA", "CYAN_CARPET", "BLUE_GLAZED_TERRACOTTA", "BLUE_CARPET") : this.visualisationService.refreshPartitioned(playerId, visualisedPositions, SetsKt.setOf(partition.getArea()), "LIGHT_GRAY_GLAZED_TERRACOTTA", "LIGHT_GRAY_CARPET", "BLUE_GLAZED_TERRACOTTA", "BLUE_CARPET");
                Map map5 = playerState.getVisualisedPartitions().computeIfAbsent(claim2.getId(), arg_0 -> RefreshVisualisation.execute$lambda$6(RefreshVisualisation::execute$lambda$5, arg_0));
                Intrinsics.checkNotNullExpressionValue(map5, "computeIfAbsent(...)");
                Map newPositions2 = map5;
                newPositions2.put(partition.getId(), newPositions);
            }
        } else {
            Set<Position3D> set5 = playerState.getVisualisedClaims().get(claimId);
            if (set5 == null) {
                return;
            }
            Set<Position3D> visualisedPositions = set5;
            Set<Partition> partitions = this.partitionRepository.getByClaim(claim2.getId());
            Iterable $this$map$iv = partitions;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Partition it = (Partition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getArea());
            }
            Set<Area> areas = CollectionsKt.toMutableSet((List)destination$iv$iv);
            Set<Position3D> newPositions = this.visualisationService.refreshComplete(playerId, visualisedPositions, areas, "LIGHT_BLUE_GLAZED_TERRACOTTA", "LIGHT_BLUE_CARPET", "BLUE_GLAZED_TERRACOTTA", "BLUE_CARPET");
            playerState.getVisualisedClaims().put(claimId, newPositions);
            return;
        }
    }

    private static final Map execute$lambda$1(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new LinkedHashMap();
    }

    private static final Map execute$lambda$2(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map execute$lambda$3(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new LinkedHashMap();
    }

    private static final Map execute$lambda$4(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map execute$lambda$5(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new LinkedHashMap();
    }

    private static final Map execute$lambda$6(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }
}

