/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.application.actions.player.visualisation;

import dev.mizarc.bellclaims.application.actions.player.visualisation.ClearSelectionVisualisation;
import dev.mizarc.bellclaims.application.actions.player.visualisation.ClearVisualisation;
import dev.mizarc.bellclaims.application.persistence.PlayerStateRepository;
import dev.mizarc.bellclaims.application.results.player.visualisation.ScheduleClearVisualisationResult;
import dev.mizarc.bellclaims.application.services.scheduling.SchedulerService;
import dev.mizarc.bellclaims.application.services.scheduling.Task;
import dev.mizarc.bellclaims.config.MainConfig;
import dev.mizarc.bellclaims.domain.entities.PlayerState;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/mizarc/bellclaims/application/actions/player/visualisation/ScheduleClearVisualisation;", "", "playerStateRepository", "Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;", "schedulerService", "Ldev/mizarc/bellclaims/application/services/scheduling/SchedulerService;", "clearVisualisation", "Ldev/mizarc/bellclaims/application/actions/player/visualisation/ClearVisualisation;", "clearSelectionVisualisation", "Ldev/mizarc/bellclaims/application/actions/player/visualisation/ClearSelectionVisualisation;", "config", "Ldev/mizarc/bellclaims/config/MainConfig;", "<init>", "(Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;Ldev/mizarc/bellclaims/application/services/scheduling/SchedulerService;Ldev/mizarc/bellclaims/application/actions/player/visualisation/ClearVisualisation;Ldev/mizarc/bellclaims/application/actions/player/visualisation/ClearSelectionVisualisation;Ldev/mizarc/bellclaims/config/MainConfig;)V", "execute", "Ldev/mizarc/bellclaims/application/results/player/visualisation/ScheduleClearVisualisationResult;", "playerId", "Ljava/util/UUID;", "BellClaims"})
public final class ScheduleClearVisualisation {
    @NotNull
    private final PlayerStateRepository playerStateRepository;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final ClearVisualisation clearVisualisation;
    @NotNull
    private final ClearSelectionVisualisation clearSelectionVisualisation;
    @NotNull
    private final MainConfig config;

    public ScheduleClearVisualisation(@NotNull PlayerStateRepository playerStateRepository, @NotNull SchedulerService schedulerService, @NotNull ClearVisualisation clearVisualisation, @NotNull ClearSelectionVisualisation clearSelectionVisualisation, @NotNull MainConfig config) {
        Intrinsics.checkNotNullParameter(playerStateRepository, "playerStateRepository");
        Intrinsics.checkNotNullParameter(schedulerService, "schedulerService");
        Intrinsics.checkNotNullParameter(clearVisualisation, "clearVisualisation");
        Intrinsics.checkNotNullParameter(clearSelectionVisualisation, "clearSelectionVisualisation");
        Intrinsics.checkNotNullParameter(config, "config");
        this.playerStateRepository = playerStateRepository;
        this.schedulerService = schedulerService;
        this.clearVisualisation = clearVisualisation;
        this.clearSelectionVisualisation = clearSelectionVisualisation;
        this.config = config;
    }

    @NotNull
    public final ScheduleClearVisualisationResult execute(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        PlayerState playerState = this.playerStateRepository.get(playerId);
        if (playerState == null) {
            playerState = new PlayerState(playerId);
            this.playerStateRepository.add(playerState);
        }
        Task task = playerState.getScheduledVisualiserHide();
        if (task != null) {
            task.cancel();
        }
        playerState.setScheduledVisualiserHide(null);
        if (playerState.isVisualisingClaims()) {
            playerState.setVisualisingClaims(false);
            long delayTicks = (long)((double)20L * this.config.getVisualiserHideDelayPeriod());
            Task task2 = this.schedulerService.schedule(delayTicks, () -> ScheduleClearVisualisation.execute$lambda$0(this, playerId));
            playerState.setScheduledVisualiserHide(task2);
            return ScheduleClearVisualisationResult.Success.INSTANCE;
        }
        return ScheduleClearVisualisationResult.PlayerNotVisualising.INSTANCE;
    }

    private static final Unit execute$lambda$0(ScheduleClearVisualisation this$0, UUID $playerId) {
        this$0.clearVisualisation.execute($playerId);
        this$0.clearSelectionVisualisation.execute($playerId);
        return Unit.INSTANCE;
    }
}

