/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.domain.entities;

import dev.mizarc.bellclaims.domain.values.Position3D;
import java.time.Instant;
import java.util.HashMap;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000fB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u0010J\u0006\u00100\u001a\u000201J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0007H\u00c6\u0003J\t\u00106\u001a\u00020\tH\u00c6\u0003J\t\u00107\u001a\u00020\tH\u00c6\u0003J\t\u00108\u001a\u00020\fH\u00c6\u0003J\t\u00109\u001a\u00020\tH\u00c6\u0003JY\u0010:\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\tH\u00c6\u0001J\u0013\u0010;\u001a\u00020)2\b\u0010<\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010=\u001a\u00020\"H\u00d6\u0001J\t\u0010>\u001a\u00020\tH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\"X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006?"}, d2={"Ldev/mizarc/bellclaims/domain/entities/Claim;", "", "id", "Ljava/util/UUID;", "worldId", "playerId", "creationTime", "Ljava/time/Instant;", "name", "", "description", "position", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "icon", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;Ljava/util/UUID;Ljava/time/Instant;Ljava/lang/String;Ljava/lang/String;Ldev/mizarc/bellclaims/domain/values/Position3D;Ljava/lang/String;)V", "(Ljava/util/UUID;Ljava/util/UUID;Ldev/mizarc/bellclaims/domain/values/Position3D;Ljava/lang/String;)V", "getId", "()Ljava/util/UUID;", "setId", "(Ljava/util/UUID;)V", "getWorldId", "setWorldId", "getPlayerId", "setPlayerId", "getCreationTime", "()Ljava/time/Instant;", "getName", "()Ljava/lang/String;", "getDescription", "getPosition", "()Ldev/mizarc/bellclaims/domain/values/Position3D;", "getIcon", "breakCount", "", "getBreakCount", "()I", "setBreakCount", "(I)V", "defaultBreakCount", "breakPeriod", "", "transferRequests", "Ljava/util/HashMap;", "getTransferRequests", "()Ljava/util/HashMap;", "setTransferRequests", "(Ljava/util/HashMap;)V", "resetBreakCount", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaim.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Claim.kt\ndev/mizarc/bellclaims/domain/entities/Claim\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class Claim {
    @NotNull
    private UUID id;
    @NotNull
    private UUID worldId;
    @NotNull
    private UUID playerId;
    @NotNull
    private final Instant creationTime;
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final Position3D position;
    @NotNull
    private final String icon;
    private int breakCount;
    private final int defaultBreakCount;
    private boolean breakPeriod;
    @NotNull
    private HashMap<UUID, Integer> transferRequests;

    public Claim(@NotNull UUID id, @NotNull UUID worldId, @NotNull UUID playerId, @NotNull Instant creationTime, @NotNull String name, @NotNull String description, @NotNull Position3D position, @NotNull String icon) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(creationTime, "creationTime");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(description, "description");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(icon, "icon");
        this.id = id;
        this.worldId = worldId;
        this.playerId = playerId;
        this.creationTime = creationTime;
        this.name = name;
        this.description = description;
        this.position = position;
        this.icon = icon;
        int n = this.name.length();
        if (!(1 <= n ? n < 51 : false)) {
            boolean $i$a$-require-Claim$32 = false;
            String $i$a$-require-Claim$32 = "Name must be between 1 and 50 characters.";
            throw new IllegalArgumentException($i$a$-require-Claim$32.toString());
        }
        if (!(this.description.length() <= 300)) {
            boolean bl = false;
            String string = "Description cannot exceed 300 characters.";
            throw new IllegalArgumentException(string.toString());
        }
        this.breakCount = 3;
        this.defaultBreakCount = 3;
        this.transferRequests = new HashMap();
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    public final void setId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "<set-?>");
        this.id = uUID;
    }

    @NotNull
    public final UUID getWorldId() {
        return this.worldId;
    }

    public final void setWorldId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "<set-?>");
        this.worldId = uUID;
    }

    @NotNull
    public final UUID getPlayerId() {
        return this.playerId;
    }

    public final void setPlayerId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "<set-?>");
        this.playerId = uUID;
    }

    @NotNull
    public final Instant getCreationTime() {
        return this.creationTime;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final Position3D getPosition() {
        return this.position;
    }

    @NotNull
    public final String getIcon() {
        return this.icon;
    }

    public final int getBreakCount() {
        return this.breakCount;
    }

    public final void setBreakCount(int n) {
        this.breakCount = n;
    }

    @NotNull
    public final HashMap<UUID, Integer> getTransferRequests() {
        return this.transferRequests;
    }

    public final void setTransferRequests(@NotNull HashMap<UUID, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.transferRequests = hashMap;
    }

    public Claim(@NotNull UUID worldId, @NotNull UUID playerId, @NotNull Position3D position, @NotNull String name) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(name, "name");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue(instant, "now(...)");
        this(uUID, worldId, playerId, instant, name, "", position, "BELL");
    }

    public final void resetBreakCount() {
        if (!this.breakPeriod) {
            ThreadsKt.thread$default(true, false, null, null, 0, () -> Claim.resetBreakCount$lambda$0(this), 30, null);
        }
    }

    @NotNull
    public final UUID component1() {
        return this.id;
    }

    @NotNull
    public final UUID component2() {
        return this.worldId;
    }

    @NotNull
    public final UUID component3() {
        return this.playerId;
    }

    @NotNull
    public final Instant component4() {
        return this.creationTime;
    }

    @NotNull
    public final String component5() {
        return this.name;
    }

    @NotNull
    public final String component6() {
        return this.description;
    }

    @NotNull
    public final Position3D component7() {
        return this.position;
    }

    @NotNull
    public final String component8() {
        return this.icon;
    }

    @NotNull
    public final Claim copy(@NotNull UUID id, @NotNull UUID worldId, @NotNull UUID playerId, @NotNull Instant creationTime, @NotNull String name, @NotNull String description, @NotNull Position3D position, @NotNull String icon) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(creationTime, "creationTime");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(description, "description");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(icon, "icon");
        return new Claim(id, worldId, playerId, creationTime, name, description, position, icon);
    }

    public static /* synthetic */ Claim copy$default(Claim claim, UUID uUID, UUID uUID2, UUID uUID3, Instant instant, String string, String string2, Position3D position3D, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = claim.id;
        }
        if ((n & 2) != 0) {
            uUID2 = claim.worldId;
        }
        if ((n & 4) != 0) {
            uUID3 = claim.playerId;
        }
        if ((n & 8) != 0) {
            instant = claim.creationTime;
        }
        if ((n & 0x10) != 0) {
            string = claim.name;
        }
        if ((n & 0x20) != 0) {
            string2 = claim.description;
        }
        if ((n & 0x40) != 0) {
            position3D = claim.position;
        }
        if ((n & 0x80) != 0) {
            string3 = claim.icon;
        }
        return claim.copy(uUID, uUID2, uUID3, instant, string, string2, position3D, string3);
    }

    @NotNull
    public String toString() {
        return "Claim(id=" + this.id + ", worldId=" + this.worldId + ", playerId=" + this.playerId + ", creationTime=" + this.creationTime + ", name=" + this.name + ", description=" + this.description + ", position=" + this.position + ", icon=" + this.icon + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.worldId.hashCode();
        result = result * 31 + this.playerId.hashCode();
        result = result * 31 + this.creationTime.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.description.hashCode();
        result = result * 31 + this.position.hashCode();
        result = result * 31 + this.icon.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Claim)) {
            return false;
        }
        Claim claim = (Claim)other;
        if (!Intrinsics.areEqual(this.id, claim.id)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.worldId, claim.worldId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.playerId, claim.playerId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.creationTime, claim.creationTime)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.name, claim.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.description, claim.description)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.position, claim.position)) {
            return false;
        }
        return Intrinsics.areEqual(this.icon, claim.icon);
    }

    private static final Unit resetBreakCount$lambda$0(Claim this$0) {
        this$0.breakPeriod = true;
        Thread.sleep(10000L);
        this$0.breakCount = this$0.defaultBreakCount;
        this$0.breakPeriod = false;
        return Unit.INSTANCE;
    }
}

