/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.domain.entities;

import dev.mizarc.bellclaims.domain.exceptions.IncompletePartitionBuilderException;
import dev.mizarc.bellclaims.domain.values.Area;
import dev.mizarc.bellclaims.domain.values.Position;
import dev.mizarc.bellclaims.domain.values.Position2D;
import java.util.ArrayList;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002,-B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0000J\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u001fj\b\u0012\u0004\u0012\u00020\u0018` J\u0006\u0010!\u001a\u00020\"J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J'\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010'\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\"H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Ldev/mizarc/bellclaims/domain/entities/Partition;", "", "id", "Ljava/util/UUID;", "claimId", "area", "Ldev/mizarc/bellclaims/domain/values/Area;", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;Ldev/mizarc/bellclaims/domain/values/Area;)V", "(Ljava/util/UUID;Ldev/mizarc/bellclaims/domain/values/Area;)V", "builder", "Ldev/mizarc/bellclaims/domain/entities/Partition$Builder;", "(Ldev/mizarc/bellclaims/domain/entities/Partition$Builder;)V", "getId", "()Ljava/util/UUID;", "getClaimId", "getArea", "()Ldev/mizarc/bellclaims/domain/values/Area;", "isPositionInPartition", "", "position", "Ldev/mizarc/bellclaims/domain/values/Position;", "isPositionInCorner", "position2D", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "isAreaOverlap", "areaQuery", "isPartitionAdjacent", "partition", "isPartitionLinked", "getChunks", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getBlockCount", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "Builder", "Resizer", "BellClaims"})
public final class Partition {
    @NotNull
    private final UUID id;
    @NotNull
    private final UUID claimId;
    @NotNull
    private final Area area;

    public Partition(@NotNull UUID id, @NotNull UUID claimId, @NotNull Area area) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(area, "area");
        this.id = id;
        this.claimId = claimId;
        this.area = area;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public final UUID getClaimId() {
        return this.claimId;
    }

    @NotNull
    public final Area getArea() {
        return this.area;
    }

    public Partition(@NotNull UUID claimId, @NotNull Area area) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(area, "area");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
        this(uUID, claimId, area);
    }

    public Partition(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        this(builder.getId(), builder.getClaimId(), new Area(builder.getFirstPosition2D(), builder.getSecondPosition2D()));
    }

    public final boolean isPositionInPartition(@NotNull Position position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return this.area.isPositionInArea(position);
    }

    public final boolean isPositionInCorner(@NotNull Position2D position2D) {
        Intrinsics.checkNotNullParameter(position2D, "position2D");
        return this.area.isPositionInCorner(position2D);
    }

    public final boolean isAreaOverlap(@NotNull Area areaQuery) {
        Intrinsics.checkNotNullParameter(areaQuery, "areaQuery");
        return this.area.isAreaOverlap(areaQuery);
    }

    public final boolean isPartitionAdjacent(@NotNull Partition partition) {
        Intrinsics.checkNotNullParameter(partition, "partition");
        return this.area.isAreaAdjacent(partition.area);
    }

    public final boolean isPartitionLinked(@NotNull Partition partition) {
        Intrinsics.checkNotNullParameter(partition, "partition");
        return this.isPartitionAdjacent(partition) && Intrinsics.areEqual(partition.claimId, this.claimId);
    }

    @NotNull
    public final ArrayList<Position2D> getChunks() {
        int n;
        Position2D firstChunk = this.area.getLowerPosition2D().getChunk();
        Position2D secondChunk = this.area.getUpperPosition2D().getChunk();
        ArrayList<Position2D> chunks = new ArrayList<Position2D>();
        int x = firstChunk.getX();
        if (x <= (n = secondChunk.getX())) {
            while (true) {
                int n2;
                int z;
                if ((z = firstChunk.getZ()) <= (n2 = secondChunk.getZ())) {
                    while (true) {
                        chunks.add(new Position2D(x, z));
                        if (z == n2) break;
                        ++z;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        return chunks;
    }

    public final int getBlockCount() {
        return this.area.getBlockCount();
    }

    @NotNull
    public final UUID component1() {
        return this.id;
    }

    @NotNull
    public final UUID component2() {
        return this.claimId;
    }

    @NotNull
    public final Area component3() {
        return this.area;
    }

    @NotNull
    public final Partition copy(@NotNull UUID id, @NotNull UUID claimId, @NotNull Area area) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(area, "area");
        return new Partition(id, claimId, area);
    }

    public static /* synthetic */ Partition copy$default(Partition partition, UUID uUID, UUID uUID2, Area area, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = partition.id;
        }
        if ((n & 2) != 0) {
            uUID2 = partition.claimId;
        }
        if ((n & 4) != 0) {
            area = partition.area;
        }
        return partition.copy(uUID, uUID2, area);
    }

    @NotNull
    public String toString() {
        return "Partition(id=" + this.id + ", claimId=" + this.claimId + ", area=" + this.area + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.claimId.hashCode();
        result = result * 31 + this.area.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Partition)) {
            return false;
        }
        Partition partition = (Partition)other;
        if (!Intrinsics.areEqual(this.id, partition.id)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.claimId, partition.claimId)) {
            return false;
        }
        return Intrinsics.areEqual(this.area, partition.area);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\r\u00a8\u0006\u0015"}, d2={"Ldev/mizarc/bellclaims/domain/entities/Partition$Builder;", "", "claimId", "Ljava/util/UUID;", "firstPosition2D", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "<init>", "(Ljava/util/UUID;Ldev/mizarc/bellclaims/domain/values/Position2D;)V", "getClaimId", "()Ljava/util/UUID;", "getFirstPosition2D", "()Ldev/mizarc/bellclaims/domain/values/Position2D;", "setFirstPosition2D", "(Ldev/mizarc/bellclaims/domain/values/Position2D;)V", "id", "getId", "secondPosition2D", "getSecondPosition2D", "setSecondPosition2D", "build", "Ldev/mizarc/bellclaims/domain/entities/Partition;", "BellClaims"})
    public static final class Builder {
        @NotNull
        private final UUID claimId;
        @NotNull
        private Position2D firstPosition2D;
        @NotNull
        private final UUID id;
        public Position2D secondPosition2D;

        public Builder(@NotNull UUID claimId, @NotNull Position2D firstPosition2D) {
            Intrinsics.checkNotNullParameter(claimId, "claimId");
            Intrinsics.checkNotNullParameter(firstPosition2D, "firstPosition2D");
            this.claimId = claimId;
            this.firstPosition2D = firstPosition2D;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
            this.id = uUID;
        }

        @NotNull
        public final UUID getClaimId() {
            return this.claimId;
        }

        @NotNull
        public final Position2D getFirstPosition2D() {
            return this.firstPosition2D;
        }

        public final void setFirstPosition2D(@NotNull Position2D position2D) {
            Intrinsics.checkNotNullParameter(position2D, "<set-?>");
            this.firstPosition2D = position2D;
        }

        @NotNull
        public final UUID getId() {
            return this.id;
        }

        @NotNull
        public final Position2D getSecondPosition2D() {
            Position2D position2D = this.secondPosition2D;
            if (position2D != null) {
                return position2D;
            }
            Intrinsics.throwUninitializedPropertyAccessException("secondPosition2D");
            return null;
        }

        public final void setSecondPosition2D(@NotNull Position2D position2D) {
            Intrinsics.checkNotNullParameter(position2D, "<set-?>");
            this.secondPosition2D = position2D;
        }

        @NotNull
        public final Partition build() {
            if (this.secondPosition2D == null) {
                throw new IncompletePartitionBuilderException("Builder requires a filled second position.");
            }
            return new Partition(this);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Ldev/mizarc/bellclaims/domain/entities/Partition$Resizer;", "", "partition", "Ldev/mizarc/bellclaims/domain/entities/Partition;", "selectedCorner", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "<init>", "(Ldev/mizarc/bellclaims/domain/entities/Partition;Ldev/mizarc/bellclaims/domain/values/Position2D;)V", "getPartition", "()Ldev/mizarc/bellclaims/domain/entities/Partition;", "getSelectedCorner", "()Ldev/mizarc/bellclaims/domain/values/Position2D;", "newArea", "Ldev/mizarc/bellclaims/domain/values/Area;", "getNewArea", "()Ldev/mizarc/bellclaims/domain/values/Area;", "setNewArea", "(Ldev/mizarc/bellclaims/domain/values/Area;)V", "getExtraBlockCount", "", "setNewCorner", "", "newPosition2D", "BellClaims"})
    public static final class Resizer {
        @NotNull
        private final Partition partition;
        @NotNull
        private final Position2D selectedCorner;
        public Area newArea;

        public Resizer(@NotNull Partition partition, @NotNull Position2D selectedCorner) {
            Intrinsics.checkNotNullParameter(partition, "partition");
            Intrinsics.checkNotNullParameter(selectedCorner, "selectedCorner");
            this.partition = partition;
            this.selectedCorner = selectedCorner;
        }

        @NotNull
        public final Partition getPartition() {
            return this.partition;
        }

        @NotNull
        public final Position2D getSelectedCorner() {
            return this.selectedCorner;
        }

        @NotNull
        public final Area getNewArea() {
            Area area = this.newArea;
            if (area != null) {
                return area;
            }
            Intrinsics.throwUninitializedPropertyAccessException("newArea");
            return null;
        }

        public final void setNewArea(@NotNull Area area) {
            Intrinsics.checkNotNullParameter(area, "<set-?>");
            this.newArea = area;
        }

        public final int getExtraBlockCount() {
            return Math.abs((this.getNewArea().getUpperPosition2D().getX() - this.getNewArea().getLowerPosition2D().getX() + 1) * (this.getNewArea().getUpperPosition2D().getZ() - this.getNewArea().getLowerPosition2D().getZ() + 1)) - Math.abs((this.partition.getArea().getUpperPosition2D().getX() - this.partition.getArea().getLowerPosition2D().getX() + 1) * (this.partition.getArea().getUpperPosition2D().getZ() - this.partition.getArea().getLowerPosition2D().getZ() + 1));
        }

        public final void setNewCorner(@NotNull Position2D newPosition2D) {
            Intrinsics.checkNotNullParameter(newPosition2D, "newPosition2D");
            Position2D firstPosition2D = this.selectedCorner.getX() == this.partition.getArea().getLowerPosition2D().getX() ? new Position2D(newPosition2D.getX(), 0) : new Position2D(this.partition.getArea().getLowerPosition2D().getX(), 0);
            Position2D secondPosition2D = this.selectedCorner.getX() == this.partition.getArea().getUpperPosition2D().getX() ? new Position2D(newPosition2D.getX(), 0) : new Position2D(this.partition.getArea().getUpperPosition2D().getX(), 0);
            firstPosition2D = this.selectedCorner.getZ() == this.partition.getArea().getLowerPosition2D().getZ() ? new Position2D(firstPosition2D.getX(), newPosition2D.getZ()) : new Position2D(firstPosition2D.getX(), this.partition.getArea().getLowerPosition2D().getZ());
            secondPosition2D = this.selectedCorner.getZ() == this.partition.getArea().getUpperPosition2D().getZ() ? new Position2D(secondPosition2D.getX(), newPosition2D.getZ()) : new Position2D(secondPosition2D.getX(), this.partition.getArea().getUpperPosition2D().getZ());
            this.setNewArea(new Area(firstPosition2D, secondPosition2D));
        }
    }
}

