/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.domain.values;

import dev.mizarc.bellclaims.domain.values.Position;
import dev.mizarc.bellclaims.domain.values.Position2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0019j\b\u0012\u0004\u0012\u00020\u0003`\u001aJ\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0017J\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0019j\b\u0012\u0004\u0012\u00020\u0003`\u001aJ\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0019j\b\u0012\u0004\u0012\u00020\u0003`\u001aJ\u0011\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 \u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0019j\b\u0012\u0004\u0012\u00020\u0003`\u001aJ\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0019j\b\u0012\u0004\u0012\u00020\u0003`\u001aJ\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0019j\b\u0012\u0004\u0012\u00020\u0003`\u001aJ\b\u0010%\u001a\u00020&H\u0002J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010*\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020\u0017H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006/"}, d2={"Ldev/mizarc/bellclaims/domain/values/Area;", "", "lowerPosition2D", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "upperPosition2D", "<init>", "(Ldev/mizarc/bellclaims/domain/values/Position2D;Ldev/mizarc/bellclaims/domain/values/Position2D;)V", "getLowerPosition2D", "()Ldev/mizarc/bellclaims/domain/values/Position2D;", "setLowerPosition2D", "(Ldev/mizarc/bellclaims/domain/values/Position2D;)V", "getUpperPosition2D", "setUpperPosition2D", "isPositionInCorner", "", "position2D", "isPositionInArea", "position", "Ldev/mizarc/bellclaims/domain/values/Position;", "isAreaOverlap", "area", "isAreaAdjacent", "getBlockCount", "", "getChunks", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getXLength", "getZLength", "getCornerBlockPositions", "getEdgeBlockPositions", "getTopEdgeBlockPositions", "", "()[Ldev/mizarc/bellclaims/domain/values/Position2D;", "getBottomEdgeBlockPositions", "getLeftEdgeBlockPositions", "getRightEdgeBlockPositions", "sortPositionSizes", "", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nArea.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Area.kt\ndev/mizarc/bellclaims/domain/values/Area\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,241:1\n37#2,2:242\n*S KotlinDebug\n*F\n+ 1 Area.kt\ndev/mizarc/bellclaims/domain/values/Area\n*L\n184#1:242,2\n*E\n"})
public final class Area {
    @NotNull
    private Position2D lowerPosition2D;
    @NotNull
    private Position2D upperPosition2D;

    public Area(@NotNull Position2D lowerPosition2D, @NotNull Position2D upperPosition2D) {
        Intrinsics.checkNotNullParameter(lowerPosition2D, "lowerPosition2D");
        Intrinsics.checkNotNullParameter(upperPosition2D, "upperPosition2D");
        this.lowerPosition2D = lowerPosition2D;
        this.upperPosition2D = upperPosition2D;
        this.sortPositionSizes();
    }

    @NotNull
    public final Position2D getLowerPosition2D() {
        return this.lowerPosition2D;
    }

    public final void setLowerPosition2D(@NotNull Position2D position2D) {
        Intrinsics.checkNotNullParameter(position2D, "<set-?>");
        this.lowerPosition2D = position2D;
    }

    @NotNull
    public final Position2D getUpperPosition2D() {
        return this.upperPosition2D;
    }

    public final void setUpperPosition2D(@NotNull Position2D position2D) {
        Intrinsics.checkNotNullParameter(position2D, "<set-?>");
        this.upperPosition2D = position2D;
    }

    public final boolean isPositionInCorner(@NotNull Position2D position2D) {
        Intrinsics.checkNotNullParameter(position2D, "position2D");
        if (Intrinsics.areEqual(position2D, this.lowerPosition2D) || Intrinsics.areEqual(position2D, this.upperPosition2D)) {
            return true;
        }
        if (Intrinsics.areEqual(position2D, new Position2D(this.lowerPosition2D.getX(), this.upperPosition2D.getZ()))) {
            return true;
        }
        return Intrinsics.areEqual(position2D, new Position2D(this.upperPosition2D.getX(), this.lowerPosition2D.getZ()));
    }

    public final boolean isPositionInArea(@NotNull Position position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return position.getX() >= this.lowerPosition2D.getX() && position.getX() <= this.upperPosition2D.getX() && position.getZ() >= this.lowerPosition2D.getZ() && position.getZ() <= this.upperPosition2D.getZ();
    }

    public final boolean isAreaOverlap(@NotNull Area area) {
        Intrinsics.checkNotNullParameter(area, "area");
        return this.lowerPosition2D.getX() <= area.upperPosition2D.getX() && this.upperPosition2D.getX() >= area.lowerPosition2D.getX() && this.lowerPosition2D.getZ() <= area.upperPosition2D.getZ() && this.upperPosition2D.getZ() >= area.lowerPosition2D.getZ();
    }

    public final boolean isAreaAdjacent(@NotNull Area area) {
        Object object;
        Intrinsics.checkNotNullParameter(area, "area");
        if (area.upperPosition2D.getZ() < this.lowerPosition2D.getZ()) {
            for (Position2D block2 : area.getTopEdgeBlockPositions()) {
                if (!this.isPositionInArea(new Position2D(block2.getX(), block2.getZ() + 1))) continue;
                return true;
            }
        }
        if (area.lowerPosition2D.getZ() > this.upperPosition2D.getZ()) {
            Iterator<Position2D> iterator2 = area.getBottomEdgeBlockPositions().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            object = iterator2;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                Position2D block3 = (Position2D)e;
                if (!this.isPositionInArea(new Position2D(block3.getX(), block3.getZ() - 1))) continue;
                return true;
            }
        }
        if (area.lowerPosition2D.getX() > this.upperPosition2D.getX()) {
            Iterator<Position2D> iterator3 = area.getLeftEdgeBlockPositions().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
            object = iterator3;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                Position2D block4 = (Position2D)e;
                if (!this.isPositionInArea(new Position2D(block4.getX() - 1, block4.getZ()))) continue;
                return true;
            }
        }
        if (area.upperPosition2D.getX() < this.lowerPosition2D.getX()) {
            Iterator<Position2D> iterator4 = area.getRightEdgeBlockPositions().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
            object = iterator4;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                Position2D block5 = (Position2D)e;
                if (!this.isPositionInArea(new Position2D(block5.getX() + 1, block5.getZ()))) continue;
                return true;
            }
        }
        return false;
    }

    public final int getBlockCount() {
        return Math.abs((this.upperPosition2D.getX() - this.lowerPosition2D.getX() + 1) * (this.upperPosition2D.getZ() - this.lowerPosition2D.getZ() + 1));
    }

    @NotNull
    public final ArrayList<Position2D> getChunks() {
        int n;
        Position2D firstChunk = this.lowerPosition2D.getChunk();
        Position2D secondChunk = this.upperPosition2D.getChunk();
        ArrayList<Position2D> chunks = new ArrayList<Position2D>();
        int x = firstChunk.getX();
        if (x <= (n = secondChunk.getX())) {
            while (true) {
                int n2;
                int z;
                if ((z = firstChunk.getZ()) <= (n2 = secondChunk.getZ())) {
                    while (true) {
                        chunks.add(new Position2D(x, z));
                        if (z == n2) break;
                        ++z;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        return chunks;
    }

    public final int getXLength() {
        return Math.abs(this.upperPosition2D.getX() - this.lowerPosition2D.getX() + 1);
    }

    public final int getZLength() {
        return Math.abs(this.upperPosition2D.getZ() - this.lowerPosition2D.getZ() + 1);
    }

    @NotNull
    public final ArrayList<Position2D> getCornerBlockPositions() {
        ArrayList<Position2D> position2DS = new ArrayList<Position2D>();
        position2DS.add(this.lowerPosition2D);
        position2DS.add(this.upperPosition2D);
        position2DS.add(new Position2D(this.lowerPosition2D.getX(), this.upperPosition2D.getZ()));
        position2DS.add(new Position2D(this.upperPosition2D.getX(), this.lowerPosition2D.getZ()));
        return position2DS;
    }

    @NotNull
    public final ArrayList<Position2D> getEdgeBlockPositions() {
        int n;
        ArrayList<Position2D> blocks = new ArrayList<Position2D>();
        int block2 = this.lowerPosition2D.getX();
        if (block2 <= (n = this.upperPosition2D.getX())) {
            while (true) {
                blocks.add(new Position2D(block2, this.lowerPosition2D.getZ()));
                blocks.add(new Position2D(block2, this.upperPosition2D.getZ()));
                if (block2 == n) break;
                ++block2;
            }
        }
        if ((block2 = this.lowerPosition2D.getZ()) <= (n = this.upperPosition2D.getZ())) {
            while (true) {
                blocks.add(new Position2D(this.lowerPosition2D.getX(), block2));
                blocks.add(new Position2D(this.upperPosition2D.getX(), block2));
                if (block2 == n) break;
                ++block2;
            }
        }
        return blocks;
    }

    @NotNull
    public final Position2D[] getTopEdgeBlockPositions() {
        int n;
        ArrayList<Position2D> blocks = new ArrayList<Position2D>();
        int block2 = this.lowerPosition2D.getX();
        if (block2 <= (n = this.upperPosition2D.getX())) {
            while (true) {
                blocks.add(new Position2D(block2, this.upperPosition2D.getZ()));
                if (block2 == n) break;
                ++block2;
            }
        }
        Collection $this$toTypedArray$iv = blocks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Position2D[0]);
    }

    @NotNull
    public final ArrayList<Position2D> getBottomEdgeBlockPositions() {
        int n;
        ArrayList<Position2D> blocks = new ArrayList<Position2D>();
        int block2 = this.lowerPosition2D.getX();
        if (block2 <= (n = this.upperPosition2D.getX())) {
            while (true) {
                blocks.add(new Position2D(block2, this.lowerPosition2D.getZ()));
                if (block2 == n) break;
                ++block2;
            }
        }
        return blocks;
    }

    @NotNull
    public final ArrayList<Position2D> getLeftEdgeBlockPositions() {
        int n;
        ArrayList<Position2D> blocks = new ArrayList<Position2D>();
        int block2 = this.lowerPosition2D.getZ();
        if (block2 <= (n = this.upperPosition2D.getZ())) {
            while (true) {
                blocks.add(new Position2D(this.lowerPosition2D.getX(), block2));
                if (block2 == n) break;
                ++block2;
            }
        }
        return blocks;
    }

    @NotNull
    public final ArrayList<Position2D> getRightEdgeBlockPositions() {
        int n;
        ArrayList<Position2D> blocks = new ArrayList<Position2D>();
        int block2 = this.lowerPosition2D.getZ();
        if (block2 <= (n = this.upperPosition2D.getZ())) {
            while (true) {
                blocks.add(new Position2D(this.upperPosition2D.getX(), block2));
                if (block2 == n) break;
                ++block2;
            }
        }
        return blocks;
    }

    private final void sortPositionSizes() {
        Position2D newUpperPosition2D;
        Position2D newLowerPosition2D;
        if (this.lowerPosition2D.getX() > this.upperPosition2D.getX()) {
            newLowerPosition2D = new Position2D(this.upperPosition2D.getX(), this.lowerPosition2D.getZ());
            newUpperPosition2D = new Position2D(this.lowerPosition2D.getX(), this.upperPosition2D.getZ());
            this.lowerPosition2D = newLowerPosition2D;
            this.upperPosition2D = newUpperPosition2D;
        }
        if (this.lowerPosition2D.getZ() > this.upperPosition2D.getZ()) {
            newLowerPosition2D = new Position2D(this.lowerPosition2D.getX(), this.upperPosition2D.getZ());
            newUpperPosition2D = new Position2D(this.upperPosition2D.getX(), this.lowerPosition2D.getZ());
            this.lowerPosition2D = newLowerPosition2D;
            this.upperPosition2D = newUpperPosition2D;
        }
    }

    @NotNull
    public final Position2D component1() {
        return this.lowerPosition2D;
    }

    @NotNull
    public final Position2D component2() {
        return this.upperPosition2D;
    }

    @NotNull
    public final Area copy(@NotNull Position2D lowerPosition2D, @NotNull Position2D upperPosition2D) {
        Intrinsics.checkNotNullParameter(lowerPosition2D, "lowerPosition2D");
        Intrinsics.checkNotNullParameter(upperPosition2D, "upperPosition2D");
        return new Area(lowerPosition2D, upperPosition2D);
    }

    public static /* synthetic */ Area copy$default(Area area, Position2D position2D, Position2D position2D2, int n, Object object) {
        if ((n & 1) != 0) {
            position2D = area.lowerPosition2D;
        }
        if ((n & 2) != 0) {
            position2D2 = area.upperPosition2D;
        }
        return area.copy(position2D, position2D2);
    }

    @NotNull
    public String toString() {
        return "Area(lowerPosition2D=" + this.lowerPosition2D + ", upperPosition2D=" + this.upperPosition2D + ")";
    }

    public int hashCode() {
        int result = this.lowerPosition2D.hashCode();
        result = result * 31 + this.upperPosition2D.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Area)) {
            return false;
        }
        Area area = (Area)other;
        if (!Intrinsics.areEqual(this.lowerPosition2D, area.lowerPosition2D)) {
            return false;
        }
        return Intrinsics.areEqual(this.upperPosition2D, area.upperPosition2D);
    }
}

