/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure;

import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014J\b\u0010\u001b\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/mizarc/bellclaims/infrastructure/ChatInfoBuilder;", "", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "playerId", "Ljava/util/UUID;", "title", "", "<init>", "(Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;Ljava/util/UUID;Ljava/lang/String;)V", "elements", "Lnet/kyori/adventure/text/TextComponent$Builder;", "Lorg/jetbrains/annotations/NotNull;", "addHeader", "", "text", "addParagraph", "addRow", "addIndexed", "index", "", "addSpace", "create", "Lnet/kyori/adventure/text/Component;", "createPaged", "currentPage", "pages", "newLine", "BellClaims"})
public final class ChatInfoBuilder {
    @NotNull
    private final LocalizationProvider localizationProvider;
    @NotNull
    private final UUID playerId;
    @NotNull
    private final String title;
    @NotNull
    private TextComponent.Builder elements;

    public ChatInfoBuilder(@NotNull LocalizationProvider localizationProvider, @NotNull UUID playerId, @NotNull String title) {
        Intrinsics.checkNotNullParameter(localizationProvider, "localizationProvider");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(title, "title");
        this.localizationProvider = localizationProvider;
        this.playerId = playerId;
        this.title = title;
        TextComponent.Builder builder = Component.text();
        Intrinsics.checkNotNullExpressionValue(builder, "text(...)");
        this.elements = builder;
        this.elements.append((Component)Component.text((String)"-----", (TextColor)((TextColor)NamedTextColor.WHITE)));
        this.elements.append((Component)Component.text((String)(" " + this.title + " "), (TextColor)((TextColor)NamedTextColor.DARK_AQUA)));
        this.elements.append((Component)Component.text((String)"-----", (TextColor)((TextColor)NamedTextColor.WHITE)));
    }

    public final void addHeader(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.newLine();
        this.elements.append((Component)Component.text((String)text, (TextColor)((TextColor)NamedTextColor.BLUE)));
    }

    public final void addParagraph(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.newLine();
        this.elements.append((Component)Component.text((String)text, (TextColor)((TextColor)NamedTextColor.GRAY)));
    }

    public final void addRow(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.newLine();
        this.elements.append((Component)Component.text((String)text, (TextColor)((TextColor)NamedTextColor.WHITE)));
    }

    public final void addIndexed(int index, @NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.newLine();
        Object[] objectArray = new Object[]{index, text};
        String indexedRow = this.localizationProvider.get(this.playerId, "command.info_box.index", objectArray);
        this.elements.append((Component)Component.text((String)indexedRow, (TextColor)((TextColor)NamedTextColor.WHITE)));
    }

    public final void addSpace() {
        this.newLine();
    }

    @NotNull
    public final Component create() {
        ComponentBuilder componentBuilder = this.elements.append((Component)Component.text((String)"\n-----", (TextColor)((TextColor)NamedTextColor.WHITE)));
        Intrinsics.checkNotNullExpressionValue(componentBuilder, "append(...)");
        TextComponent.Builder finalisedElement = (TextComponent.Builder)componentBuilder;
        BuildableComponent buildableComponent = finalisedElement.build();
        Intrinsics.checkNotNullExpressionValue(buildableComponent, "build(...)");
        return (Component)buildableComponent;
    }

    @NotNull
    public final Component createPaged(int currentPage, int pages) {
        Object[] objectArray = new Object[]{currentPage, pages};
        String pageText = this.localizationProvider.get(this.playerId, "command.info_box.paged", objectArray);
        ComponentBuilder componentBuilder = ((TextComponent.Builder)this.elements.append((Component)Component.text((String)"\n-----", (TextColor)((TextColor)NamedTextColor.WHITE)))).append((Component)Component.text((String)pageText, (TextColor)((TextColor)NamedTextColor.DARK_AQUA)));
        Intrinsics.checkNotNullExpressionValue(componentBuilder, "append(...)");
        TextComponent.Builder finalisedElement = (TextComponent.Builder)componentBuilder;
        BuildableComponent buildableComponent = finalisedElement.build();
        Intrinsics.checkNotNullExpressionValue(buildableComponent, "build(...)");
        return (Component)buildableComponent;
    }

    private final void newLine() {
        this.elements.append((Component)Component.text((String)"\n"));
    }
}

