/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.persistence;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u00106\u001a\u000207J\b\u00108\u001a\u000207H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001b\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R\u001a\u0010\u001e\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u00069"}, d2={"Ldev/mizarc/bellclaims/infrastructure/persistence/Config;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "configFile", "Lorg/bukkit/configuration/file/FileConfiguration;", "Lorg/jetbrains/annotations/NotNull;", "getConfigFile", "()Lorg/bukkit/configuration/file/FileConfiguration;", "setConfigFile", "(Lorg/bukkit/configuration/file/FileConfiguration;)V", "claimLimit", "", "getClaimLimit", "()I", "setClaimLimit", "(I)V", "claimBlockLimit", "getClaimBlockLimit", "setClaimBlockLimit", "initialClaimSize", "getInitialClaimSize", "setInitialClaimSize", "minimumPartitionSize", "getMinimumPartitionSize", "setMinimumPartitionSize", "distanceBetweenClaims", "getDistanceBetweenClaims", "setDistanceBetweenClaims", "visualiserHideDelayPeriod", "", "getVisualiserHideDelayPeriod", "()D", "setVisualiserHideDelayPeriod", "(D)V", "visualiserRefreshPeriod", "getVisualiserRefreshPeriod", "setVisualiserRefreshPeriod", "rightClickHarvest", "", "getRightClickHarvest", "()Z", "setRightClickHarvest", "(Z)V", "pluginLanguage", "", "getPluginLanguage", "()Ljava/lang/String;", "setPluginLanguage", "(Ljava/lang/String;)V", "loadConfig", "", "createDefaultConfig", "BellClaims"})
public final class Config {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private FileConfiguration configFile;
    private int claimLimit;
    private int claimBlockLimit;
    private int initialClaimSize;
    private int minimumPartitionSize;
    private int distanceBetweenClaims;
    private double visualiserHideDelayPeriod;
    private double visualiserRefreshPeriod;
    private boolean rightClickHarvest;
    @NotNull
    private String pluginLanguage;

    public Config(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.configFile = fileConfiguration;
        this.rightClickHarvest = true;
        this.pluginLanguage = "EN";
        this.createDefaultConfig();
        this.loadConfig();
    }

    @NotNull
    public final Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public final void setConfigFile(@NotNull FileConfiguration fileConfiguration) {
        Intrinsics.checkNotNullParameter(fileConfiguration, "<set-?>");
        this.configFile = fileConfiguration;
    }

    public final int getClaimLimit() {
        return this.claimLimit;
    }

    public final void setClaimLimit(int n) {
        this.claimLimit = n;
    }

    public final int getClaimBlockLimit() {
        return this.claimBlockLimit;
    }

    public final void setClaimBlockLimit(int n) {
        this.claimBlockLimit = n;
    }

    public final int getInitialClaimSize() {
        return this.initialClaimSize;
    }

    public final void setInitialClaimSize(int n) {
        this.initialClaimSize = n;
    }

    public final int getMinimumPartitionSize() {
        return this.minimumPartitionSize;
    }

    public final void setMinimumPartitionSize(int n) {
        this.minimumPartitionSize = n;
    }

    public final int getDistanceBetweenClaims() {
        return this.distanceBetweenClaims;
    }

    public final void setDistanceBetweenClaims(int n) {
        this.distanceBetweenClaims = n;
    }

    public final double getVisualiserHideDelayPeriod() {
        return this.visualiserHideDelayPeriod;
    }

    public final void setVisualiserHideDelayPeriod(double d) {
        this.visualiserHideDelayPeriod = d;
    }

    public final double getVisualiserRefreshPeriod() {
        return this.visualiserRefreshPeriod;
    }

    public final void setVisualiserRefreshPeriod(double d) {
        this.visualiserRefreshPeriod = d;
    }

    public final boolean getRightClickHarvest() {
        return this.rightClickHarvest;
    }

    public final void setRightClickHarvest(boolean bl) {
        this.rightClickHarvest = bl;
    }

    @NotNull
    public final String getPluginLanguage() {
        return this.pluginLanguage;
    }

    public final void setPluginLanguage(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.pluginLanguage = string;
    }

    public final void loadConfig() {
        this.claimLimit = this.configFile.getInt("claim_limit");
        this.claimBlockLimit = this.configFile.getInt("claim_block_limit");
        this.initialClaimSize = Math.max(3, this.configFile.getInt("initial_claim_size"));
        this.minimumPartitionSize = Math.max(3, this.configFile.getInt("minimum_partition_size"));
        this.distanceBetweenClaims = this.configFile.getInt("distance_between_claims");
        this.visualiserHideDelayPeriod = this.configFile.getDouble("visualiser_hide_delay_period");
        this.visualiserRefreshPeriod = this.configFile.getDouble("visualiser_refresh_period");
        this.rightClickHarvest = this.configFile.getBoolean("right_click_harvest");
        String string = this.configFile.getString("plugin_language");
        if (string == null) {
            string = "EN";
        }
        this.pluginLanguage = string;
    }

    private final void createDefaultConfig() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
    }
}

