/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.persistence.claims;

import co.aikar.idb.DbRow;
import dev.mizarc.bellclaims.application.errors.DatabaseOperationException;
import dev.mizarc.bellclaims.application.persistence.ClaimFlagRepository;
import dev.mizarc.bellclaims.domain.values.Flag;
import dev.mizarc.bellclaims.infrastructure.persistence.storage.SQLiteStorage;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/mizarc/bellclaims/infrastructure/persistence/claims/ClaimFlagRepositorySQLite;", "Ldev/mizarc/bellclaims/application/persistence/ClaimFlagRepository;", "storage", "Ldev/mizarc/bellclaims/infrastructure/persistence/storage/SQLiteStorage;", "<init>", "(Ldev/mizarc/bellclaims/infrastructure/persistence/storage/SQLiteStorage;)V", "flags", "", "Ljava/util/UUID;", "", "Ldev/mizarc/bellclaims/domain/values/Flag;", "doesClaimHaveFlag", "", "claimId", "flag", "getByClaim", "", "add", "remove", "removeByClaim", "createTable", "", "preload", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimFlagRepositorySQLite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimFlagRepositorySQLite.kt\ndev/mizarc/bellclaims/infrastructure/persistence/claims/ClaimFlagRepositorySQLite\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,97:1\n382#2,7:98\n382#2,7:105\n*S KotlinDebug\n*F\n+ 1 ClaimFlagRepositorySQLite.kt\ndev/mizarc/bellclaims/infrastructure/persistence/claims/ClaimFlagRepositorySQLite\n*L\n28#1:98,7\n94#1:105,7\n*E\n"})
public final class ClaimFlagRepositorySQLite
implements ClaimFlagRepository {
    @NotNull
    private final SQLiteStorage storage;
    @NotNull
    private final Map<UUID, Set<Flag>> flags;

    public ClaimFlagRepositorySQLite(@NotNull SQLiteStorage storage) {
        Intrinsics.checkNotNullParameter(storage, "storage");
        this.storage = storage;
        this.flags = new LinkedHashMap();
        this.createTable();
        this.preload();
    }

    @Override
    public boolean doesClaimHaveFlag(@NotNull UUID claimId, @NotNull Flag flag) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        Set<Flag> set2 = this.flags.get(claimId);
        return set2 != null ? set2.contains((Object)flag) : false;
    }

    @Override
    @NotNull
    public Set<Flag> getByClaim(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Set<Flag> set2 = this.flags.get(claimId);
        if (set2 == null || (set2 = CollectionsKt.toSet((Iterable)set2)) == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(@NotNull UUID claimId, @NotNull Flag flag) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        Map<UUID, Set<Flag>> map2 = this.flags;
        Object[] key$iv = claimId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(flag);
        try {
            key$iv = new Object[]{claimId, flag.name()};
            int rowsAffected = this.storage.getConnection().executeUpdate("INSERT INTO claim_flags (claim_id, flag) VALUES (?,?) ON CONFLICT (claim_id, flag) DO NOTHING;", key$iv);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to add flag '" + flag + "' for claim_id '" + (UUID)claimId + "' to the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean remove(@NotNull UUID claimId, @NotNull Flag flag) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        Set<Flag> set2 = this.flags.get(claimId);
        if (set2 == null) {
            return false;
        }
        Set<Flag> claimFlags = set2;
        claimFlags.remove((Object)flag);
        if (claimFlags.isEmpty()) {
            this.flags.remove(claimId);
        }
        try {
            Object[] objectArray = new Object[]{claimId, flag.name()};
            int rowsAffected = this.storage.getConnection().executeUpdate("DELETE FROM claim_flags WHERE claim_id=? AND flag=?", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to remove flag '" + flag + "' for claim_id '" + claimId + "' from the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean removeByClaim(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        this.flags.remove(claimId);
        try {
            Object[] objectArray = new Object[]{claimId};
            int rowsAffected = this.storage.getConnection().executeUpdate("DELETE FROM claim_flags WHERE claim_id=?", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to remove all flags for claim " + claimId + " from the database. Cause: " + error.getMessage(), error);
        }
    }

    private final void createTable() {
        try {
            this.storage.getConnection().executeUpdate("CREATE TABLE IF NOT EXISTS claim_flags (claim_id TEXT, flag TEXT, FOREIGN KEY (claim_id) REFERENCES claims(id), UNIQUE (claim_id, flag))", new Object[0]);
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to create 'claim_flags' table. Cause: " + error.getMessage(), error);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void preload() {
        List<DbRow> results = this.storage.getConnection().getResults("SELECT * FROM claim_flags", new Object[0]);
        for (DbRow result : results) {
            Object object;
            void $this$getOrPut$iv;
            UUID claimId = UUID.fromString(result.getString("claim_id"));
            String string = result.getString("flag");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            Flag flag = Flag.valueOf(string);
            Map<UUID, Set<Flag>> map2 = this.flags;
            UUID key$iv = claimId;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(flag);
        }
    }
}

