/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.persistence.claims;

import co.aikar.idb.DbRow;
import dev.mizarc.bellclaims.application.errors.DatabaseOperationException;
import dev.mizarc.bellclaims.application.persistence.ClaimPermissionRepository;
import dev.mizarc.bellclaims.domain.values.ClaimPermission;
import dev.mizarc.bellclaims.infrastructure.persistence.storage.SQLiteStorage;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/mizarc/bellclaims/infrastructure/persistence/claims/ClaimPermissionRepositorySQLite;", "Ldev/mizarc/bellclaims/application/persistence/ClaimPermissionRepository;", "storage", "Ldev/mizarc/bellclaims/infrastructure/persistence/storage/SQLiteStorage;", "<init>", "(Ldev/mizarc/bellclaims/infrastructure/persistence/storage/SQLiteStorage;)V", "permissions", "", "Ljava/util/UUID;", "", "Ldev/mizarc/bellclaims/domain/values/ClaimPermission;", "doesClaimHavePermission", "", "claimId", "permission", "getByClaim", "", "add", "remove", "removeByClaim", "createTable", "", "preload", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimPermissionRepositorySQLite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimPermissionRepositorySQLite.kt\ndev/mizarc/bellclaims/infrastructure/persistence/claims/ClaimPermissionRepositorySQLite\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,101:1\n382#2,7:102\n382#2,7:109\n*S KotlinDebug\n*F\n+ 1 ClaimPermissionRepositorySQLite.kt\ndev/mizarc/bellclaims/infrastructure/persistence/claims/ClaimPermissionRepositorySQLite\n*L\n28#1:102,7\n94#1:109,7\n*E\n"})
public final class ClaimPermissionRepositorySQLite
implements ClaimPermissionRepository {
    @NotNull
    private final SQLiteStorage storage;
    @NotNull
    private final Map<UUID, Set<ClaimPermission>> permissions;

    public ClaimPermissionRepositorySQLite(@NotNull SQLiteStorage storage) {
        Intrinsics.checkNotNullParameter(storage, "storage");
        this.storage = storage;
        this.permissions = new LinkedHashMap();
        this.createTable();
        this.preload();
    }

    @Override
    public boolean doesClaimHavePermission(@NotNull UUID claimId, @NotNull ClaimPermission permission) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter((Object)permission, "permission");
        Set<ClaimPermission> set2 = this.permissions.get(claimId);
        return set2 != null ? set2.contains((Object)permission) : false;
    }

    @Override
    @NotNull
    public Set<ClaimPermission> getByClaim(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Set<ClaimPermission> set2 = this.permissions.get(claimId);
        if (set2 == null || (set2 = CollectionsKt.toSet((Iterable)set2)) == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(@NotNull UUID claimId, @NotNull ClaimPermission permission) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter((Object)permission, "permission");
        Map<UUID, Set<ClaimPermission>> map2 = this.permissions;
        Object[] key$iv = claimId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(permission);
        try {
            key$iv = new Object[]{claimId, permission.name()};
            int rowsAffected = this.storage.getConnection().executeUpdate("INSERT INTO claim_default_permissions (claim_id, permission) VALUES (?,?) ON CONFLICT (claim_id, permission) DO NOTHING", key$iv);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to add permission '" + permission + "' for claim_id '" + (UUID)claimId + "' to the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean remove(@NotNull UUID claimId, @NotNull ClaimPermission permission) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter((Object)permission, "permission");
        Set<ClaimPermission> set2 = this.permissions.get(claimId);
        if (set2 == null) {
            return false;
        }
        Set<ClaimPermission> claimPermissions = set2;
        claimPermissions.remove((Object)permission);
        if (claimPermissions.isEmpty()) {
            this.permissions.remove(claimId);
        }
        try {
            Object[] objectArray = new Object[]{claimId, permission.name()};
            int rowsAffected = this.storage.getConnection().executeUpdate("DELETE FROM claim_default_permissions WHERE claim_id=? AND permission=?", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to remove permission '" + permission + "' for claim_id '" + claimId + "' from the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean removeByClaim(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        this.permissions.remove(claimId);
        try {
            Object[] objectArray = new Object[]{claimId};
            int rowsAffected = this.storage.getConnection().executeUpdate("DELETE FROM claim_default_permissions WHERE claim_id=?", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to remove all permissions for claim_id " + claimId + " from the database. Cause: " + error.getMessage(), error);
        }
    }

    private final void createTable() {
        try {
            this.storage.getConnection().executeUpdate("CREATE TABLE IF NOT EXISTS claim_default_permissions (claim_id TEXT, permission TEXT, FOREIGN KEY(claim_id) REFERENCES claims(id), UNIQUE (claim_id, permission))", new Object[0]);
        }
        catch (SQLException error) {
            error.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void preload() {
        List<DbRow> results = this.storage.getConnection().getResults("SELECT * FROM claim_default_permissions", new Object[0]);
        for (DbRow result : results) {
            try {
                Object object;
                void $this$getOrPut$iv;
                String string = result.getString("permission");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                ClaimPermission permission = ClaimPermission.valueOf(string);
                Map<UUID, Set<ClaimPermission>> map2 = this.permissions;
                UUID key$iv = UUID.fromString(result.getString("claim_id"));
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(permission);
            }
            catch (IllegalArgumentException error) {}
        }
    }
}

