/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.persistence.claims;

import co.aikar.idb.DbRow;
import dev.mizarc.bellclaims.application.errors.DatabaseOperationException;
import dev.mizarc.bellclaims.application.persistence.ClaimRepository;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.values.Position3D;
import dev.mizarc.bellclaims.infrastructure.persistence.storage.SQLiteStorage;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Ldev/mizarc/bellclaims/infrastructure/persistence/claims/ClaimRepositorySQLite;", "Ldev/mizarc/bellclaims/application/persistence/ClaimRepository;", "storage", "Ldev/mizarc/bellclaims/infrastructure/persistence/storage/SQLiteStorage;", "<init>", "(Ldev/mizarc/bellclaims/infrastructure/persistence/storage/SQLiteStorage;)V", "claims", "", "Ljava/util/UUID;", "Ldev/mizarc/bellclaims/domain/entities/Claim;", "getClaims", "()Ljava/util/Map;", "getAll", "", "getById", "id", "getByPlayer", "playerId", "getByName", "name", "", "getByPosition", "position", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "worldId", "add", "", "claim", "update", "remove", "claimId", "createClaimTable", "", "preload", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimRepositorySQLite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimRepositorySQLite.kt\ndev/mizarc/bellclaims/infrastructure/persistence/claims/ClaimRepositorySQLite\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n774#2:116\n865#2,2:117\n295#2,2:119\n295#2,2:121\n*S KotlinDebug\n*F\n+ 1 ClaimRepositorySQLite.kt\ndev/mizarc/bellclaims/infrastructure/persistence/claims/ClaimRepositorySQLite\n*L\n29#1:116\n29#1:117,2\n33#1:119,2\n37#1:121,2\n*E\n"})
public final class ClaimRepositorySQLite
implements ClaimRepository {
    @NotNull
    private final SQLiteStorage storage;
    @NotNull
    private final Map<UUID, Claim> claims;

    public ClaimRepositorySQLite(@NotNull SQLiteStorage storage) {
        Intrinsics.checkNotNullParameter(storage, "storage");
        this.storage = storage;
        this.claims = new LinkedHashMap();
        this.createClaimTable();
        this.preload();
    }

    @NotNull
    public final Map<UUID, Claim> getClaims() {
        return this.claims;
    }

    @Override
    @NotNull
    public Set<Claim> getAll() {
        return CollectionsKt.toSet((Iterable)this.claims.values());
    }

    @Override
    @Nullable
    public Claim getById(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter(id, "id");
        return this.claims.get(id);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Claim> getByPlayer(@NotNull UUID playerId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Iterable $this$filter$iv = this.claims.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Claim it = (Claim)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getPlayerId(), playerId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    @Nullable
    public Claim getByName(@NotNull UUID playerId, @NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$firstOrNull$iv = this.claims.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Claim it = (Claim)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getPlayerId(), playerId) && Intrinsics.areEqual(it.getName(), name))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Nullable
    public Claim getByPosition(@NotNull Position3D position, @NotNull UUID worldId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(worldId, "worldId");
            Iterable $this$firstOrNull$iv = this.claims.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Claim it = (Claim)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getPosition(), position) && Intrinsics.areEqual(it.getWorldId(), worldId))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public boolean add(@NotNull Claim claim) {
        Intrinsics.checkNotNullParameter(claim, "claim");
        this.claims.put(claim.getId(), claim);
        try {
            Object[] objectArray = new Object[]{claim.getId(), claim.getWorldId(), claim.getPlayerId(), claim.getCreationTime(), claim.getName(), claim.getDescription(), claim.getPosition().getX(), claim.getPosition().getY(), claim.getPosition().getZ(), claim.getIcon()};
            int rowsAffected = this.storage.getConnection().executeUpdate("INSERT INTO claims (id, world_id, owner_id, creation_time, name, description, position_x, position_y, position_z, icon) VALUES (?,?,?,?,?,?,?,?,?,?);", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to add claim '" + claim.getName() + "' to the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean update(@NotNull Claim claim) {
        Intrinsics.checkNotNullParameter(claim, "claim");
        this.claims.remove(claim.getId());
        this.claims.put(claim.getId(), claim);
        try {
            Object[] objectArray = new Object[]{claim.getWorldId(), claim.getPlayerId(), claim.getCreationTime(), claim.getName(), claim.getDescription(), claim.getPosition().getX(), claim.getPosition().getY(), claim.getPosition().getZ(), claim.getIcon(), claim.getId()};
            int rowsAffected = this.storage.getConnection().executeUpdate("UPDATE claims SET world_id=?, owner_id=?, creation_time=?, name=?, description=?, position_x=?, position_y=?, position_z=?, icon=? WHERE id=?;", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to add update claim '" + claim.getName() + "' in the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean remove(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        this.claims.remove(claimId);
        try {
            Object[] objectArray = new Object[]{claimId};
            int rowsAffected = this.storage.getConnection().executeUpdate("DELETE FROM claims WHERE id=?;", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to remove claim '" + claimId + "' from the database. Cause: " + error.getMessage(), error);
        }
    }

    private final void createClaimTable() {
        try {
            this.storage.getConnection().executeUpdate("CREATE TABLE IF NOT EXISTS claims (id TEXT PRIMARY KEY, world_id TEXT NOT NULL, owner_id TEXT NOT NULL, creation_time TEXT NOT NULL, name TEXT, description TEXT, position_x INT, position_y INT, position_z INT, icon TEXT);", new Object[0]);
        }
        catch (SQLException error) {
            error.printStackTrace();
        }
    }

    private final void preload() {
        try {
            List<DbRow> results = this.storage.getConnection().getResults("SELECT * FROM claims", new Object[0]);
            for (DbRow result : results) {
                UUID uUID = UUID.fromString(result.getString("id"));
                Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
                UUID uUID2 = UUID.fromString(result.getString("world_id"));
                Intrinsics.checkNotNullExpressionValue(uUID2, "fromString(...)");
                UUID uUID3 = UUID.fromString(result.getString("owner_id"));
                Intrinsics.checkNotNullExpressionValue(uUID3, "fromString(...)");
                Instant instant = Instant.parse(result.getString("creation_time"));
                Intrinsics.checkNotNullExpressionValue(instant, "parse(...)");
                String string = result.getString("name");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String string2 = result.getString("description");
                Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                Integer n = result.getInt("position_x");
                Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
                int n2 = ((Number)n).intValue();
                Integer n3 = result.getInt("position_y");
                Intrinsics.checkNotNullExpressionValue(n3, "getInt(...)");
                int n4 = ((Number)n3).intValue();
                Integer n5 = result.getInt("position_z");
                Intrinsics.checkNotNullExpressionValue(n5, "getInt(...)");
                Position3D position3D = new Position3D(n2, n4, ((Number)n5).intValue());
                String string3 = result.getString("icon");
                Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
                Claim claim = new Claim(uUID, uUID2, uUID3, instant, string, string2, position3D, string3);
                this.claims.put(claim.getId(), claim);
            }
        }
        catch (SQLException error) {
            error.printStackTrace();
        }
    }
}

