/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.persistence.claims;

import co.aikar.idb.DbRow;
import dev.mizarc.bellclaims.application.errors.DatabaseOperationException;
import dev.mizarc.bellclaims.application.persistence.PlayerAccessRepository;
import dev.mizarc.bellclaims.domain.values.ClaimPermission;
import dev.mizarc.bellclaims.infrastructure.persistence.storage.SQLiteStorage;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\"\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00120\u00112\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u000e\u001a\u00020\bH\u0016J \u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0016J \u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0006\u001a \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/mizarc/bellclaims/infrastructure/persistence/claims/PlayerAccessRepositorySQLite;", "Ldev/mizarc/bellclaims/application/persistence/PlayerAccessRepository;", "storage", "Ldev/mizarc/bellclaims/infrastructure/persistence/storage/SQLiteStorage;", "<init>", "(Ldev/mizarc/bellclaims/infrastructure/persistence/storage/SQLiteStorage;)V", "playerAccess", "", "Ljava/util/UUID;", "", "Ldev/mizarc/bellclaims/domain/values/ClaimPermission;", "doesPlayerHavePermission", "", "playerId", "claimId", "permission", "getForAllPlayersInClaim", "", "", "getForPlayerInClaim", "getPlayersWithPermissionInClaim", "add", "remove", "removeByPlayer", "removeByClaim", "createTable", "", "preload", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nPlayerAccessRepositorySQLite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerAccessRepositorySQLite.kt\ndev/mizarc/bellclaims/infrastructure/persistence/claims/PlayerAccessRepositorySQLite\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,124:1\n382#2,7:125\n382#2,7:132\n382#2,7:139\n*S KotlinDebug\n*F\n+ 1 PlayerAccessRepositorySQLite.kt\ndev/mizarc/bellclaims/infrastructure/persistence/claims/PlayerAccessRepositorySQLite\n*L\n35#1:125,7\n116#1:132,7\n117#1:139,7\n*E\n"})
public final class PlayerAccessRepositorySQLite
implements PlayerAccessRepository {
    @NotNull
    private final SQLiteStorage storage;
    @NotNull
    private final Map<UUID, Map<UUID, Set<ClaimPermission>>> playerAccess;

    public PlayerAccessRepositorySQLite(@NotNull SQLiteStorage storage) {
        Intrinsics.checkNotNullParameter(storage, "storage");
        this.storage = storage;
        this.playerAccess = new LinkedHashMap();
        this.createTable();
        this.preload();
    }

    @Override
    public boolean doesPlayerHavePermission(@NotNull UUID playerId, @NotNull UUID claimId, @NotNull ClaimPermission permission) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter((Object)permission, "permission");
        Map<UUID, Set<ClaimPermission>> map2 = this.playerAccess.get(claimId);
        return map2 != null && (map2 = map2.get(playerId)) != null ? map2.contains((Object)permission) : false;
    }

    @Override
    @NotNull
    public Map<UUID, Set<ClaimPermission>> getForAllPlayersInClaim(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Map<UUID, Set<ClaimPermission>> map2 = this.playerAccess.get(claimId);
        if (map2 == null || (map2 = MapsKt.toMap(map2)) == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    @Override
    @NotNull
    public Set<ClaimPermission> getForPlayerInClaim(@NotNull UUID claimId, @NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Object object = this.playerAccess.get(claimId);
        if (object == null || (object = object.get(playerId)) == null || (object = CollectionsKt.toSet((Iterable)object)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Override
    @NotNull
    public Set<UUID> getPlayersWithPermissionInClaim(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Object object = this.playerAccess.get(claimId);
        if (object == null || (object = object.keySet()) == null || (object = CollectionsKt.toSet((Iterable)object)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Override
    public boolean add(@NotNull UUID claimId, @NotNull UUID playerId, @NotNull ClaimPermission permission) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)permission, "permission");
        Map<UUID, Map<UUID, Set<ClaimPermission>>> map2 = this.playerAccess;
        Object[] key$iv = claimId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        key$iv = playerId;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(permission);
        try {
            key$iv = new Object[]{claimId, playerId, permission.name()};
            int rowsAffected = this.storage.getConnection().executeUpdate("INSERT INTO claim_player_permissions (claim_id, player_id, permission) VALUES (?,?,?) ON CONFLICT (claim_id, player_id, permission) DO NOTHING", key$iv);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to add permission '" + permission + "' for claim_id '" + (UUID)claimId + "' to the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean remove(@NotNull UUID claimId, @NotNull UUID playerId, @NotNull ClaimPermission permission) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)permission, "permission");
        Map<UUID, Set<ClaimPermission>> map2 = this.playerAccess.get(claimId);
        if (map2 == null) {
            return false;
        }
        Map<UUID, Set<ClaimPermission>> claimPermissions = map2;
        Set<ClaimPermission> set2 = claimPermissions.get(playerId);
        if (set2 == null) {
            return false;
        }
        Set<ClaimPermission> playerPermissions = set2;
        playerPermissions.remove((Object)permission);
        if (playerPermissions.isEmpty()) {
            claimPermissions.remove(playerId);
        }
        try {
            Object[] objectArray = new Object[]{claimId, playerId, permission.name()};
            int rowsAffected = this.storage.getConnection().executeUpdate("DELETE FROM claim_player_permissions WHERE claim_id=? AND player_id=? AND permission=?", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to remove permission '" + permission + "' for player_id '" + playerId + "' in claim_id '" + claimId + "' from the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean removeByPlayer(@NotNull UUID claimId, @NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Map<UUID, Set<ClaimPermission>> map2 = this.playerAccess.get(claimId);
        if (map2 == null) {
            return false;
        }
        Map<UUID, Set<ClaimPermission>> claimPermissions = map2;
        claimPermissions.remove(playerId);
        try {
            Object[] objectArray = new Object[]{claimId, playerId};
            int rowsAffected = this.storage.getConnection().executeUpdate("DELETE FROM claim_player_permissions WHERE claim_id=? AND player_id=?", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to remove permissions for player_id '" + playerId + "' in claim_id '" + claimId + "' from the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean removeByClaim(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        this.playerAccess.remove(claimId);
        try {
            Object[] objectArray = new Object[]{claimId};
            int rowsAffected = this.storage.getConnection().executeUpdate("DELETE FROM claim_player_permissions WHERE claim_id=?", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to remove permissions for claim_id '" + claimId + "' from the database. Cause: " + error.getMessage(), error);
        }
    }

    private final void createTable() {
        try {
            this.storage.getConnection().executeUpdate("CREATE TABLE IF NOT EXISTS claim_player_permissions (claim_id TEXT, player_id TEXT, permission TEXT, FOREIGN KEY(claim_id) REFERENCES claims(id), UNIQUE (claim_id, player_id, permission));", new Object[0]);
        }
        catch (SQLException error) {
            error.printStackTrace();
        }
    }

    private final void preload() {
        List<DbRow> results = this.storage.getConnection().getResults("SELECT * FROM claim_player_permissions", new Object[0]);
        for (DbRow result : results) {
            UUID playerId = UUID.fromString(result.getString("player_id"));
            UUID claimId = UUID.fromString(result.getString("claim_id"));
            try {
                Object object;
                Map claimPlayers;
                Object object2;
                Object answer$iv;
                Map $this$getOrPut$iv;
                String string = result.getString("permission");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                ClaimPermission permission = ClaimPermission.valueOf(string);
                Map<UUID, Map<UUID, Set<ClaimPermission>>> map2 = this.playerAccess;
                UUID key$iv = claimId;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to(playerId, (Set)new LinkedHashSet())};
                    answer$iv = MapsKt.mutableMapOf(pairArray);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                $this$getOrPut$iv = claimPlayers = (Map)object2;
                key$iv = playerId;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(permission);
            }
            catch (IllegalArgumentException error) {}
        }
    }
}

