/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.persistence.migrations;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0002J\u0016\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/mizarc/bellclaims/infrastructure/persistence/migrations/SQLiteMigrations;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "connection", "Ljava/sql/Connection;", "<init>", "(Lorg/bukkit/plugin/java/JavaPlugin;Ljava/sql/Connection;)V", "migrate", "", "getCurrentDatabaseVersion", "", "updateDatabaseVersion", "version", "migrateToVersion2", "executeMigrationCommands", "commands", "", "", "executeSql", "sql", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nSQLiteMigrations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLiteMigrations.kt\ndev/mizarc/bellclaims/infrastructure/persistence/migrations/SQLiteMigrations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,276:1\n1878#2,3:277\n*S KotlinDebug\n*F\n+ 1 SQLiteMigrations.kt\ndev/mizarc/bellclaims/infrastructure/persistence/migrations/SQLiteMigrations\n*L\n252#1:277,3\n*E\n"})
public final class SQLiteMigrations {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final Connection connection;

    public SQLiteMigrations(@NotNull JavaPlugin plugin, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(connection, "connection");
        this.plugin = plugin;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void migrate() {
        try {
            this.connection.setAutoCommit(false);
            int currentDbVersion = this.getCurrentDatabaseVersion();
            this.plugin.getLogger().info("Current database schema version: v" + currentDbVersion);
            if (currentDbVersion < 2) {
                this.plugin.getLogger().info("Starting database migration from v" + currentDbVersion + " to v2...");
                this.migrateToVersion2();
                this.updateDatabaseVersion(2);
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Database migration failed: " + e.getMessage());
            e.printStackTrace();
            try {
                this.connection.rollback();
                this.plugin.getLogger().warning("Database migration transaction rolled back.");
            }
            catch (SQLException rb) {
                this.plugin.getLogger().severe("Failed to rollback database migration: " + rb.getMessage());
            }
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getCurrentDatabaseVersion() {
        AutoCloseable autoCloseable = this.connection.createStatement();
        Throwable throwable = null;
        try {
            int n;
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = stmt.executeQuery("PRAGMA user_version;");
            Throwable throwable2 = null;
            try {
                int version;
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                n = version = rs.next() ? rs.getInt(1) : 0;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            int n2 = n;
            return n2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateDatabaseVersion(int version) {
        AutoCloseable autoCloseable = this.connection.createStatement();
        Throwable throwable = null;
        try {
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            boolean bl2 = stmt.execute("PRAGMA user_version = " + version + ";");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private final void migrateToVersion2() {
        this.plugin.getLogger().info("Starting migration to database v2.");
        List sqlCommands = new ArrayList();
        sqlCommands.add("PRAGMA foreign_keys = OFF;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("ALTER TABLE claimPartitions RENAME TO claim_partitions;");
        sqlCommands.add("ALTER TABLE claimPermissions RENAME TO claim_default_permissions;");
        sqlCommands.add("ALTER TABLE claimRules RENAME TO claim_flags;");
        sqlCommands.add("ALTER TABLE playerAccess RENAME TO claim_player_permissions;");
        sqlCommands.add("ALTER TABLE claims RENAME TO claims_old;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("CREATE TABLE claims (\n    id TEXT PRIMARY KEY,\n    world_id TEXT,\n    owner_id TEXT,\n    creation_time TEXT,\n    name TEXT,\n    description TEXT,\n    position_x INTEGER,\n    position_y INTEGER,\n    position_z INTEGER,\n    icon TEXT\n);");
        sqlCommands.add("INSERT INTO claims (id, world_id, owner_id, creation_time, name, description, position_x, position_y, position_z, icon)\nSELECT id, worldId, ownerId, creationTime, name, description, positionX, positionY, positionZ, icon FROM claims_old;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("CREATE TABLE claim_default_permissions_new (\n    claim_id TEXT,\n    permission TEXT,\n    FOREIGN KEY (claim_id) REFERENCES claims(id),\n    UNIQUE (claim_id, permission)\n);");
        sqlCommands.add("INSERT INTO claim_default_permissions_new (claim_id, permission) SELECT claimId, permission FROM claim_default_permissions;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("DROP TABLE claim_default_permissions;");
        sqlCommands.add("ALTER TABLE claim_default_permissions_new RENAME TO claim_default_permissions;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("CREATE TABLE claim_flags_new (\n    claim_id TEXT,\n    flag TEXT,\n    FOREIGN KEY (claim_id) REFERENCES claims(id),\n    UNIQUE (claim_id, flag)\n);");
        sqlCommands.add("INSERT INTO claim_flags_new (claim_id, flag) SELECT claimId, rule FROM claim_flags;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("DROP TABLE claim_flags;");
        sqlCommands.add("ALTER TABLE claim_flags_new RENAME TO claim_flags;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("CREATE TABLE claim_partitions_new (\n    id TEXT PRIMARY KEY,\n    claim_id TEXT,\n    lower_position_x INTEGER,\n    lower_position_z INTEGER,\n    upper_position_x INTEGER,\n    upper_position_z INTEGER\n);");
        sqlCommands.add("INSERT INTO claim_partitions_new (id, claim_id, lower_position_x, lower_position_z, upper_position_x, upper_position_z) SELECT id, claimId, lowerPositionX, lowerPositionZ, upperPositionX, upperPositionZ FROM claim_partitions;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("DROP TABLE claim_partitions;");
        sqlCommands.add("ALTER TABLE claim_partitions_new RENAME TO claim_partitions;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("CREATE TABLE claim_player_permissions_new (\n    claim_id TEXT,\n    player_id TEXT,\n    permission TEXT,\n    FOREIGN KEY (claim_id) REFERENCES claims(id),\n    UNIQUE (claim_id, player_id, permission)\n);");
        sqlCommands.add("INSERT INTO claim_player_permissions_new (claim_id, player_id, permission) SELECT claimId, playerId, permission FROM claim_player_permissions;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("DROP TABLE claim_player_permissions;");
        sqlCommands.add("ALTER TABLE claim_player_permissions_new RENAME TO claim_player_permissions;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("UPDATE claim_flags\nSET flag = CASE\n    WHEN flag = 'FireSpread' THEN 'FIRE'\n    WHEN flag = 'MobGriefing' THEN 'MOB'\n    WHEN flag = 'Explosions' THEN 'EXPLOSION'\n    WHEN flag = 'Pistons' THEN 'PISTON'\n    WHEN flag = 'Fluids' THEN 'FLUID'\n    WHEN flag = 'Trees' THEN 'TREE'\n    WHEN flag = 'Sculk' THEN 'SCULK'\n    WHEN flag = 'Dispensers' THEN 'DISPENSER'\n    WHEN flag = 'Sponge' THEN 'SPONGE'\n    WHEN flag = 'Lightning' THEN 'LIGHTNING'\n    WHEN flag = 'FallingBlock' THEN 'FALLING_BLOCK'\n    ELSE flag\nEND;");
        sqlCommands.add("UPDATE claim_default_permissions\nSET permission = CASE\n    WHEN permission = 'Build' THEN 'BUILD'\n    WHEN permission = 'ContainerInspect' THEN 'CONTAINER'\n    WHEN permission = 'DisplayManipulate' THEN 'DISPLAY'\n    WHEN permission = 'VehicleDeploy' THEN 'VEHICLE'\n    WHEN permission = 'SignEdit' THEN 'SIGN'\n    WHEN permission = 'RedstoneInteract' THEN 'REDSTONE'\n    WHEN permission = 'DoorOpen' THEN 'DOOR'\n    WHEN permission = 'VillagerTrade' THEN 'TRADE'\n    WHEN permission = 'Husbandry' THEN 'HUSBANDRY'\n    WHEN permission = 'Detonate' THEN 'DETONATE'\n    WHEN permission = 'EventStart' THEN 'EVENT'\n    WHEN permission = 'Sleep' THEN 'SLEEP'\n    ELSE permission\nEND;");
        sqlCommands.add("UPDATE claim_player_permissions\nSET permission = CASE\n    WHEN permission = 'Build' THEN 'BUILD'\n    WHEN permission = 'ContainerInspect' THEN 'CONTAINER'\n    WHEN permission = 'DisplayManipulate' THEN 'DISPLAY'\n    WHEN permission = 'VehicleDeploy' THEN 'VEHICLE'\n    WHEN permission = 'SignEdit' THEN 'SIGN'\n    WHEN permission = 'RedstoneInteract' THEN 'REDSTONE'\n    WHEN permission = 'DoorOpen' THEN 'DOOR'\n    WHEN permission = 'VillagerTrade' THEN 'TRADE'\n    WHEN permission = 'Husbandry' THEN 'HUSBANDRY'\n    WHEN permission = 'Detonate' THEN 'DETONATE'\n    WHEN permission = 'EventStart' THEN 'EVENT'\n    WHEN permission = 'Sleep' THEN 'SLEEP'\n    ELSE permission\nEND;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("DROP TABLE claims_old;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        sqlCommands.add("PRAGMA foreign_keys = ON;");
        this.executeMigrationCommands(sqlCommands);
        sqlCommands.clear();
        this.plugin.getLogger().info("Migration to database v2 applied successfully.");
    }

    /*
     * WARNING - void declaration
     */
    private final void executeMigrationCommands(List<String> commands) {
        Iterable $this$forEachIndexed$iv = commands;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void sql;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            this.executeSql((String)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeSql(String sql) {
        AutoCloseable autoCloseable = this.connection.createStatement();
        Throwable throwable = null;
        try {
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            try {
                boolean hasResultSet = stmt.execute(sql);
                if (hasResultSet) {
                    ResultSet resultSet = stmt.getResultSet();
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Failed to execute SQL: " + StringsKt.substringBefore$default(sql, ';', null, 2, null) + ". Error: " + e.getMessage());
                throw e;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }
}

