/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.persistence.partitions;

import co.aikar.idb.Database;
import co.aikar.idb.DbRow;
import dev.mizarc.bellclaims.application.errors.DatabaseOperationException;
import dev.mizarc.bellclaims.application.persistence.PartitionRepository;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.Area;
import dev.mizarc.bellclaims.domain.values.Position;
import dev.mizarc.bellclaims.domain.values.Position2D;
import dev.mizarc.bellclaims.infrastructure.persistence.storage.Storage;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\b\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020!H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\rj\b\u0012\u0004\u0012\u00020\t`\u000e0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldev/mizarc/bellclaims/infrastructure/persistence/partitions/PartitionRepositorySQLite;", "Ldev/mizarc/bellclaims/application/persistence/PartitionRepository;", "storage", "Ldev/mizarc/bellclaims/infrastructure/persistence/storage/Storage;", "Lco/aikar/idb/Database;", "<init>", "(Ldev/mizarc/bellclaims/infrastructure/persistence/storage/Storage;)V", "partitions", "", "Ljava/util/UUID;", "Ldev/mizarc/bellclaims/domain/entities/Partition;", "chunkPartitions", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getAll", "", "getById", "id", "getByClaim", "claimId", "getByChunk", "position", "Ldev/mizarc/bellclaims/domain/values/Position;", "getByPosition", "add", "", "partition", "update", "remove", "partitionId", "removeByClaim", "addToMemory", "", "removeFromMemory", "createTable", "preload", "BellClaims"})
public final class PartitionRepositorySQLite
implements PartitionRepository {
    @NotNull
    private final Storage<Database> storage;
    @NotNull
    private Map<UUID, Partition> partitions;
    @NotNull
    private Map<Position2D, ArrayList<UUID>> chunkPartitions;

    public PartitionRepositorySQLite(@NotNull Storage<Database> storage) {
        Intrinsics.checkNotNullParameter(storage, "storage");
        this.storage = storage;
        this.partitions = new LinkedHashMap();
        this.chunkPartitions = new LinkedHashMap();
        this.createTable();
        this.preload();
    }

    @Override
    @NotNull
    public Set<Partition> getAll() {
        return CollectionsKt.toSet((Iterable)this.partitions.values());
    }

    @Override
    @Nullable
    public Partition getById(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter(id, "id");
        return this.partitions.get(id);
    }

    @Override
    @NotNull
    public Set<Partition> getByClaim(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        ArrayList<Partition> foundPartitions = new ArrayList<Partition>();
        for (Partition partition : this.partitions.values()) {
            if (!Intrinsics.areEqual(partition.getClaimId(), claimId)) continue;
            foundPartitions.add(partition);
        }
        return CollectionsKt.toSet((Iterable)foundPartitions);
    }

    @Override
    @NotNull
    public Set<Partition> getByChunk(@NotNull Position position) {
        Intrinsics.checkNotNullParameter(position, "position");
        Set foundPartitions = new LinkedHashSet();
        ArrayList<UUID> arrayList = this.chunkPartitions.get(position);
        if (arrayList == null) {
            return SetsKt.emptySet();
        }
        ArrayList<UUID> localChunkPartitions = arrayList;
        Iterator<UUID> iterator2 = localChunkPartitions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<UUID> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            UUID id;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Partition partition = this.partitions.get(id);
            if (partition == null) continue;
            foundPartitions.add(partition);
        }
        return foundPartitions;
    }

    @Override
    @NotNull
    public Set<Partition> getByPosition(@NotNull Position position) {
        Intrinsics.checkNotNullParameter(position, "position");
        Set<Partition> partitionsInChunk = this.getByChunk(position.getChunk());
        ArrayList<Partition> partitionsInPosition = new ArrayList<Partition>();
        for (Partition partition : partitionsInChunk) {
            if (!partition.isPositionInPartition(position)) continue;
            partitionsInPosition.add(partition);
        }
        return CollectionsKt.toSet((Iterable)partitionsInPosition);
    }

    @Override
    public boolean add(@NotNull Partition partition) {
        Intrinsics.checkNotNullParameter(partition, "partition");
        this.addToMemory(partition);
        try {
            Object[] objectArray = new Object[]{partition.getId(), partition.getClaimId(), partition.getArea().getLowerPosition2D().getX(), partition.getArea().getLowerPosition2D().getZ(), partition.getArea().getUpperPosition2D().getX(), partition.getArea().getUpperPosition2D().getZ()};
            int rowsAffected = this.storage.getConnection().executeUpdate("INSERT INTO claim_partitions (id, claim_id, lower_position_x, lower_position_z, upper_position_x, upper_position_z) VALUES (?,?,?,?,?,?);", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to add partition '" + partition.getId() + "' to the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean update(@NotNull Partition partition) {
        Intrinsics.checkNotNullParameter(partition, "partition");
        this.removeFromMemory(partition);
        this.addToMemory(partition);
        try {
            Object[] objectArray = new Object[]{partition.getClaimId(), partition.getArea().getLowerPosition2D().getX(), partition.getArea().getLowerPosition2D().getZ(), partition.getArea().getUpperPosition2D().getX(), partition.getArea().getUpperPosition2D().getZ(), partition.getId()};
            int rowsAffected = this.storage.getConnection().executeUpdate("UPDATE claim_partitions SET claim_id=?, lower_position_x=?, lower_position_z=?, upper_position_x=?, upper_position_z=? WHERE id=?;", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to add update partition_id '" + partition.getId() + "' in the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean remove(@NotNull UUID partitionId) {
        Intrinsics.checkNotNullParameter(partitionId, "partitionId");
        Partition partition = this.getById(partitionId);
        if (partition == null) {
            return false;
        }
        Partition partition2 = partition;
        this.removeFromMemory(partition2);
        try {
            Object[] objectArray = new Object[]{partitionId};
            int rowsAffected = this.storage.getConnection().executeUpdate("DELETE FROM claim_partitions WHERE id=?;", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException error) {
            throw new DatabaseOperationException("Failed to remove partition '" + partitionId + "' from the database. Cause: " + error.getMessage(), error);
        }
    }

    @Override
    public boolean removeByClaim(@NotNull UUID claimId) {
        Intrinsics.checkNotNullParameter(claimId, "claimId");
        Set<Partition> partitions = this.getByClaim(claimId);
        for (Partition partition : partitions) {
            this.removeFromMemory(partition);
        }
        try {
            Object[] objectArray = new Object[]{claimId};
            int rowsAffected = this.storage.getConnection().executeUpdate("DELETE FROM claim_partitions WHERE claim_id=?;", objectArray);
            return rowsAffected > 0;
        }
        catch (SQLException sQLException) {
            throw new DatabaseOperationException("Failed to remove partitions for claim '" + claimId + "' from the database. Cause: " + sQLException.getMessage(), sQLException);
        }
    }

    private final void addToMemory(Partition partition) {
        this.partitions.put(partition.getId(), partition);
        ArrayList<Position2D> claimChunks = partition.getChunks();
        Iterator<Position2D> iterator2 = claimChunks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Position2D> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Position2D chunk;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (this.chunkPartitions.get(chunk) == null) {
                this.chunkPartitions.put(chunk, new ArrayList());
            }
            ArrayList<UUID> arrayList = this.chunkPartitions.get(chunk);
            if (arrayList == null) continue;
            arrayList.add(partition.getId());
        }
    }

    private final void removeFromMemory(Partition partition) {
        this.partitions.remove(partition.getId());
        Iterator<Position2D> iterator2 = partition.getArea().getChunks().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Position2D> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ArrayList<UUID> savedChunk;
            Position2D chunk;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (this.chunkPartitions.get(chunk) == null) {
                return;
            }
            savedChunk.remove(partition.getId());
        }
    }

    private final void createTable() {
        try {
            this.storage.getConnection().executeUpdate("CREATE TABLE IF NOT EXISTS claim_partitions (id TEXT, claim_id TEXT, lower_position_x INTEGER NOT NULL, lower_position_z INTEGER NOT NULL, upper_position_x INTEGER NOT NULL, upper_position_z INTEGER NOT NULL);", new Object[0]);
        }
        catch (SQLException error) {
            error.printStackTrace();
        }
    }

    private final void preload() {
        try {
            List<DbRow> results = this.storage.getConnection().getResults("SELECT * FROM claim_partitions", new Object[0]);
            for (DbRow result : results) {
                Iterator<Position2D> iterator2;
                Integer n = result.getInt("lower_position_x");
                Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
                int n2 = ((Number)n).intValue();
                Integer n3 = result.getInt("lower_position_z");
                Intrinsics.checkNotNullExpressionValue(n3, "getInt(...)");
                Position2D position2D = new Position2D(n2, ((Number)n3).intValue());
                Integer n4 = result.getInt("upper_position_x");
                Intrinsics.checkNotNullExpressionValue(n4, "getInt(...)");
                int n5 = ((Number)n4).intValue();
                Integer n6 = result.getInt("upper_position_z");
                Intrinsics.checkNotNullExpressionValue(n6, "getInt(...)");
                Area area = new Area(position2D, new Position2D(n5, ((Number)n6).intValue()));
                UUID uUID = UUID.fromString(result.getString("id"));
                Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
                UUID uUID2 = UUID.fromString(result.getString("claim_id"));
                Intrinsics.checkNotNullExpressionValue(uUID2, "fromString(...)");
                Partition partition = new Partition(uUID, uUID2, area);
                this.partitions.put(partition.getId(), partition);
                Intrinsics.checkNotNullExpressionValue(area.getChunks().iterator(), "iterator(...)");
                while (iterator2.hasNext()) {
                    Position2D chunk;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                    if (this.chunkPartitions.get(chunk) == null) {
                        this.chunkPartitions.put(chunk, new ArrayList());
                    }
                    ArrayList<UUID> arrayList = this.chunkPartitions.get(chunk);
                    if (arrayList == null) continue;
                    arrayList.add(partition.getId());
                }
            }
        }
        catch (SQLException error) {
            error.printStackTrace();
        }
    }
}

